/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.nmsutil;

import ac.grim.grimac.events.packets.PacketWorldBorder;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.potion.PotionTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.Direction;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.chunk.BaseChunk;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.defaulttags.BlockTags;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3d;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3i;
import ac.grim.grimac.shaded.fastutil.doubles.DoubleListIterator;
import ac.grim.grimac.shaded.fastutil.floats.FloatArraySet;
import ac.grim.grimac.shaded.fastutil.floats.FloatArrays;
import ac.grim.grimac.shaded.fastutil.longs.LongOpenHashSet;
import ac.grim.grimac.shaded.fastutil.longs.LongSet;
import ac.grim.grimac.shaded.fastutil.objects.ObjectLinkedOpenHashSet;
import ac.grim.grimac.shaded.jetbrains.annotations.NotNull;
import ac.grim.grimac.utils.chunks.Column;
import ac.grim.grimac.utils.collisions.CollisionData;
import ac.grim.grimac.utils.collisions.datatypes.CollisionBox;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.data.Pair;
import ac.grim.grimac.utils.data.VectorData;
import ac.grim.grimac.utils.data.tags.SyncedTags;
import ac.grim.grimac.utils.latency.CompensatedWorld;
import ac.grim.grimac.utils.math.GrimMath;
import ac.grim.grimac.utils.math.Location;
import ac.grim.grimac.utils.math.Vector3dm;
import ac.grim.grimac.utils.math.VectorUtils;
import ac.grim.grimac.utils.nmsutil.CheckIfChunksLoaded;
import ac.grim.grimac.utils.nmsutil.GetBoundingBox;
import ac.grim.grimac.utils.nmsutil.Materials;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import lombok.Generated;

public final class Collisions {
    private static final double COLLISION_EPSILON = 1.0E-7;
    private static final boolean IS_FOURTEEN = PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_14);
    private static final List<List<Axis>> allAxisCombinations = Arrays.asList(Arrays.asList(Axis.Y, Axis.X, Axis.Z), Arrays.asList(Axis.Y, Axis.Z, Axis.X), Arrays.asList(Axis.X, Axis.Y, Axis.Z), Arrays.asList(Axis.X, Axis.Z, Axis.Y), Arrays.asList(Axis.Z, Axis.X, Axis.Y), Arrays.asList(Axis.Z, Axis.Y, Axis.X));
    private static final List<List<Axis>> nonStupidityCombinations = Arrays.asList(Arrays.asList(Axis.Y, Axis.X, Axis.Z), Arrays.asList(Axis.Y, Axis.Z, Axis.X));
    public static final ImmutableList<Axis> YXZ_AXIS_ORDER = ImmutableList.of((Object)((Object)Axis.Y), (Object)((Object)Axis.X), (Object)((Object)Axis.Z));
    public static final ImmutableList<Axis> YZX_AXIS_ORDER = ImmutableList.of((Object)((Object)Axis.Y), (Object)((Object)Axis.Z), (Object)((Object)Axis.X));

    public static boolean slowCouldPointThreeHitGround(GrimPlayer player, double x, double y, double z) {
        SimpleCollisionBox oldBB = player.boundingBox;
        player.boundingBox = GetBoundingBox.getBoundingBoxFromPosAndSize(player, x, y, z, 0.6f, 0.06f);
        double movementThreshold = player.getMovementThreshold();
        double posXZ = Collisions.collide(player, movementThreshold, -movementThreshold, movementThreshold).getY();
        double negXNegZ = Collisions.collide(player, -movementThreshold, -movementThreshold, -movementThreshold).getY();
        double posXNegZ = Collisions.collide(player, movementThreshold, -movementThreshold, -movementThreshold).getY();
        double posZNegX = Collisions.collide(player, -movementThreshold, -movementThreshold, movementThreshold).getY();
        player.boundingBox = oldBB;
        return negXNegZ != -movementThreshold || posXNegZ != -movementThreshold || posXZ != -movementThreshold || posZNegX != -movementThreshold;
    }

    public static Vector3dm collide(GrimPlayer player, double desiredX, double desiredY, double desiredZ) {
        return Collisions.collide(player, desiredX, desiredY, desiredZ, desiredY, null);
    }

    public static Vector3dm collide(GrimPlayer player, double desiredX, double desiredY, double desiredZ, double clientVelY, VectorData data) {
        if (desiredX == 0.0 && desiredY == 0.0 && desiredZ == 0.0) {
            return new Vector3dm();
        }
        SimpleCollisionBox grabBoxesBB = player.boundingBox.copy();
        double stepUpHeight = player.getMaxUpStep();
        if (desiredX == 0.0 && desiredZ == 0.0) {
            if (desiredY > 0.0) {
                grabBoxesBB.maxY += desiredY;
            } else {
                grabBoxesBB.minY += desiredY;
            }
        } else if (stepUpHeight > 0.0 && (player.lastOnGround || desiredY < 0.0 || clientVelY < 0.0)) {
            if (desiredY <= 0.0) {
                grabBoxesBB.expandToCoordinate(desiredX, desiredY, desiredZ);
                grabBoxesBB.maxY += stepUpHeight;
            } else {
                grabBoxesBB.expandToCoordinate(desiredX, Math.max(stepUpHeight, desiredY), desiredZ);
            }
        } else {
            grabBoxesBB.expandToCoordinate(desiredX, desiredY, desiredZ);
        }
        ArrayList<SimpleCollisionBox> desiredMovementCollisionBoxes = new ArrayList<SimpleCollisionBox>();
        Collisions.getCollisionBoxes(player, grabBoxesBB, desiredMovementCollisionBoxes, false);
        double bestInput = Double.MAX_VALUE;
        Vector3dm bestOrderResult = null;
        Vector3dm bestTheoreticalCollisionResult = VectorUtils.cutBoxToVector(player.actualMovement, new SimpleCollisionBox(0.0, Math.min(0.0, desiredY), 0.0, desiredX, Math.max(stepUpHeight, desiredY), desiredZ).sort());
        int zeroCount = (desiredX == 0.0 ? 1 : 0) + (desiredY == 0.0 ? 1 : 0) + (desiredZ == 0.0 ? 1 : 0);
        for (List<Axis> order : data != null && data.isZeroPointZeroThree() ? allAxisCombinations : nonStupidityCombinations) {
            boolean disallowStepping;
            Vector3dm collisionResult = Collisions.collideBoundingBoxLegacy(new Vector3dm(desiredX, desiredY, desiredZ), player.boundingBox, desiredMovementCollisionBoxes, order);
            boolean movingIntoGroundReal = player.pointThreeEstimator.closeEnoughToGroundToStepWithPointThree(data, clientVelY) || collisionResult.getY() != desiredY && (desiredY < 0.0 || clientVelY < 0.0);
            boolean movingIntoGround = player.lastOnGround || movingIntoGroundReal;
            boolean bl = disallowStepping = player.getSetbackTeleportUtil().getRequiredSetBack() != null && player.getSetbackTeleportUtil().getRequiredSetBack().getTicksComplete() == 1;
            if (!disallowStepping && stepUpHeight > 0.0 && movingIntoGround && (collisionResult.getX() != desiredX || collisionResult.getZ() != desiredZ)) {
                player.uncertaintyHandler.isStepMovement = true;
                if (player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_21)) {
                    float[] stepHeights;
                    SimpleCollisionBox startingOffsetBox = movingIntoGroundReal ? player.boundingBox.copy().offset(0.0, collisionResult.getY(), 0.0) : player.boundingBox.copy();
                    SimpleCollisionBox offsetByHorizAndStepBox = startingOffsetBox.copy().expandToCoordinate(desiredX, stepUpHeight, desiredZ);
                    if (!movingIntoGroundReal) {
                        offsetByHorizAndStepBox = offsetByHorizAndStepBox.copy().expandToCoordinate(0.0, -1.0E-5f, 0.0);
                    }
                    ArrayList<SimpleCollisionBox> stepCollisions = new ArrayList<SimpleCollisionBox>();
                    Collisions.getCollisionBoxes(player, offsetByHorizAndStepBox, stepCollisions, false);
                    for (float stepHeight : stepHeights = Collisions.collectStepHeights(startingOffsetBox, stepCollisions, (float)stepUpHeight, (float)collisionResult.getY())) {
                        Vector3dm vec3d2 = Collisions.collideBoundingBoxLegacy(new Vector3dm(desiredX, (double)stepHeight, desiredZ), startingOffsetBox, stepCollisions, order);
                        if (!(Collisions.getHorizontalDistanceSqr(vec3d2) > Collisions.getHorizontalDistanceSqr(collisionResult))) continue;
                        double d = player.boundingBox.minY - startingOffsetBox.minY;
                        collisionResult = vec3d2.add(new Vector3dm(0.0, -d, 0.0));
                        break;
                    }
                } else {
                    Vector3dm stepUpBugFixResult;
                    Vector3dm stepUpBugFix;
                    Vector3dm regularStepUp = Collisions.collideBoundingBoxLegacy(new Vector3dm(desiredX, stepUpHeight, desiredZ), player.boundingBox, desiredMovementCollisionBoxes, order);
                    if (player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_8) && (stepUpBugFix = Collisions.collideBoundingBoxLegacy(new Vector3dm(0.0, stepUpHeight, 0.0), player.boundingBox.copy().expandToCoordinate(desiredX, 0.0, desiredZ), desiredMovementCollisionBoxes, order)).getY() < stepUpHeight && Collisions.getHorizontalDistanceSqr(stepUpBugFixResult = Collisions.collideBoundingBoxLegacy(new Vector3dm(desiredX, 0.0, desiredZ), player.boundingBox.copy().offset(0.0, stepUpBugFix.getY(), 0.0), desiredMovementCollisionBoxes, order).add(stepUpBugFix)) > Collisions.getHorizontalDistanceSqr(regularStepUp)) {
                        regularStepUp = stepUpBugFixResult;
                    }
                    if (Collisions.getHorizontalDistanceSqr(regularStepUp) > Collisions.getHorizontalDistanceSqr(collisionResult)) {
                        collisionResult = regularStepUp.add(Collisions.collideBoundingBoxLegacy(new Vector3dm(0.0, -regularStepUp.getY() + (player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_14) ? desiredY : 0.0), 0.0), player.boundingBox.copy().offset(regularStepUp.getX(), regularStepUp.getY(), regularStepUp.getZ()), desiredMovementCollisionBoxes, order));
                    }
                }
            }
            double resultAccuracy = collisionResult.distanceSquared(bestTheoreticalCollisionResult);
            if (player.wouldCollisionResultFlagGroundSpoof(desiredY, collisionResult.getY())) {
                resultAccuracy += 1.0;
            }
            if (!(resultAccuracy < bestInput)) continue;
            bestOrderResult = collisionResult;
            bestInput = resultAccuracy;
            if (!(resultAccuracy < 1.0000000000000002E-10) && zeroCount < 2) continue;
            break;
        }
        return bestOrderResult;
    }

    private static float[] collectStepHeights(SimpleCollisionBox collisionBox, List<SimpleCollisionBox> collisions, float stepHeight, float collideY) {
        FloatArraySet floatSet = new FloatArraySet(4);
        block0: for (SimpleCollisionBox blockBox : collisions) {
            DoubleListIterator doubleListIterator = blockBox.getYPointPositions().iterator();
            while (doubleListIterator.hasNext()) {
                double possibleStepY = (Double)doubleListIterator.next();
                float yDiff = (float)(possibleStepY - collisionBox.minY);
                if (yDiff < 0.0f || yDiff == collideY) continue;
                if (yDiff > stepHeight) continue block0;
                floatSet.add(yDiff);
            }
        }
        float[] fs = floatSet.toFloatArray();
        FloatArrays.unstableSort(fs);
        return fs;
    }

    public static boolean addWorldBorder(GrimPlayer player, SimpleCollisionBox wantedBB, List<SimpleCollisionBox> listOfBlocks, boolean onlyCheckCollide) {
        if (player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_8)) {
            double toMaxZ;
            double toMinZ;
            double minimumInZDirection;
            PacketWorldBorder border = player.checkManager.getPacketCheck(PacketWorldBorder.class);
            double centerX = border.getCenterX();
            double centerZ = border.getCenterZ();
            double size = border.getCurrentDiameter() / 2.0;
            double absoluteMaxSize = border.getAbsoluteMaxSize();
            double minX = Math.floor(GrimMath.clamp(centerX - size, -absoluteMaxSize, absoluteMaxSize));
            double minZ = Math.floor(GrimMath.clamp(centerZ - size, -absoluteMaxSize, absoluteMaxSize));
            double maxX = Math.ceil(GrimMath.clamp(centerX + size, -absoluteMaxSize, absoluteMaxSize));
            double maxZ = Math.ceil(GrimMath.clamp(centerZ + size, -absoluteMaxSize, absoluteMaxSize));
            double toMinX = player.lastX - minX;
            double toMaxX = maxX - player.lastX;
            double minimumInXDirection = Math.min(toMinX, toMaxX);
            double distanceToBorder = Math.min(minimumInXDirection, minimumInZDirection = Math.min(toMinZ = player.lastZ - minZ, toMaxZ = maxZ - player.lastZ));
            if (distanceToBorder < 16.0 && player.lastX > minX && player.lastX < maxX && player.lastZ > minZ && player.lastZ < maxZ) {
                if (listOfBlocks == null) {
                    listOfBlocks = new ArrayList<SimpleCollisionBox>();
                }
                listOfBlocks.add(new SimpleCollisionBox(minX - 10.0, Double.NEGATIVE_INFINITY, maxZ, maxX + 10.0, Double.POSITIVE_INFINITY, maxZ, false));
                listOfBlocks.add(new SimpleCollisionBox(minX - 10.0, Double.NEGATIVE_INFINITY, minZ, maxX + 10.0, Double.POSITIVE_INFINITY, minZ, false));
                listOfBlocks.add(new SimpleCollisionBox(maxX, Double.NEGATIVE_INFINITY, minZ - 10.0, maxX, Double.POSITIVE_INFINITY, maxZ + 10.0, false));
                listOfBlocks.add(new SimpleCollisionBox(minX, Double.NEGATIVE_INFINITY, minZ - 10.0, minX, Double.POSITIVE_INFINITY, maxZ + 10.0, false));
                if (onlyCheckCollide) {
                    for (SimpleCollisionBox box : listOfBlocks) {
                        if (!box.isIntersected(wantedBB)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean getCollisionBoxes(GrimPlayer player, SimpleCollisionBox wantedBB, List<SimpleCollisionBox> listOfBlocks, boolean onlyCheckCollide) {
        SimpleCollisionBox expandedBB = wantedBB.copy();
        boolean collided = Collisions.addWorldBorder(player, wantedBB, listOfBlocks, onlyCheckCollide);
        if (onlyCheckCollide && collided) {
            return true;
        }
        int minBlockX = (int)Math.floor(expandedBB.minX - 1.0E-7) - 1;
        int maxBlockX = (int)Math.floor(expandedBB.maxX + 1.0E-7) + 1;
        int minBlockY = (int)Math.floor(expandedBB.minY - 1.0E-7) - 1;
        int maxBlockY = (int)Math.floor(expandedBB.maxY + 1.0E-7) + 1;
        int minBlockZ = (int)Math.floor(expandedBB.minZ - 1.0E-7) - 1;
        int maxBlockZ = (int)Math.floor(expandedBB.maxZ + 1.0E-7) + 1;
        int minSection = player.compensatedWorld.getMinHeight() >> 4;
        int minBlock = minSection << 4;
        int maxBlock = player.compensatedWorld.getMaxHeight() - 1;
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        int minYIterate = Math.max(minBlock, minBlockY);
        int maxYIterate = Math.min(maxBlock, maxBlockY);
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            int minZ = currChunkZ == minChunkZ ? minBlockZ & 0xF : 0;
            int maxZ = currChunkZ == maxChunkZ ? maxBlockZ & 0xF : 15;
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                int minX = currChunkX == minChunkX ? minBlockX & 0xF : 0;
                int maxX = currChunkX == maxChunkX ? maxBlockX & 0xF : 15;
                int chunkXGlobalPos = currChunkX << 4;
                int chunkZGlobalPos = currChunkZ << 4;
                Column chunk = player.compensatedWorld.getChunk(currChunkX, currChunkZ);
                if (chunk == null) continue;
                BaseChunk[] sections = chunk.chunks();
                for (int y = minYIterate; y <= maxYIterate; ++y) {
                    int sectionIndex = (y >> 4) - minSection;
                    BaseChunk section = sections[sectionIndex];
                    if (section == null || IS_FOURTEEN && section.isEmpty()) {
                        y = (y & 0xFFFFFFF0) + 15;
                        continue;
                    }
                    for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                        for (int currX = minX; currX <= maxX; ++currX) {
                            int x = currX | chunkXGlobalPos;
                            int z = currZ | chunkZGlobalPos;
                            WrappedBlockState data = section.get(CompensatedWorld.blockVersion, x & 0xF, y & 0xF, z & 0xF, false);
                            if (data.getGlobalId() == 0) continue;
                            int edgeCount = (x == minBlockX || x == maxBlockX ? 1 : 0) + (y == minBlockY || y == maxBlockY ? 1 : 0) + (z == minBlockZ || z == maxBlockZ ? 1 : 0);
                            StateType type = data.getType();
                            if (edgeCount == 3 || edgeCount == 1 && !Materials.isShapeExceedsCube(type) || edgeCount == 2 && type != StateTypes.PISTON_HEAD) continue;
                            CollisionBox collisionBox = CollisionData.getData(type).getMovementCollisionBox(player, player.getClientVersion(), data, x, y, z);
                            if (!onlyCheckCollide) {
                                collisionBox.downCast(listOfBlocks);
                                continue;
                            }
                            if (!collisionBox.isCollided(wantedBB)) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public static Vector3dm collideBoundingBoxLegacy(Vector3dm toCollide, SimpleCollisionBox box, List<SimpleCollisionBox> desiredMovementCollisionBoxes, List<Axis> order) {
        double x = toCollide.getX();
        double y = toCollide.getY();
        double z = toCollide.getZ();
        SimpleCollisionBox setBB = box.copy();
        for (Axis axis : order) {
            if (axis == Axis.X) {
                for (SimpleCollisionBox bb : desiredMovementCollisionBoxes) {
                    x = bb.collideX(setBB, x);
                }
                setBB.offset(x, 0.0, 0.0);
                continue;
            }
            if (axis == Axis.Y) {
                for (SimpleCollisionBox bb : desiredMovementCollisionBoxes) {
                    y = bb.collideY(setBB, y);
                }
                setBB.offset(0.0, y, 0.0);
                continue;
            }
            if (axis != Axis.Z) continue;
            for (SimpleCollisionBox bb : desiredMovementCollisionBoxes) {
                z = bb.collideZ(setBB, z);
            }
            setBB.offset(0.0, 0.0, z);
        }
        return new Vector3dm(x, y, z);
    }

    public static boolean isEmpty(GrimPlayer player, SimpleCollisionBox playerBB) {
        return !Collisions.getCollisionBoxes(player, playerBB, null, true);
    }

    public static double getHorizontalDistanceSqr(Vector3dm vector) {
        return vector.getX() * vector.getX() + vector.getZ() * vector.getZ();
    }

    public static Vector3dm maybeBackOffFromEdge(Vector3dm vec3, GrimPlayer player, boolean overrideVersion) {
        if (!player.isFlying && player.isSneaking && Collisions.isAboveGround(player)) {
            double maxStepDown;
            double x = vec3.getX();
            double z = vec3.getZ();
            double d = maxStepDown = overrideVersion || player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_11) ? (double)(-player.getMaxUpStep()) : -0.9999999;
            while (x != 0.0 && Collisions.isEmpty(player, player.boundingBox.copy().offset(x, maxStepDown, 0.0))) {
                if (x < 0.05 && x >= -0.05) {
                    x = 0.0;
                    continue;
                }
                if (x > 0.0) {
                    x -= 0.05;
                    continue;
                }
                x += 0.05;
            }
            while (z != 0.0 && Collisions.isEmpty(player, player.boundingBox.copy().offset(0.0, maxStepDown, z))) {
                if (z < 0.05 && z >= -0.05) {
                    z = 0.0;
                    continue;
                }
                if (z > 0.0) {
                    z -= 0.05;
                    continue;
                }
                z += 0.05;
            }
            while (x != 0.0 && z != 0.0 && Collisions.isEmpty(player, player.boundingBox.copy().offset(x, maxStepDown, z))) {
                x = x < 0.05 && x >= -0.05 ? 0.0 : (x > 0.0 ? (x -= 0.05) : (x += 0.05));
                if (z < 0.05 && z >= -0.05) {
                    z = 0.0;
                    continue;
                }
                if (z > 0.0) {
                    z -= 0.05;
                    continue;
                }
                z += 0.05;
            }
            vec3 = new Vector3dm(x, vec3.getY(), z);
        }
        return vec3;
    }

    public static boolean isAboveGround(GrimPlayer player) {
        return player.lastOnGround || player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_16_2) && player.fallDistance < (double)player.getMaxUpStep() && !Collisions.isEmpty(player, player.boundingBox.copy().offset(0.0, player.fallDistance - (double)player.getMaxUpStep(), 0.0));
    }

    public static void handleInsideBlocks(GrimPlayer player) {
        if (player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_21_2)) {
            return;
        }
        double expandAmount = player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_19_4) ? 1.0E-5 : 0.001;
        SimpleCollisionBox aABB = player.inVehicle() ? GetBoundingBox.getCollisionBoxForPlayer(player, player.x, player.y, player.z).expand(-expandAmount) : player.boundingBox.copy().expand(-expandAmount);
        Location blockPos = new Location(null, aABB.minX, aABB.minY, aABB.minZ);
        Location blockPos2 = new Location(null, aABB.maxX, aABB.maxY, aABB.maxZ);
        if (CheckIfChunksLoaded.areChunksUnloadedAt(player, blockPos.getBlockX(), blockPos.getBlockY(), blockPos.getBlockZ(), blockPos2.getBlockX(), blockPos2.getBlockY(), blockPos2.getBlockZ())) {
            return;
        }
        for (int blockX = blockPos.getBlockX(); blockX <= blockPos2.getBlockX(); ++blockX) {
            for (int blockY = blockPos.getBlockY(); blockY <= blockPos2.getBlockY(); ++blockY) {
                for (int blockZ = blockPos.getBlockZ(); blockZ <= blockPos2.getBlockZ(); ++blockZ) {
                    WrappedBlockState block = player.compensatedWorld.getBlock(blockX, blockY, blockZ);
                    StateType blockType = block.getType();
                    if (blockType.isAir()) continue;
                    Collisions.onInsideBlock(player, blockType, block, blockX, blockY, blockZ);
                }
            }
        }
    }

    public static void onInsideBlock(GrimPlayer player, StateType blockType, WrappedBlockState block, int blockX, int blockY, int blockZ) {
        if (blockType == StateTypes.COBWEB) {
            player.stuckSpeedMultiplier = player.compensatedEntities.hasPotionEffect(PotionTypes.WEAVING) ? new Vector3dm(0.5, 0.25, 0.5) : new Vector3dm(0.25, (double)0.05f, 0.25);
        }
        if (blockType == StateTypes.SWEET_BERRY_BUSH && player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_14)) {
            player.stuckSpeedMultiplier = new Vector3dm((double)0.8f, 0.75, (double)0.8f);
        }
        if (blockType == StateTypes.POWDER_SNOW && (double)blockX == Math.floor(player.x) && (double)blockY == Math.floor(player.y) && (double)blockZ == Math.floor(player.z) && player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_17)) {
            player.stuckSpeedMultiplier = new Vector3dm((double)0.9f, 1.5, (double)0.9f);
        }
        if (blockType == StateTypes.SOUL_SAND && player.getClientVersion().isOlderThan(ClientVersion.V_1_15)) {
            player.clientVelocity.setX(player.clientVelocity.getX() * 0.4);
            player.clientVelocity.setZ(player.clientVelocity.getZ() * 0.4);
        }
        if (blockType == StateTypes.LAVA && player.getClientVersion().isOlderThan(ClientVersion.V_1_16) && player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_14)) {
            player.wasTouchingLava = true;
        }
        if (blockType == StateTypes.BUBBLE_COLUMN && player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_13)) {
            WrappedBlockState blockAbove = player.compensatedWorld.getBlock(blockX, blockY + 1, blockZ);
            if (player.inVehicle() && player.compensatedEntities.self.getRiding().isBoat) {
                if (!blockAbove.getType().isAir()) {
                    if (block.isDrag()) {
                        player.clientVelocity.setY(Math.max(-0.3, player.clientVelocity.getY() - 0.03));
                    } else {
                        player.clientVelocity.setY(Math.min(0.7, player.clientVelocity.getY() + 0.06));
                    }
                }
            } else if (blockAbove.getType().isAir()) {
                for (VectorData vector : player.getPossibleVelocitiesMinusKnockback()) {
                    if (block.isDrag()) {
                        vector.vector.setY(Math.max(-0.9, vector.vector.getY() - 0.03));
                        continue;
                    }
                    vector.vector.setY(Math.min(1.8, vector.vector.getY() + 0.1));
                }
            } else {
                for (VectorData vector : player.getPossibleVelocitiesMinusKnockback()) {
                    if (block.isDrag()) {
                        vector.vector.setY(Math.max(-0.3, vector.vector.getY() - 0.03));
                        continue;
                    }
                    vector.vector.setY(Math.min(0.7, vector.vector.getY() + 0.06));
                }
            }
            player.fallDistance = 0.0;
        }
        if (blockType == StateTypes.HONEY_BLOCK && player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_15)) {
            if (Collisions.isSlidingDown(player.clientVelocity, player, blockX, blockY, blockZ)) {
                if (Collisions.getOldDeltaY(player, player.clientVelocity.getY()) < -0.13) {
                    double d0 = -0.05 / Collisions.getOldDeltaY(player, player.clientVelocity.getY());
                    player.clientVelocity.setX(player.clientVelocity.getX() * d0);
                    player.clientVelocity.setY(Collisions.getNewDeltaY(player, -0.05));
                    player.clientVelocity.setZ(player.clientVelocity.getZ() * d0);
                } else {
                    player.clientVelocity.setY(Collisions.getNewDeltaY(player, -0.05));
                }
            }
            player.fallDistance = 0.0;
        }
    }

    public static void applyEffectsFromBlocks(GrimPlayer player) {
        for (GrimPlayer.Movement movement : player.finalMovementsThisTick) {
            Vector3d from = movement.from();
            Vector3d to = movement.to().subtract(movement.from());
            if (movement.axisIndependant() && to.lengthSquared() > 0.0) {
                for (Axis axis : Collisions.axisStepOrder(to)) {
                    double value = axis.choose(to.getX(), to.getY(), to.getZ());
                    if (value == 0.0) continue;
                    Vector3d vector = Collisions.relative(from, axis.getPositive(), value);
                    Collisions.checkInsideBlocks(player, from, vector);
                    from = vector;
                }
                continue;
            }
            Collisions.checkInsideBlocks(player, movement.from(), movement.to());
        }
        player.visitedBlocks.clear();
    }

    public static void checkInsideBlocks(GrimPlayer player, Vector3d from, Vector3d to) {
        SimpleCollisionBox boundingBox = (player.getClientVersion() == ClientVersion.V_1_21_2 ? player.boundingBox.copy() : GetBoundingBox.getCollisionBoxForPlayer(player, to.x, to.y, to.z)).expand(-1.0E-5f);
        for (Vector3i blockPos : Collisions.boxTraverseBlocks(player, from, to, boundingBox)) {
            WrappedBlockState blockState = player.compensatedWorld.getBlock(blockPos);
            StateType blockType = blockState.getType();
            if (blockType.isAir() || !player.visitedBlocks.add(GrimMath.asLong(blockPos.getX(), blockPos.getY(), blockPos.getZ()))) continue;
            Collisions.onInsideBlock(player, blockType, blockState, blockPos.x, blockPos.y, blockPos.z);
        }
    }

    public static Iterable<Vector3i> boxTraverseBlocks(GrimPlayer player, Vector3d start, Vector3d end, SimpleCollisionBox boundingBox) {
        Vector3d direction = end.subtract(start);
        Iterable<Vector3i> initialBlocks = SimpleCollisionBox.betweenClosed(boundingBox);
        if (direction.lengthSquared() < (double)GrimMath.square(0.99999f)) {
            return initialBlocks;
        }
        LongOpenHashSet alreadyVisited = player.getClientVersion().isOlderThan(ClientVersion.V_1_21_5) ? null : new LongOpenHashSet();
        ObjectLinkedOpenHashSet<Vector3i> traversedBlocks = new ObjectLinkedOpenHashSet<Vector3i>();
        Vector3d boxMinPosition = boundingBox.min().toVector3d();
        Vector3d subtractedMinPosition = boxMinPosition.subtract(direction);
        Collisions.addCollisionsAlongTravel(alreadyVisited, traversedBlocks, subtractedMinPosition, boxMinPosition, boundingBox);
        for (Vector3i blockPos : initialBlocks) {
            if (alreadyVisited != null && alreadyVisited.contains(GrimMath.asLong(blockPos.getX(), blockPos.getY(), blockPos.getZ()))) continue;
            traversedBlocks.add(blockPos);
        }
        return traversedBlocks;
    }

    public static void addCollisionsAlongTravel(LongSet alreadyVisited, Set<Vector3i> output, Vector3d start, Vector3d end, SimpleCollisionBox boundingBox) {
        Vector3d direction = end.subtract(start);
        int currentX = GrimMath.floor(start.x);
        int currentY = GrimMath.floor(start.y);
        int currentZ = GrimMath.floor(start.z);
        int stepX = GrimMath.sign(direction.x);
        int stepY = GrimMath.sign(direction.y);
        int stepZ = GrimMath.sign(direction.z);
        double tMaxX = stepX == 0 ? Double.MAX_VALUE : (double)stepX / direction.x;
        double tMaxY = stepY == 0 ? Double.MAX_VALUE : (double)stepY / direction.y;
        double tMaxZ = stepZ == 0 ? Double.MAX_VALUE : (double)stepZ / direction.z;
        double tDeltaX = tMaxX * (stepX > 0 ? 1.0 - GrimMath.frac(start.x) : GrimMath.frac(start.x));
        double tDeltaY = tMaxY * (stepY > 0 ? 1.0 - GrimMath.frac(start.y) : GrimMath.frac(start.y));
        double tDeltaZ = tMaxZ * (stepZ > 0 ? 1.0 - GrimMath.frac(start.z) : GrimMath.frac(start.z));
        int iterationCount = 0;
        while (tDeltaX <= 1.0 || tDeltaY <= 1.0 || tDeltaZ <= 1.0) {
            if (tDeltaX < tDeltaY) {
                if (tDeltaX < tDeltaZ) {
                    currentX += stepX;
                    tDeltaX += tMaxX;
                } else {
                    currentZ += stepZ;
                    tDeltaZ += tMaxZ;
                }
            } else if (tDeltaY < tDeltaZ) {
                currentY += stepY;
                tDeltaY += tMaxY;
            } else {
                currentZ += stepZ;
                tDeltaZ += tMaxZ;
            }
            if (iterationCount++ > 16) break;
            Optional<Vector3d> collisionPoint = Collisions.clip(currentX, currentY, currentZ, currentX + 1, currentY + 1, currentZ + 1, start, end);
            if (!collisionPoint.isPresent()) continue;
            Vector3d collisionVec = collisionPoint.get();
            double clampedX = GrimMath.clamp(collisionVec.x, (double)((float)currentX + 1.0E-5f), (double)currentX + 1.0 - (double)1.0E-5f);
            double clampedY = GrimMath.clamp(collisionVec.y, (double)((float)currentY + 1.0E-5f), (double)currentY + 1.0 - (double)1.0E-5f);
            double clampedZ = GrimMath.clamp(collisionVec.z, (double)((float)currentZ + 1.0E-5f), (double)currentZ + 1.0 - (double)1.0E-5f);
            int endX = GrimMath.floor(clampedX + boundingBox.getXSize());
            int endY = GrimMath.floor(clampedY + boundingBox.getYSize());
            int endZ = GrimMath.floor(clampedZ + boundingBox.getZSize());
            for (int x = currentX; x <= endX; ++x) {
                for (int y = currentY; y <= endY; ++y) {
                    for (int z = currentZ; z <= endZ; ++z) {
                        if (alreadyVisited != null && !alreadyVisited.add(GrimMath.asLong(x, y, z))) continue;
                        output.add(new Vector3i(x, y, z));
                    }
                }
            }
        }
    }

    public static Optional<Vector3d> clip(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Vector3d start, Vector3d end) {
        double[] minDistance = new double[]{1.0};
        double deltaX = end.x - start.x;
        double deltaY = end.y - start.y;
        double deltaZ = end.z - start.z;
        Direction direction = Collisions.getDirection(minX, minY, minZ, maxX, maxY, maxZ, start, minDistance, null, deltaX, deltaY, deltaZ);
        if (direction == null) {
            return Optional.empty();
        }
        double distance = minDistance[0];
        return Optional.of(start.add(distance * deltaX, distance * deltaY, distance * deltaZ));
    }

    private static Direction getDirection(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Vector3d start, double[] minDistance, Direction facing, double deltaX, double deltaY, double deltaZ) {
        if (deltaX > 1.0E-7) {
            facing = Collisions.clipPoint(minDistance, facing, deltaX, deltaY, deltaZ, minX, minY, maxY, minZ, maxZ, Direction.WEST, start.x, start.y, start.z);
        } else if (deltaX < -1.0E-7) {
            facing = Collisions.clipPoint(minDistance, facing, deltaX, deltaY, deltaZ, maxX, minY, maxY, minZ, maxZ, Direction.EAST, start.x, start.y, start.z);
        }
        if (deltaY > 1.0E-7) {
            facing = Collisions.clipPoint(minDistance, facing, deltaY, deltaZ, deltaX, minY, minZ, maxZ, minX, maxX, Direction.DOWN, start.y, start.z, start.x);
        } else if (deltaY < -1.0E-7) {
            facing = Collisions.clipPoint(minDistance, facing, deltaY, deltaZ, deltaX, maxY, minZ, maxZ, minX, maxX, Direction.UP, start.y, start.z, start.x);
        }
        if (deltaZ > 1.0E-7) {
            facing = Collisions.clipPoint(minDistance, facing, deltaZ, deltaX, deltaY, minZ, minX, maxX, minY, maxY, Direction.NORTH, start.z, start.x, start.y);
        } else if (deltaZ < -1.0E-7) {
            facing = Collisions.clipPoint(minDistance, facing, deltaZ, deltaX, deltaY, maxZ, minX, maxX, minY, maxY, Direction.SOUTH, start.z, start.x, start.y);
        }
        return facing;
    }

    public static Direction clipPoint(double[] minDistance, Direction prevDirection, double distanceSide, double distanceOtherA, double distanceOtherB, double minSide, double minOtherA, double maxOtherA, double minOtherB, double maxOtherB, Direction hitSide, double startSide, double startOtherA, double startOtherB) {
        double sideDistance = (minSide - startSide) / distanceSide;
        double otherDistanceA = startOtherA + sideDistance * distanceOtherA;
        double otherDistanceB = startOtherB + sideDistance * distanceOtherB;
        if (sideDistance > 0.0 && sideDistance < minDistance[0] && minOtherA - 1.0E-7 < otherDistanceA && otherDistanceA < maxOtherA + 1.0E-7 && minOtherB - 1.0E-7 < otherDistanceB && otherDistanceB < maxOtherB + 1.0E-7) {
            minDistance[0] = sideDistance;
            return hitSide;
        }
        return prevDirection;
    }

    public static Iterable<Axis> axisStepOrder(Vector3d vector) {
        return Math.abs(vector.getX()) < Math.abs(vector.getZ()) ? YZX_AXIS_ORDER : YXZ_AXIS_ORDER;
    }

    public static Vector3d relative(Vector3d curr, Direction direction, double value) {
        Vector3i vec = direction.getVector();
        return new Vector3d(curr.x + value * (double)vec.getX(), curr.y + value * (double)vec.getY(), curr.z + value * (double)vec.getZ());
    }

    private static double getOldDeltaY(GrimPlayer player, double value) {
        return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_21_2) ? value / (double)0.98f + 0.08 : value;
    }

    private static double getNewDeltaY(GrimPlayer player, double value) {
        return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_21_2) ? (value - 0.08) * (double)0.98f : value;
    }

    private static boolean isSlidingDown(Vector3dm vector, GrimPlayer player, int locationX, int locationY, int locationZ) {
        if (player.onGround) {
            return false;
        }
        if (player.y > (double)locationY + 0.9375 - 1.0E-7) {
            return false;
        }
        if (Collisions.getOldDeltaY(player, vector.getY()) >= -0.08) {
            return false;
        }
        double d0 = Math.abs((double)locationX + 0.5 - player.lastX);
        double d1 = Math.abs((double)locationZ + 0.5 - player.lastZ);
        double d2 = 0.4375 + (double)(player.pose.width / 2.0f);
        return d0 + 1.0E-7 > d2 || d1 + 1.0E-7 > d2;
    }

    public static boolean checkStuckSpeed(GrimPlayer player, double expand) {
        SimpleCollisionBox aABB = GetBoundingBox.getCollisionBoxForPlayer(player, player.x, player.y, player.z).expand(expand);
        Location blockPos = new Location(null, aABB.minX, aABB.minY, aABB.minZ);
        Location blockPos2 = new Location(null, aABB.maxX, aABB.maxY, aABB.maxZ);
        if (CheckIfChunksLoaded.areChunksUnloadedAt(player, blockPos.getBlockX(), blockPos.getBlockY(), blockPos.getBlockZ(), blockPos2.getBlockX(), blockPos2.getBlockY(), blockPos2.getBlockZ())) {
            return false;
        }
        for (int i = blockPos.getBlockX(); i <= blockPos2.getBlockX(); ++i) {
            for (int j = blockPos.getBlockY(); j <= blockPos2.getBlockY(); ++j) {
                for (int k = blockPos.getBlockZ(); k <= blockPos2.getBlockZ(); ++k) {
                    WrappedBlockState block = player.compensatedWorld.getBlock(i, j, k);
                    StateType blockType = block.getType();
                    if (blockType == StateTypes.COBWEB) {
                        return true;
                    }
                    if (blockType == StateTypes.SWEET_BERRY_BUSH && player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_14)) {
                        return true;
                    }
                    if (blockType != StateTypes.POWDER_SNOW || (double)i != Math.floor(player.x) || (double)j != Math.floor(player.y) || (double)k != Math.floor(player.z) || !player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_17)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean suffocatesAt(GrimPlayer player, SimpleCollisionBox playerBB) {
        int y = (int)Math.floor(playerBB.minY);
        while ((double)y < Math.ceil(playerBB.maxY)) {
            int z = (int)Math.floor(playerBB.minZ);
            while ((double)z < Math.ceil(playerBB.maxZ)) {
                int x = (int)Math.floor(playerBB.minX);
                while ((double)x < Math.ceil(playerBB.maxX)) {
                    WrappedBlockState data;
                    CollisionBox box;
                    if (Collisions.doesBlockSuffocate(player, x, y, z) && (!player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_16) || (box = CollisionData.getData((data = player.compensatedWorld.getBlock(x, y, z)).getType()).getMovementCollisionBox(player, player.getClientVersion(), data, x, y, z)).isIntersected(playerBB))) {
                        return true;
                    }
                    ++x;
                }
                ++z;
            }
            ++y;
        }
        return false;
    }

    public static boolean doesBlockSuffocate(GrimPlayer player, int x, int y, int z) {
        WrappedBlockState data = player.compensatedWorld.getBlock(x, y, z);
        StateType mat = data.getType();
        if (!mat.isSolid()) {
            return false;
        }
        if (mat == StateTypes.OBSERVER || mat == StateTypes.REDSTONE_BLOCK) {
            return player.getClientVersion().isNewerThan(ClientVersion.V_1_13_2);
        }
        if (mat == StateTypes.TNT) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_14);
        }
        if (mat == StateTypes.FARMLAND) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_16);
        }
        if (mat == StateTypes.SOUL_SAND) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_16) || player.getClientVersion().isOlderThan(ClientVersion.V_1_14);
        }
        if ((mat == StateTypes.PISTON || mat == StateTypes.STICKY_PISTON) && player.getClientVersion().isOlderThan(ClientVersion.V_1_14)) {
            return false;
        }
        if (mat == StateTypes.ICE || mat == StateTypes.FROSTED_ICE) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_14);
        }
        if (BlockTags.LEAVES.contains(mat) || BlockTags.GLASS_BLOCKS.contains(mat)) {
            return false;
        }
        if (mat == StateTypes.DIRT_PATH) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_16) || player.getClientVersion().isOlderThan(ClientVersion.V_1_9);
        }
        if (mat == StateTypes.BEACON) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_14);
        }
        if (Materials.isSolidBlockingBlacklist(mat, player.getClientVersion())) {
            return false;
        }
        CollisionBox box = CollisionData.getData(mat).getMovementCollisionBox(player, player.getClientVersion(), data, x, y, z);
        return box.isFullBlock();
    }

    public static boolean hasMaterial(GrimPlayer player, SimpleCollisionBox checkBox, Predicate<Pair<WrappedBlockState, Vector3d>> searchingFor) {
        int minBlockX = (int)Math.floor(checkBox.minX);
        int maxBlockX = (int)Math.floor(checkBox.maxX);
        int minBlockY = (int)Math.floor(checkBox.minY);
        int maxBlockY = (int)Math.floor(checkBox.maxY);
        int minBlockZ = (int)Math.floor(checkBox.minZ);
        int maxBlockZ = (int)Math.floor(checkBox.maxZ);
        int minSection = player.compensatedWorld.getMinHeight() >> 4;
        int minBlock = minSection << 4;
        int maxBlock = player.compensatedWorld.getMaxHeight() - 1;
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        int minYIterate = Math.max(minBlock, minBlockY);
        int maxYIterate = Math.min(maxBlock, maxBlockY);
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            int minZ = currChunkZ == minChunkZ ? minBlockZ & 0xF : 0;
            int maxZ = currChunkZ == maxChunkZ ? maxBlockZ & 0xF : 15;
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                int minX = currChunkX == minChunkX ? minBlockX & 0xF : 0;
                int maxX = currChunkX == maxChunkX ? maxBlockX & 0xF : 15;
                int chunkXGlobalPos = currChunkX << 4;
                int chunkZGlobalPos = currChunkZ << 4;
                Column chunk = player.compensatedWorld.getChunk(currChunkX, currChunkZ);
                if (chunk == null) continue;
                BaseChunk[] sections = chunk.chunks();
                for (int y = minYIterate; y <= maxYIterate; ++y) {
                    BaseChunk section = sections[(y >> 4) - minSection];
                    if (section == null || IS_FOURTEEN && section.isEmpty()) {
                        y = (y & 0xFFFFFFF0) + 15;
                        continue;
                    }
                    for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                        for (int currX = minX; currX <= maxX; ++currX) {
                            int x = currX | chunkXGlobalPos;
                            int z = currZ | chunkZGlobalPos;
                            WrappedBlockState data = section.get(CompensatedWorld.blockVersion, x & 0xF, y & 0xF, z & 0xF, false);
                            if (!searchingFor.test(new Pair<WrappedBlockState, Vector3d>(data, new Vector3d(x, y, z)))) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public static void forEachCollisionBox(@NotNull GrimPlayer player, @NotNull SimpleCollisionBox checkBox, @NotNull @NotNull Consumer<@NotNull Vector3d> searchingFor) {
        int minBlockX = (int)Math.floor(checkBox.minX - 1.0E-7) - 1;
        int maxBlockX = (int)Math.floor(checkBox.maxX + 1.0E-7) + 1;
        int minBlockY = (int)Math.floor(checkBox.minY - 1.0E-7) - 1;
        int maxBlockY = (int)Math.floor(checkBox.maxY + 1.0E-7) + 1;
        int minBlockZ = (int)Math.floor(checkBox.minZ - 1.0E-7) - 1;
        int maxBlockZ = (int)Math.floor(checkBox.maxZ + 1.0E-7) + 1;
        int minSection = player.compensatedWorld.getMinHeight() >> 4;
        int minBlock = minSection << 4;
        int maxBlock = player.compensatedWorld.getMaxHeight() - 1;
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        int minYIterate = Math.max(minBlock, minBlockY);
        int maxYIterate = Math.min(maxBlock, maxBlockY);
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            int minZ = currChunkZ == minChunkZ ? minBlockZ & 0xF : 0;
            int maxZ = currChunkZ == maxChunkZ ? maxBlockZ & 0xF : 15;
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                int minX = currChunkX == minChunkX ? minBlockX & 0xF : 0;
                int maxX = currChunkX == maxChunkX ? maxBlockX & 0xF : 15;
                int chunkXGlobalPos = currChunkX << 4;
                int chunkZGlobalPos = currChunkZ << 4;
                Column chunk = player.compensatedWorld.getChunk(currChunkX, currChunkZ);
                if (chunk == null) continue;
                BaseChunk[] sections = chunk.chunks();
                for (int y = minYIterate; y <= maxYIterate; ++y) {
                    BaseChunk section = sections[(y >> 4) - minSection];
                    if (section == null || IS_FOURTEEN && section.isEmpty()) {
                        y = (y & 0xFFFFFFF0) + 15;
                        continue;
                    }
                    for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                        for (int currX = minX; currX <= maxX; ++currX) {
                            CollisionBox collisionBox;
                            int x = currX | chunkXGlobalPos;
                            int z = currZ | chunkZGlobalPos;
                            WrappedBlockState data = section.get(CompensatedWorld.blockVersion, x & 0xF, y & 0xF, z & 0xF, false);
                            if (data.getGlobalId() == 0) continue;
                            int edgeCount = (x == minBlockX || x == maxBlockX ? 1 : 0) + (y == minBlockY || y == maxBlockY ? 1 : 0) + (z == minBlockZ || z == maxBlockZ ? 1 : 0);
                            StateType type = data.getType();
                            if (edgeCount == 3 || edgeCount == 1 && !Materials.isShapeExceedsCube(type) || edgeCount == 2 && type != StateTypes.PISTON_HEAD || !(collisionBox = CollisionData.getData(type).getMovementCollisionBox(player, player.getClientVersion(), data, x, y, z)).isIntersected(checkBox)) continue;
                            searchingFor.accept(new Vector3d(x, y, z));
                        }
                    }
                }
            }
        }
    }

    public static boolean onClimbable(GrimPlayer player, double x, double y, double z) {
        WrappedBlockState blockState = player.compensatedWorld.getBlock(x, y, z);
        StateType blockMaterial = blockState.getType();
        if (blockMaterial == StateTypes.CAVE_VINES || blockMaterial == StateTypes.CAVE_VINES_PLANT) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_17);
        }
        if (player.tagManager.block(SyncedTags.CLIMBABLE).contains(blockMaterial)) {
            return true;
        }
        if (blockMaterial == StateTypes.SWEET_BERRY_BUSH && player.getClientVersion().isOlderThan(ClientVersion.V_1_14)) {
            return true;
        }
        return Collisions.trapdoorUsableAsLadder(player, x, y, z, blockState);
    }

    public static boolean trapdoorUsableAsLadder(GrimPlayer player, double x, double y, double z, WrappedBlockState blockData) {
        WrappedBlockState blockBelow;
        if (!BlockTags.TRAPDOORS.contains(blockData.getType())) {
            return false;
        }
        if (player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_8)) {
            return false;
        }
        if (blockData.isOpen() && (blockBelow = player.compensatedWorld.getBlock(x, y - 1.0, z)).getType() == StateTypes.LADDER) {
            return blockData.getFacing() == blockBelow.getFacing();
        }
        return false;
    }

    @Generated
    private Collisions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Axis {
        X{

            @Override
            public double choose(double x, double y, double z) {
                return x;
            }

            @Override
            public Direction getPositive() {
                return Direction.EAST;
            }
        }
        ,
        Y{

            @Override
            public double choose(double x, double y, double z) {
                return y;
            }

            @Override
            public Direction getPositive() {
                return Direction.UP;
            }
        }
        ,
        Z{

            @Override
            public double choose(double x, double y, double z) {
                return z;
            }

            @Override
            public Direction getPositive() {
                return Direction.SOUTH;
            }
        };


        public abstract double choose(double var1, double var3, double var5);

        public abstract Direction getPositive();
    }
}

