/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.platform.fabric;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.api.GrimAPIProvider;
import ac.grim.grimac.api.GrimAbstractAPI;
import ac.grim.grimac.api.plugin.GrimPlugin;
import ac.grim.grimac.events.GrimExtensionManager;
import ac.grim.grimac.platform.api.PlatformLoader;
import ac.grim.grimac.platform.api.manager.CommandAdapter;
import ac.grim.grimac.platform.api.manager.ItemResetHandler;
import ac.grim.grimac.platform.api.manager.MessagePlaceHolderManager;
import ac.grim.grimac.platform.api.manager.PermissionRegistrationManager;
import ac.grim.grimac.platform.api.manager.PlatformPluginManager;
import ac.grim.grimac.platform.api.sender.Sender;
import ac.grim.grimac.platform.api.sender.SenderFactory;
import ac.grim.grimac.platform.fabric.AbstractFabricPlatformServer;
import ac.grim.grimac.platform.fabric.manager.FabricItemResetHandler;
import ac.grim.grimac.platform.fabric.manager.FabricMessagePlaceHolderManager;
import ac.grim.grimac.platform.fabric.manager.FabricPermissionRegistrationManager;
import ac.grim.grimac.platform.fabric.manager.FabricPlatformPluginManager;
import ac.grim.grimac.platform.fabric.player.FabricPlatformPlayerFactory;
import ac.grim.grimac.platform.fabric.resolver.FabricResolverRegistrar;
import ac.grim.grimac.platform.fabric.scheduler.FabricPlatformScheduler;
import ac.grim.grimac.platform.fabric.sender.FabricSenderFactory;
import ac.grim.grimac.platform.fabric.utils.convert.IFabricConversionUtil;
import ac.grim.grimac.platform.fabric.utils.message.IFabricMessageUtil;
import ac.grim.grimac.utils.lazy.LazyHolder;
import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.PacketEventsAPI;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import lombok.Generated;
import net.minecraft.class_2168;
import net.minecraft.server.MinecraftServer;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.SenderMapper;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.fabric.FabricServerCommandManager;

public abstract class GrimACFabricLoaderPlugin
implements PlatformLoader {
    public static MinecraftServer FABRIC_SERVER;
    public static GrimACFabricLoaderPlugin LOADER;
    protected final LazyHolder<FabricPlatformScheduler> scheduler = LazyHolder.simple(FabricPlatformScheduler::new);
    protected final PacketEventsAPI<?> packetEvents = PacketEvents.getAPI();
    protected final LazyHolder<FabricSenderFactory> senderFactory = LazyHolder.simple(FabricSenderFactory::new);
    protected final LazyHolder<CommandManager<Sender>> commandManager = LazyHolder.simple(this::createCommandManager);
    protected final LazyHolder<ItemResetHandler> itemResetHandler = LazyHolder.simple(FabricItemResetHandler::new);
    protected final GrimPlugin plugin;
    protected final PlatformPluginManager pluginManager = new FabricPlatformPluginManager();
    protected final MessagePlaceHolderManager messagePlaceHolderManager = new FabricMessagePlaceHolderManager();
    protected final LazyHolder<FabricPermissionRegistrationManager> fabricPermissionRegistrationManager = LazyHolder.simple(FabricPermissionRegistrationManager::new);
    protected final CommandAdapter parserFactory;
    protected final FabricPlatformPlayerFactory playerFactory;
    protected final AbstractFabricPlatformServer platformServer;
    protected final IFabricConversionUtil fabricConversionUtil;
    protected final IFabricMessageUtil fabricMessageUtil;

    public GrimACFabricLoaderPlugin(CommandAdapter parserDescriptorFactory, FabricPlatformPlayerFactory playerFactory, AbstractFabricPlatformServer platformServer, IFabricMessageUtil fabricMessageUtil, IFabricConversionUtil fabricConversionUtil) {
        this.parserFactory = parserDescriptorFactory;
        this.playerFactory = playerFactory;
        this.platformServer = platformServer;
        this.fabricMessageUtil = fabricMessageUtil;
        this.fabricConversionUtil = fabricConversionUtil;
        GrimExtensionManager extensionManager = GrimAPI.INSTANCE.getExtensionManager();
        new FabricResolverRegistrar(extensionManager).registerAll();
        this.plugin = extensionManager.getPlugin((Object)"GrimAC");
    }

    public FabricPlatformScheduler getScheduler() {
        return (FabricPlatformScheduler)this.scheduler.get();
    }

    public PacketEventsAPI<?> getPacketEvents() {
        return this.packetEvents;
    }

    public CommandManager<Sender> getCommandManager() {
        return (CommandManager)this.commandManager.get();
    }

    public ItemResetHandler getItemResetHandler() {
        return (ItemResetHandler)this.itemResetHandler.get();
    }

    public SenderFactory<class_2168> getSenderFactory() {
        return (SenderFactory)this.senderFactory.get();
    }

    public GrimPlugin getPlugin() {
        return this.plugin;
    }

    public void registerAPIService() {
        GrimAPIProvider.init((GrimAbstractAPI)GrimAPI.INSTANCE.getExternalAPI());
    }

    public PermissionRegistrationManager getPermissionManager() {
        return (PermissionRegistrationManager)this.fabricPermissionRegistrationManager.get();
    }

    private CommandManager<Sender> createCommandManager() {
        return new FabricServerCommandManager(ExecutionCoordinator.simpleCoordinator(), (SenderMapper)this.senderFactory.get());
    }

    public FabricSenderFactory getFabricSenderFactory() {
        return (FabricSenderFactory)((Object)this.senderFactory.get());
    }

    public CommandAdapter getCommandAdapter() {
        return this.parserFactory;
    }

    public FabricPlatformPlayerFactory getPlatformPlayerFactory() {
        return this.playerFactory;
    }

    public AbstractFabricPlatformServer getPlatformServer() {
        return this.platformServer;
    }

    public IFabricMessageUtil getFabricMessageUtils() {
        return this.fabricMessageUtil;
    }

    public abstract ServerVersion getNativeVersion();

    @Generated
    public PlatformPluginManager getPluginManager() {
        return this.pluginManager;
    }

    @Generated
    public MessagePlaceHolderManager getMessagePlaceHolderManager() {
        return this.messagePlaceHolderManager;
    }

    @Generated
    public IFabricConversionUtil getFabricConversionUtil() {
        return this.fabricConversionUtil;
    }
}

