/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.nmsutil;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.type.EntityType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3d;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.data.packetentity.PacketEntity;
import ac.grim.grimac.utils.data.packetentity.PacketEntityGuardian;
import ac.grim.grimac.utils.data.packetentity.PacketEntityHorse;
import ac.grim.grimac.utils.data.packetentity.PacketEntitySizeable;
import ac.grim.grimac.utils.data.packetentity.PacketEntityTrackXRot;
import ac.grim.grimac.utils.math.GrimMath;
import lombok.Generated;

public final class BoundingBoxSize {
    public static float getWidth(GrimPlayer player, PacketEntity packetEntity) {
        float width = BoundingBoxSize.getWidthMinusBaby(player, packetEntity);
        return width * (packetEntity.isBaby ? BoundingBoxSize.getBabyScaleFactor(packetEntity) : 1.0f);
    }

    private static float getWidthMinusBaby(GrimPlayer player, PacketEntity packetEntity) {
        EntityType type = packetEntity.type;
        if (EntityTypes.AXOLOTL.equals(type)) {
            return 0.75f;
        }
        if (EntityTypes.PANDA.equals(type)) {
            return 1.3f;
        }
        if (EntityTypes.BAT.equals(type) || EntityTypes.PARROT.equals(type) || EntityTypes.COD.equals(type) || EntityTypes.EVOKER_FANGS.equals(type) || EntityTypes.TROPICAL_FISH.equals(type) || EntityTypes.FROG.equals(type) || EntityTypes.COPPER_GOLEM.equals(type)) {
            return 0.5f;
        }
        if (EntityTypes.ARMADILLO.equals(type) || EntityTypes.BEE.equals(type) || EntityTypes.PUFFERFISH.equals(type) || EntityTypes.SALMON.equals(type) || EntityTypes.SNOW_GOLEM.equals(type) || EntityTypes.CAVE_SPIDER.equals(type)) {
            return 0.7f;
        }
        if (EntityTypes.WITHER_SKELETON.equals(type)) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 0.7f : 0.72f;
        }
        if (EntityTypes.WITHER_SKULL.equals(type) || EntityTypes.SHULKER_BULLET.equals(type)) {
            return 0.3125f;
        }
        if (EntityTypes.HOGLIN.equals(type) || EntityTypes.ZOGLIN.equals(type)) {
            return 1.3964844f;
        }
        if (EntityTypes.SKELETON_HORSE.equals(type) || EntityTypes.ZOMBIE_HORSE.equals(type) || EntityTypes.HORSE.equals(type) || EntityTypes.DONKEY.equals(type) || EntityTypes.MULE.equals(type)) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 1.3964844f : 1.4f;
        }
        if (EntityTypes.isTypeInstanceOf(type, EntityTypes.BOAT)) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 1.375f : 1.5f;
        }
        if (EntityTypes.HAPPY_GHAST.equals(type)) {
            return 4.0f;
        }
        if (EntityTypes.CHICKEN.equals(type) || EntityTypes.ENDERMITE.equals(type) || EntityTypes.SILVERFISH.equals(type) || EntityTypes.VEX.equals(type) || EntityTypes.TADPOLE.equals(type)) {
            return 0.4f;
        }
        if (EntityTypes.RABBIT.equals(type)) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 0.4f : 0.6f;
        }
        if (EntityTypes.CREAKING.equals(type) || EntityTypes.STRIDER.equals(type) || EntityTypes.COW.equals(type) || EntityTypes.SHEEP.equals(type) || EntityTypes.MOOSHROOM.equals(type) || EntityTypes.PIG.equals(type) || EntityTypes.LLAMA.equals(type) || EntityTypes.DOLPHIN.equals(type) || EntityTypes.WITHER.equals(type) || EntityTypes.TRADER_LLAMA.equals(type) || EntityTypes.WARDEN.equals(type) || EntityTypes.GOAT.equals(type)) {
            return 0.9f;
        }
        if (EntityTypes.PHANTOM.equals(type)) {
            if (packetEntity instanceof PacketEntitySizeable) {
                PacketEntitySizeable sizeable = (PacketEntitySizeable)packetEntity;
                return 0.9f + (float)sizeable.size * 0.2f;
            }
            return 1.5f;
        }
        if (packetEntity instanceof PacketEntityGuardian) {
            PacketEntityGuardian packetEntityGuardian = (PacketEntityGuardian)packetEntity;
            return packetEntityGuardian.isElder ? 1.9975f : 0.85f;
        }
        if (EntityTypes.END_CRYSTAL.equals(type)) {
            return 2.0f;
        }
        if (EntityTypes.ENDER_DRAGON.equals(type)) {
            return 16.0f;
        }
        if (EntityTypes.FIREBALL.equals(type)) {
            return 1.0f;
        }
        if (EntityTypes.GHAST.equals(type)) {
            return 4.0f;
        }
        if (EntityTypes.GIANT.equals(type)) {
            return 3.6f;
        }
        if (EntityTypes.GUARDIAN.equals(type)) {
            return 0.85f;
        }
        if (EntityTypes.IRON_GOLEM.equals(type)) {
            return 1.4f;
        }
        if (EntityTypes.MAGMA_CUBE.equals(type)) {
            if (packetEntity instanceof PacketEntitySizeable) {
                PacketEntitySizeable sizeable = (PacketEntitySizeable)packetEntity;
                float size = sizeable.size;
                return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_20_5) ? 0.52f * size : (player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 2.04f * (0.255f * size) : 0.51000005f * size);
            }
            return 0.98f;
        }
        if (EntityTypes.isTypeInstanceOf(type, EntityTypes.MINECART_ABSTRACT)) {
            return 0.98f;
        }
        if (EntityTypes.PLAYER.equals(type) || EntityTypes.MANNEQUIN.equals(type)) {
            return 0.6f;
        }
        if (EntityTypes.POLAR_BEAR.equals(type)) {
            return 1.4f;
        }
        if (EntityTypes.RAVAGER.equals(type)) {
            return 1.95f;
        }
        if (EntityTypes.SHULKER.equals(type)) {
            return 1.0f;
        }
        if (EntityTypes.SLIME.equals(type)) {
            if (packetEntity instanceof PacketEntitySizeable) {
                PacketEntitySizeable sizeable = (PacketEntitySizeable)packetEntity;
                float size = sizeable.size;
                return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_20_5) ? 0.52f * size : (player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 2.04f * (0.255f * size) : 0.51000005f * size);
            }
            return 0.3125f;
        }
        if (EntityTypes.SMALL_FIREBALL.equals(type)) {
            return 0.3125f;
        }
        if (EntityTypes.SPIDER.equals(type)) {
            return 1.4f;
        }
        if (EntityTypes.SQUID.equals(type)) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 0.8f : 0.95f;
        }
        if (EntityTypes.TURTLE.equals(type)) {
            return 1.2f;
        }
        if (EntityTypes.ALLAY.equals(type)) {
            return 0.35f;
        }
        if (EntityTypes.SNIFFER.equals(type)) {
            return 1.9f;
        }
        if (EntityTypes.CAMEL.equals(type)) {
            return 1.7f;
        }
        if (EntityTypes.WIND_CHARGE.equals(type)) {
            return 0.3125f;
        }
        if (EntityTypes.ARMOR_STAND.equals(type)) {
            return 0.5f;
        }
        if (EntityTypes.FALLING_BLOCK.equals(type)) {
            return 0.98f;
        }
        if (EntityTypes.FIREWORK_ROCKET.equals(type)) {
            return 0.25f;
        }
        return 0.6f;
    }

    public static Vector3d getRidingOffsetFromVehicle(PacketEntity entity, GrimPlayer player) {
        SimpleCollisionBox box = entity.getPossibleCollisionBoxes();
        double x = (box.maxX + box.minX) / 2.0;
        double y = box.minY;
        double z = (box.maxZ + box.minZ) / 2.0;
        if (entity instanceof PacketEntityTrackXRot) {
            PacketEntityTrackXRot xRotEntity = (PacketEntityTrackXRot)entity;
            if (EntityTypes.isTypeInstanceOf(entity.type, EntityTypes.BOAT)) {
                float f = 0.0f;
                float f1 = (float)(BoundingBoxSize.getPassengerRidingOffset(player, entity) - (double)0.35f);
                if (!entity.passengers.isEmpty()) {
                    int i = entity.passengers.indexOf(player.compensatedEntities.self);
                    if (i == 0) {
                        f = 0.2f;
                    } else if (i == 1) {
                        f = -0.6f;
                    }
                }
                Vector3d vec3 = new Vector3d(f, 0.0, 0.0);
                vec3 = BoundingBoxSize.yRot(GrimMath.radians(-xRotEntity.interpYaw) - 1.5707964f, vec3);
                return new Vector3d(x + vec3.x, y + (double)f1, z + vec3.z);
            }
            if (entity.type == EntityTypes.LLAMA) {
                float f = player.trigHandler.cos(GrimMath.radians(xRotEntity.interpYaw));
                float f1 = player.trigHandler.sin(GrimMath.radians(xRotEntity.interpYaw));
                return new Vector3d(x + (double)(0.3f * f1), y + BoundingBoxSize.getPassengerRidingOffset(player, entity) - (double)0.35f, z + (double)(0.3f * f));
            }
            if (entity.type == EntityTypes.CHICKEN) {
                float f = player.trigHandler.sin(GrimMath.radians(xRotEntity.interpYaw));
                float f1 = player.trigHandler.cos(GrimMath.radians(xRotEntity.interpYaw));
                return new Vector3d(x + (double)(0.1f * f), (y += (double)(BoundingBoxSize.getHeight(player, entity) * 0.5f)) - (double)0.35f, z - (double)(0.1f * f1));
            }
        }
        return new Vector3d(x, y + BoundingBoxSize.getPassengerRidingOffset(player, entity) - (double)0.35f, z);
    }

    private static Vector3d yRot(float yaw, Vector3d start) {
        double cos = (float)Math.cos(yaw);
        double sin = (float)Math.sin(yaw);
        return new Vector3d(start.x * cos + start.z * sin, start.y, start.z * cos - start.x * sin);
    }

    public static float getHeight(GrimPlayer player, PacketEntity packetEntity) {
        float height = BoundingBoxSize.getHeightMinusBaby(player, packetEntity);
        return height * (packetEntity.isBaby ? BoundingBoxSize.getBabyScaleFactor(packetEntity) : 1.0f);
    }

    public static double getMyRidingOffset(PacketEntity packetEntity) {
        EntityType type = packetEntity.type;
        if (EntityTypes.PIGLIN.equals(type) || EntityTypes.ZOMBIFIED_PIGLIN.equals(type) || EntityTypes.ZOMBIE.equals(type)) {
            return packetEntity.isBaby ? -0.05 : -0.45;
        }
        if (EntityTypes.SKELETON.equals(type)) {
            return -0.6;
        }
        if (EntityTypes.ENDERMITE.equals(type) || EntityTypes.SILVERFISH.equals(type)) {
            return 0.1;
        }
        if (EntityTypes.EVOKER.equals(type) || EntityTypes.ILLUSIONER.equals(type) || EntityTypes.PILLAGER.equals(type) || EntityTypes.RAVAGER.equals(type) || EntityTypes.VINDICATOR.equals(type) || EntityTypes.WITCH.equals(type)) {
            return -0.45;
        }
        if (EntityTypes.PLAYER.equals(type) || EntityTypes.MANNEQUIN.equals(type)) {
            return -0.35;
        }
        if (EntityTypes.isTypeInstanceOf(type, EntityTypes.ABSTRACT_ANIMAL)) {
            return 0.14;
        }
        return 0.0;
    }

    public static double getPassengerRidingOffset(GrimPlayer player, PacketEntity packetEntity) {
        if (packetEntity instanceof PacketEntityHorse) {
            return (double)BoundingBoxSize.getHeight(player, packetEntity) * 0.75 - 0.25;
        }
        EntityType type = packetEntity.type;
        if (EntityTypes.isTypeInstanceOf(type, EntityTypes.MINECART_ABSTRACT)) {
            return 0.0;
        }
        if (EntityTypes.isTypeInstanceOf(type, EntityTypes.BOAT)) {
            return -0.1;
        }
        if (EntityTypes.HAPPY_GHAST.equals(type)) {
            return 0.5;
        }
        if (EntityTypes.HOGLIN.equals(type) || EntityTypes.ZOGLIN.equals(type)) {
            return (double)BoundingBoxSize.getHeight(player, packetEntity) - (packetEntity.isBaby ? 0.2 : 0.15);
        }
        if (EntityTypes.LLAMA.equals(type)) {
            return (double)BoundingBoxSize.getHeight(player, packetEntity) * 0.67;
        }
        if (EntityTypes.PIGLIN.equals(type)) {
            return (double)BoundingBoxSize.getHeight(player, packetEntity) * 0.92;
        }
        if (EntityTypes.RAVAGER.equals(type)) {
            return 2.1;
        }
        if (EntityTypes.SKELETON.equals(type)) {
            return (double)BoundingBoxSize.getHeight(player, packetEntity) * 0.75 - 0.1875;
        }
        if (EntityTypes.SPIDER.equals(type)) {
            return (double)BoundingBoxSize.getHeight(player, packetEntity) * 0.5;
        }
        if (EntityTypes.STRIDER.equals(type)) {
            return (double)BoundingBoxSize.getHeight(player, packetEntity) - 0.19;
        }
        return (double)BoundingBoxSize.getHeight(player, packetEntity) * 0.75;
    }

    private static float getHeightMinusBaby(GrimPlayer player, PacketEntity packetEntity) {
        EntityType type = packetEntity.type;
        if (EntityTypes.ARMADILLO.equals(type)) {
            return 0.65f;
        }
        if (EntityTypes.AXOLOTL.equals(type)) {
            return 0.42f;
        }
        if (EntityTypes.BEE.equals(type) || EntityTypes.DOLPHIN.equals(type) || EntityTypes.ALLAY.equals(type)) {
            return 0.6f;
        }
        if (EntityTypes.EVOKER_FANGS.equals(type) || EntityTypes.VEX.equals(type)) {
            return 0.8f;
        }
        if (EntityTypes.SQUID.equals(type)) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 0.8f : 0.95f;
        }
        if (EntityTypes.PARROT.equals(type) || EntityTypes.BAT.equals(type) || EntityTypes.PIG.equals(type) || EntityTypes.SPIDER.equals(type)) {
            return 0.9f;
        }
        if (EntityTypes.WITHER_SKULL.equals(type) || EntityTypes.SHULKER_BULLET.equals(type)) {
            return 0.3125f;
        }
        if (EntityTypes.BLAZE.equals(type)) {
            return 1.8f;
        }
        if (EntityTypes.isTypeInstanceOf(type, EntityTypes.BOAT)) {
            return 0.5625f;
        }
        if (EntityTypes.HAPPY_GHAST.equals(type)) {
            return 4.0f;
        }
        if (EntityTypes.CAT.equals(type)) {
            return 0.7f;
        }
        if (EntityTypes.CAVE_SPIDER.equals(type)) {
            return 0.5f;
        }
        if (EntityTypes.FROG.equals(type)) {
            return 0.55f;
        }
        if (EntityTypes.CHICKEN.equals(type)) {
            return 0.7f;
        }
        if (EntityTypes.HOGLIN.equals(type) || EntityTypes.ZOGLIN.equals(type)) {
            return 1.4f;
        }
        if (EntityTypes.COW.equals(type)) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 1.4f : 1.3f;
        }
        if (EntityTypes.STRIDER.equals(type)) {
            return 1.7f;
        }
        if (EntityTypes.CREEPER.equals(type)) {
            return 1.7f;
        }
        if (EntityTypes.DONKEY.equals(type)) {
            return 1.5f;
        }
        if (packetEntity instanceof PacketEntityGuardian) {
            PacketEntityGuardian packetEntityGuardian = (PacketEntityGuardian)packetEntity;
            return packetEntityGuardian.isElder ? 1.9975f : 0.85f;
        }
        if (EntityTypes.ENDERMAN.equals(type) || EntityTypes.WARDEN.equals(type)) {
            return 2.9f;
        }
        if (EntityTypes.ENDERMITE.equals(type) || EntityTypes.COD.equals(type)) {
            return 0.3f;
        }
        if (EntityTypes.END_CRYSTAL.equals(type)) {
            return 2.0f;
        }
        if (EntityTypes.ENDER_DRAGON.equals(type)) {
            return 8.0f;
        }
        if (EntityTypes.FIREBALL.equals(type)) {
            return 1.0f;
        }
        if (EntityTypes.FOX.equals(type)) {
            return 0.7f;
        }
        if (EntityTypes.GHAST.equals(type)) {
            return 4.0f;
        }
        if (EntityTypes.GIANT.equals(type)) {
            return 12.0f;
        }
        if (EntityTypes.GUARDIAN.equals(type)) {
            return 0.85f;
        }
        if (EntityTypes.HORSE.equals(type)) {
            return 1.6f;
        }
        if (EntityTypes.IRON_GOLEM.equals(type)) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 2.7f : 2.9f;
        }
        if (EntityTypes.CREAKING.equals(type)) {
            return 2.7f;
        }
        if (EntityTypes.LLAMA.equals(type) || EntityTypes.TRADER_LLAMA.equals(type)) {
            return 1.87f;
        }
        if (EntityTypes.TROPICAL_FISH.equals(type)) {
            return 0.4f;
        }
        if (EntityTypes.MAGMA_CUBE.equals(type)) {
            if (packetEntity instanceof PacketEntitySizeable) {
                PacketEntitySizeable sizeable = (PacketEntitySizeable)packetEntity;
                float size = sizeable.size;
                return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_20_5) ? 0.52f * size : (player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 2.04f * (0.255f * size) : 0.51000005f * size);
            }
            return 0.7f;
        }
        if (EntityTypes.isTypeInstanceOf(type, EntityTypes.MINECART_ABSTRACT)) {
            return 0.7f;
        }
        if (EntityTypes.MULE.equals(type)) {
            return 1.6f;
        }
        if (EntityTypes.MOOSHROOM.equals(type)) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 1.4f : 1.3f;
        }
        if (EntityTypes.OCELOT.equals(type)) {
            return 0.7f;
        }
        if (EntityTypes.PANDA.equals(type)) {
            return 1.25f;
        }
        if (EntityTypes.PHANTOM.equals(type)) {
            if (packetEntity instanceof PacketEntitySizeable) {
                PacketEntitySizeable sizeable = (PacketEntitySizeable)packetEntity;
                return 0.5f + (float)sizeable.size * 0.1f;
            }
            return 1.8f;
        }
        if (EntityTypes.PLAYER.equals(type) || EntityTypes.MANNEQUIN.equals(type)) {
            return 1.8f;
        }
        if (EntityTypes.POLAR_BEAR.equals(type)) {
            return 1.4f;
        }
        if (EntityTypes.PUFFERFISH.equals(type)) {
            return 0.7f;
        }
        if (EntityTypes.RABBIT.equals(type)) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 0.5f : 0.7f;
        }
        if (EntityTypes.RAVAGER.equals(type)) {
            return 2.2f;
        }
        if (EntityTypes.SALMON.equals(type)) {
            return 0.4f;
        }
        if (EntityTypes.SHEEP.equals(type) || EntityTypes.GOAT.equals(type)) {
            return 1.3f;
        }
        if (EntityTypes.SHULKER.equals(type)) {
            return 2.0f;
        }
        if (EntityTypes.SILVERFISH.equals(type)) {
            return 0.3f;
        }
        if (EntityTypes.SKELETON.equals(type)) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 1.99f : 1.95f;
        }
        if (EntityTypes.SKELETON_HORSE.equals(type)) {
            return 1.6f;
        }
        if (EntityTypes.SLIME.equals(type)) {
            if (packetEntity instanceof PacketEntitySizeable) {
                PacketEntitySizeable sizeable = (PacketEntitySizeable)packetEntity;
                float size = sizeable.size;
                return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_20_5) ? 0.52f * size : (player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 2.04f * (0.255f * size) : 0.51000005f * size);
            }
            return 0.3125f;
        }
        if (EntityTypes.SMALL_FIREBALL.equals(type)) {
            return 0.3125f;
        }
        if (EntityTypes.SNOW_GOLEM.equals(type)) {
            return 1.9f;
        }
        if (EntityTypes.STRAY.equals(type)) {
            return 1.99f;
        }
        if (EntityTypes.TURTLE.equals(type)) {
            return 0.4f;
        }
        if (EntityTypes.WITHER.equals(type)) {
            return 3.5f;
        }
        if (EntityTypes.WITHER_SKELETON.equals(type)) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 2.4f : 2.535f;
        }
        if (EntityTypes.WOLF.equals(type)) {
            return player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? 0.85f : 0.8f;
        }
        if (EntityTypes.ZOMBIE_HORSE.equals(type)) {
            return 1.6f;
        }
        if (EntityTypes.TADPOLE.equals(type)) {
            return 0.3f;
        }
        if (EntityTypes.SNIFFER.equals(type)) {
            return 1.75f;
        }
        if (EntityTypes.CAMEL.equals(type)) {
            return 2.375f;
        }
        if (EntityTypes.BREEZE.equals(type)) {
            return 1.77f;
        }
        if (EntityTypes.BOGGED.equals(type)) {
            return 1.99f;
        }
        if (EntityTypes.WIND_CHARGE.equals(type)) {
            return 0.3125f;
        }
        if (EntityTypes.ARMOR_STAND.equals(type)) {
            return 1.975f;
        }
        if (EntityTypes.FALLING_BLOCK.equals(type)) {
            return 0.98f;
        }
        if (EntityTypes.VILLAGER.equals(type) && player.getClientVersion().isOlderThan(ClientVersion.V_1_9)) {
            return 1.8f;
        }
        if (EntityTypes.FIREWORK_ROCKET.equals(type)) {
            return 0.25f;
        }
        if (EntityTypes.COPPER_GOLEM.equals(type)) {
            return 1.0f;
        }
        return 1.95f;
    }

    private static float getBabyScaleFactor(PacketEntity packetEntity) {
        EntityType type = packetEntity.type;
        if (type == EntityTypes.TURTLE) {
            return 0.3f;
        }
        if (type == EntityTypes.HAPPY_GHAST) {
            return 0.2375f;
        }
        if (type == EntityTypes.DOLPHIN) {
            return 0.65f;
        }
        if (type == EntityTypes.ARMADILLO) {
            return 0.6f;
        }
        if (type == EntityTypes.CAMEL) {
            return 0.45f;
        }
        return 0.5f;
    }

    @Generated
    private BoundingBoxSize() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

