/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.impl.crash;

import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.CheckData;
import ac.grim.grimac.checks.type.PacketCheck;
import ac.grim.grimac.player.GrimPlayer;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.github.retrooper.packetevents.protocol.world.Location;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerFlying;

@CheckData(name="CrashC", description="Sent non-finite position or rotation")
public class CrashC
extends Check
implements PacketCheck {
    public CrashC(GrimPlayer playerData) {
        super(playerData);
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        Location pos;
        WrapperPlayClientPlayerFlying flying;
        if (WrapperPlayClientPlayerFlying.isFlying((PacketTypeCommon)event.getPacketType()) && (flying = new WrapperPlayClientPlayerFlying(event)).hasPositionChanged() && (Double.isNaN((pos = flying.getLocation()).getX()) || Double.isNaN(pos.getY()) || Double.isNaN(pos.getZ()) || Double.isInfinite(pos.getX()) || Double.isInfinite(pos.getY()) || Double.isInfinite(pos.getZ()) || Float.isNaN(pos.getYaw()) || Float.isNaN(pos.getPitch()) || Float.isInfinite(pos.getYaw()) || Float.isInfinite(pos.getPitch()))) {
            this.flagAndAlert("xyzYP: " + pos.getX() + ", " + pos.getY() + ", " + pos.getZ() + ", " + pos.getYaw() + ", " + pos.getPitch());
            this.player.getSetbackTeleportUtil().executeViolationSetback();
            event.setCancelled(true);
            this.player.onPacketCancel();
        }
    }
}

