/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.events.packets;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.events.packets.CheckManagerListener;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.utils.anticheat.update.BlockBreak;
import ac.grim.grimac.utils.anticheat.update.PositionUpdate;
import ac.grim.grimac.utils.anticheat.update.PredictionComplete;
import ac.grim.grimac.utils.anticheat.update.RotationUpdate;
import ac.grim.grimac.utils.anticheat.update.VehiclePositionUpdate;
import ac.grim.grimac.utils.change.BlockModification;
import ac.grim.grimac.utils.data.HeadRotation;
import ac.grim.grimac.utils.data.RotationData;
import ac.grim.grimac.utils.data.TeleportAcceptData;
import ac.grim.grimac.utils.data.VelocityData;
import ac.grim.grimac.utils.latency.CompensatedWorld;
import ac.grim.grimac.utils.math.VectorUtils;
import ac.grim.grimac.utils.nmsutil.BlockBreakSpeed;
import ac.grim.grimac.utils.nmsutil.Collisions;
import ac.grim.grimac.utils.nmsutil.Materials;
import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListenerAbstract;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.protocol.player.DiggingAction;
import com.github.retrooper.packetevents.protocol.world.Location;
import com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import com.github.retrooper.packetevents.protocol.world.states.type.StateType;
import com.github.retrooper.packetevents.protocol.world.states.type.StateTypes;
import com.github.retrooper.packetevents.util.Vector3d;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerDigging;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerFlying;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientVehicleMove;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Function;

public class PreViaCheckManagerListener
extends PacketListenerAbstract {
    private static final Function<StateType, Boolean> BREAKABLE = type -> !type.isAir() && type.getHardness() != -1.0f && type != StateTypes.WATER && type != StateTypes.LAVA;

    public PreViaCheckManagerListener() {
        super(PacketListenerPriority.LOW);
    }

    public boolean isPreVia() {
        return true;
    }

    public void onPacketReceive(PacketReceiveEvent event) {
        Vector3d position;
        GrimPlayer player = GrimAPI.INSTANCE.getPlayerDataManager().getPlayer(event.getUser());
        if (player == null) {
            return;
        }
        if (event.getPacketType() == PacketType.Play.Client.VEHICLE_MOVE) {
            WrapperPlayClientVehicleMove move = new WrapperPlayClientVehicleMove(event);
            Vector3d position2 = move.getPosition();
            player.packetStateData.lastPacketWasTeleport = player.getSetbackTeleportUtil().checkVehicleTeleportQueue(position2.getX(), position2.getY(), position2.getZ());
        }
        TeleportAcceptData teleportData = null;
        if (WrapperPlayClientPlayerFlying.isFlying((PacketTypeCommon)event.getPacketType())) {
            player.serverOpenedInventoryThisTick = false;
            WrapperPlayClientPlayerFlying flying = new WrapperPlayClientPlayerFlying(event);
            position = VectorUtils.clampVector(flying.getLocation().getPosition());
            teleportData = flying.hasPositionChanged() && flying.hasRotationChanged() ? player.getSetbackTeleportUtil().checkTeleportQueue(position.getX(), position.getY(), position.getZ()) : new TeleportAcceptData();
            player.packetStateData.lastPacketWasTeleport = teleportData.isTeleport();
            if (flying.hasRotationChanged() && !flying.hasPositionChanged() && !flying.isOnGround() && !flying.isHorizontalCollision()) {
                ArrayList<RotationData> rotations = new ArrayList<RotationData>();
                for (RotationData data : player.pendingRotations) {
                    rotations.add(data);
                    if (data.isAccepted()) continue;
                    break;
                }
                Collections.reverse(rotations);
                for (RotationData data : rotations) {
                    if (data.getYaw() != flying.getLocation().getYaw() || data.getPitch() != flying.getLocation().getPitch() || data.getTransaction() != player.getLastTransactionReceived()) continue;
                    player.packetStateData.lastPacketWasTeleport = true;
                    data.accept();
                    break;
                }
            }
            player.packetStateData.lastPacketWasOnePointSeventeenDuplicate = this.isMojangStupid(player, event, flying);
        }
        if (player.inVehicle() ? event.getPacketType() == PacketType.Play.Client.VEHICLE_MOVE : WrapperPlayClientPlayerFlying.isFlying((PacketTypeCommon)event.getPacketType()) && !player.packetStateData.lastPacketWasOnePointSeventeenDuplicate) {
            int kbEntityId = player.inVehicle() ? player.getRidingVehicleId() : player.entityID;
            VelocityData calculatedFirstBreadKb = player.checkManager.getKnockbackHandler().calculateFirstBreadKnockback(kbEntityId, player.lastTransactionReceived.get());
            VelocityData calculatedRequireKb = player.checkManager.getKnockbackHandler().calculateRequiredKB(kbEntityId, player.lastTransactionReceived.get(), false);
            player.firstBreadKB = calculatedFirstBreadKb == null ? player.firstBreadKB : calculatedFirstBreadKb;
            player.likelyKB = calculatedRequireKb == null ? player.likelyKB : calculatedRequireKb;
            VelocityData calculateFirstBreadExplosion = player.checkManager.getExplosionHandler().getFirstBreadAddedExplosion(player.lastTransactionReceived.get());
            VelocityData calculateRequiredExplosion = player.checkManager.getExplosionHandler().getPossibleExplosions(player.lastTransactionReceived.get(), false);
            player.firstBreadExplosion = calculateFirstBreadExplosion == null ? player.firstBreadExplosion : calculateFirstBreadExplosion;
            player.likelyExplosions = calculateRequiredExplosion == null ? player.likelyExplosions : calculateRequiredExplosion;
        }
        player.checkManager.onPrePredictionReceivePacket(event);
        if (event.isCancelled() && (WrapperPlayClientPlayerFlying.isFlying((PacketTypeCommon)event.getPacketType()) || event.getPacketType() == PacketType.Play.Client.VEHICLE_MOVE)) {
            player.packetStateData.cancelDuplicatePacket = false;
            return;
        }
        if (WrapperPlayClientPlayerFlying.isFlying((PacketTypeCommon)event.getPacketType())) {
            WrapperPlayClientPlayerFlying flying = new WrapperPlayClientPlayerFlying(event);
            Location pos = flying.getLocation();
            boolean ignoreRotation = player.packetStateData.lastPacketWasOnePointSeventeenDuplicate && player.isIgnoreDuplicatePacketRotation();
            this.handleFlying(player, pos.getX(), pos.getY(), pos.getZ(), ignoreRotation ? 0.0f : pos.getYaw(), ignoreRotation ? 0.0f : pos.getPitch(), flying.hasPositionChanged(), flying.hasRotationChanged() && !ignoreRotation, flying.isOnGround(), teleportData, event);
        }
        if (event.getPacketType() == PacketType.Play.Client.VEHICLE_MOVE && player.inVehicle()) {
            WrapperPlayClientVehicleMove move = new WrapperPlayClientVehicleMove(event);
            position = move.getPosition();
            player.lastX = player.x;
            player.lastY = player.y;
            player.lastZ = player.z;
            Vector3d clamp = VectorUtils.clampVector(position);
            player.x = clamp.getX();
            player.y = clamp.getY();
            player.z = clamp.getZ();
            player.xRot = move.getYaw();
            player.yRot = move.getPitch();
            VehiclePositionUpdate update = new VehiclePositionUpdate(clamp, position, move.getYaw(), move.getPitch(), player.packetStateData.lastPacketWasTeleport);
            player.checkManager.onVehiclePositionUpdate(update);
            player.packetStateData.receivedSteerVehicle = false;
        }
        if (event.getPacketType() == PacketType.Play.Client.PLAYER_DIGGING) {
            this.handleDigging(player, event);
        }
        player.checkManager.onPreViaPacketReceive(event);
        if (event.getPacketType() == PacketType.Play.Client.CLIENT_TICK_END) {
            player.serverOpenedInventoryThisTick = false;
            if (!player.packetStateData.didSendMovementBeforeTickEnd) {
                player.packetStateData.didLastLastMovementIncludePosition = player.packetStateData.didLastMovementIncludePosition;
                player.packetStateData.didLastMovementIncludePosition = false;
            }
            player.packetStateData.didSendMovementBeforeTickEnd = false;
        }
        if (event.isCancelled()) {
            player.packetStateData.lastPacketWasOnePointSeventeenDuplicate = false;
            player.packetStateData.lastPacketWasTeleport = false;
        }
    }

    public void onPacketSend(PacketSendEvent event) {
        GrimPlayer player = GrimAPI.INSTANCE.getPlayerDataManager().getPlayer(event.getUser());
        if (player == null) {
            return;
        }
        player.checkManager.onPreViaPacketSend(event);
    }

    private boolean isMojangStupid(GrimPlayer player, PacketReceiveEvent event, WrapperPlayClientPlayerFlying flying) {
        if (player.packetStateData.lastPacketWasTeleport) {
            return false;
        }
        if (player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_21)) {
            return false;
        }
        Location location = flying.getLocation();
        double threshold = player.getMovementThreshold();
        if (!player.packetStateData.lastPacketWasTeleport && flying.hasPositionChanged() && flying.hasRotationChanged() && (flying.isOnGround() == player.packetStateData.packetPlayerOnGround && player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_17) && player.filterMojangStupidityOnMojangStupidity.distanceSquared(location.getPosition()) < threshold * threshold || player.inVehicle())) {
            if (PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_9)) {
                if (player.isCancelDuplicatePacket()) {
                    player.packetStateData.cancelDuplicatePacket = true;
                }
            } else {
                flying.setLocation(new Location(player.filterMojangStupidityOnMojangStupidity.getX(), player.filterMojangStupidityOnMojangStupidity.getY(), player.filterMojangStupidityOnMojangStupidity.getZ(), location.getYaw(), location.getPitch()));
                event.markForReEncode(true);
            }
            player.packetStateData.lastPacketWasOnePointSeventeenDuplicate = true;
            if (!player.isIgnoreDuplicatePacketRotation()) {
                if (player.xRot != location.getYaw() || player.yRot != location.getPitch()) {
                    player.lastXRot = player.xRot;
                    player.lastYRot = player.yRot;
                }
                player.xRot = location.getYaw();
                player.yRot = location.getPitch();
            }
            player.packetStateData.lastClaimedPosition = location.getPosition();
            return true;
        }
        return false;
    }

    private void handleFlying(GrimPlayer player, double x, double y, double z, float yaw, float pitch, boolean hasPosition, boolean hasLook, boolean onGround, TeleportAcceptData teleportData, PacketReceiveEvent event) {
        Object update;
        long now = System.currentTimeMillis();
        if (!hasPosition) {
            player.uncertaintyHandler.lastPointThree.reset();
        }
        if (hasLook && (!player.packetStateData.lastPacketWasOnePointSeventeenDuplicate || player.xRot != yaw || player.yRot != pitch)) {
            player.lastXRot = player.xRot;
            player.lastYRot = player.yRot;
        }
        CheckManagerListener.handleQueuedPlaces(player, hasLook, pitch, yaw, now);
        CheckManagerListener.handleQueuedBreaks(player, hasLook, pitch, yaw, now);
        if (hasPosition) {
            player.packetStateData.lastClaimedPosition = new Vector3d(x, y, z);
        }
        if (!hasPosition && onGround != player.packetStateData.packetPlayerOnGround && !player.inVehicle()) {
            boolean canFeasiblyPointThree = Collisions.slowCouldPointThreeHitGround(player, player.x, player.y, player.z);
            if (!canFeasiblyPointThree && !player.compensatedWorld.isNearHardEntity(player.boundingBox.copy().expand(4.0)) || player.clientVelocity.getY() > 0.06 && !player.uncertaintyHandler.wasAffectedByStuckSpeed()) {
                player.getSetbackTeleportUtil().executeForceResync();
            } else {
                player.lastOnGround = onGround;
                player.clientClaimsLastOnGround = onGround;
                player.uncertaintyHandler.onGroundUncertain = true;
            }
        }
        if (!player.packetStateData.lastPacketWasTeleport) {
            player.packetStateData.packetPlayerOnGround = onGround;
        }
        if (hasLook) {
            player.xRot = yaw;
            player.yRot = pitch;
            float deltaXRot = player.xRot - player.lastXRot;
            float deltaYRot = player.yRot - player.lastYRot;
            update = new RotationUpdate(new HeadRotation(player.lastXRot, player.lastYRot), new HeadRotation(player.xRot, player.yRot), deltaXRot, deltaYRot);
            player.checkManager.onRotationUpdate((RotationUpdate)update);
        }
        if (hasPosition) {
            Vector3d position = new Vector3d(x, y, z);
            Vector3d clampVector = VectorUtils.clampVector(position);
            update = new PositionUpdate(new Vector3d(player.x, player.y, player.z), position, onGround, teleportData.getSetback(), teleportData.getTeleportData(), teleportData.isTeleport());
            if (!player.packetStateData.lastPacketWasOnePointSeventeenDuplicate) {
                player.filterMojangStupidityOnMojangStupidity = clampVector;
            }
            if (!player.inVehicle() && !player.packetStateData.lastPacketWasOnePointSeventeenDuplicate) {
                player.lastX = player.x;
                player.lastY = player.y;
                player.lastZ = player.z;
                player.x = clampVector.getX();
                player.y = clampVector.getY();
                player.z = clampVector.getZ();
                player.checkManager.onPositionUpdate((PositionUpdate)update);
            } else if (((PositionUpdate)update).isTeleport()) {
                player.getSetbackTeleportUtil().onPredictionComplete(new PredictionComplete(0.0, (PositionUpdate)update, true));
            }
        }
        player.packetStateData.didLastLastMovementIncludePosition = player.packetStateData.didLastMovementIncludePosition;
        player.packetStateData.didLastMovementIncludePosition = hasPosition;
        if (!player.packetStateData.lastPacketWasTeleport) {
            player.packetStateData.didSendMovementBeforeTickEnd = true;
        }
        player.packetStateData.horseInteractCausedForcedRotation = false;
    }

    private void handleDigging(GrimPlayer player, PacketReceiveEvent event) {
        double damage;
        player.lastBlockBreak = System.currentTimeMillis();
        WrapperPlayClientPlayerDigging packet = new WrapperPlayClientPlayerDigging(event);
        DiggingAction action = packet.getAction();
        if (action != DiggingAction.START_DIGGING && action != DiggingAction.FINISHED_DIGGING && action != DiggingAction.CANCELLED_DIGGING) {
            return;
        }
        BlockBreak blockBreak = new BlockBreak(player, packet.getBlockPosition(), packet.getBlockFace(), packet.getBlockFaceId(), action, packet.getSequence(), player.compensatedWorld.getBlock(packet.getBlockPosition()));
        player.checkManager.onBlockBreak(blockBreak);
        if (blockBreak.isCancelled()) {
            event.setCancelled(true);
            player.onPacketCancel();
            player.resyncPosition(blockBreak.position, packet.getSequence());
            return;
        }
        player.queuedBreaks.add(blockBreak);
        if (action == DiggingAction.FINISHED_DIGGING && BREAKABLE.apply(blockBreak.block.getType()).booleanValue()) {
            player.compensatedWorld.startPredicting();
            player.compensatedWorld.updateBlock(blockBreak.position.x, blockBreak.position.y, blockBreak.position.z, 0);
            player.compensatedWorld.stopPredicting((PacketWrapper<?>)packet);
        }
        if (action == DiggingAction.START_DIGGING && (damage = BlockBreakSpeed.getBlockDamage(player, blockBreak.block)) >= 1.0) {
            player.compensatedWorld.startPredicting();
            player.blockHistory.add(new BlockModification(player.compensatedWorld.getBlock(blockBreak.position), WrappedBlockState.getByGlobalId((int)0), blockBreak.position, GrimAPI.INSTANCE.getTickManager().currentTick, BlockModification.Cause.START_DIGGING));
            if (player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_13) && Materials.isWaterSource(player.getClientVersion(), blockBreak.block)) {
                player.compensatedWorld.updateBlock(blockBreak.position, StateTypes.WATER.createBlockState(CompensatedWorld.blockVersion));
            } else {
                player.compensatedWorld.updateBlock(blockBreak.position.x, blockBreak.position.y, blockBreak.position.z, 0);
            }
            player.compensatedWorld.stopPredicting((PacketWrapper<?>)packet);
        }
        player.compensatedWorld.handleBlockBreakPrediction(packet);
    }
}

