/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.platform.fabric.utils.convert;

import ac.grim.grimac.platform.fabric.utils.convert.IFabricConversionUtil;
import com.github.retrooper.packetevents.protocol.item.ItemStack;
import com.github.retrooper.packetevents.protocol.player.GameMode;
import com.github.retrooper.packetevents.protocol.player.InteractionHand;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public abstract class FabricConversionUtil
implements IFabricConversionUtil {
    private IFabricConversionUtil fabricConversionUtilSupplier;
    private final Function<class_1799, ItemStack> itemStackMapperFunction = fabricStack -> {
        throw new UnsupportedOperationException();
    };
    private final Function<Component, class_2561> nativeTextMapperFunction = component -> {
        throw new UnsupportedOperationException();
    };

    @Override
    public ItemStack fromFabricItemStack(class_1799 fabricStack) {
        return this.fabricConversionUtilSupplier.fromFabricItemStack(fabricStack);
    }

    @Override
    public class_2561 toNativeText(Component component) {
        return this.fabricConversionUtilSupplier.toNativeText(component);
    }

    public static class_1934 toFabricGameMode(GameMode gameMode) {
        return switch (gameMode) {
            default -> throw new IncompatibleClassChangeError();
            case GameMode.CREATIVE -> class_1934.field_9220;
            case GameMode.SURVIVAL -> class_1934.field_9215;
            case GameMode.ADVENTURE -> class_1934.field_9216;
            case GameMode.SPECTATOR -> class_1934.field_9219;
        };
    }

    public static GameMode fromFabricGameMode(class_1934 fabricGameMode) {
        return switch (fabricGameMode) {
            case class_1934.field_9220 -> GameMode.CREATIVE;
            case class_1934.field_9215 -> GameMode.SURVIVAL;
            case class_1934.field_9216 -> GameMode.ADVENTURE;
            case class_1934.field_9219 -> GameMode.SPECTATOR;
            default -> throw new IllegalArgumentException("Unknown Fabric GameMode: " + String.valueOf(fabricGameMode));
        };
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    @Nullable
    public static InteractionHand fromFabricHand(@Nullable class_1268 hand) {
        InteractionHand interactionHand;
        if (hand == null) {
            interactionHand = null;
        } else {
            switch (hand) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case field_5810: {
                    interactionHand = InteractionHand.OFF_HAND;
                    break;
                }
                case field_5808: {
                    interactionHand = InteractionHand.MAIN_HAND;
                }
            }
        }
        return interactionHand;
    }
}

