/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.platform.fabric.utils.metrics;

import ac.grim.grimac.utils.anticheat.LogUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class BStatsConfig {
    private static final String HEADER = "# bStats (https://bStats.org) collects some basic information for plugin authors, like how\n# many people use their plugin and their total player count. It's recommended to keep bStats\n# enabled, but if you're not comfortable with this, you can turn this setting off. There is no\n# performance penalty associated with having metrics enabled, and data sent to bStats is fully\n# anonymous.\n";

    public static Config loadConfig() {
        File bStatsFolder = new File(FabricLoader.getInstance().getConfigDir().toString(), "bStats");
        File configFile = new File(bStatsFolder, "config.yml");
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        Yaml yaml = new Yaml(options);
        Config config = new Config();
        try {
            Map<String, Boolean> data;
            if (!configFile.exists()) {
                bStatsFolder.mkdirs();
                data = new LinkedHashMap<String, Boolean>();
                data.put("enabled", true);
                data.put("serverUuid", (Boolean)((Object)UUID.randomUUID().toString()));
                data.put("logFailedRequests", (Boolean)((Object)false));
                data.put("logSentData", (Boolean)((Object)false));
                data.put("logResponseStatusText", (Boolean)((Object)false));
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), StandardCharsets.UTF_8);){
                    writer.write(HEADER);
                    yaml.dump(data, (Writer)writer);
                }
            } else {
                data = (Map)yaml.load((InputStream)new FileInputStream(configFile));
                if (data == null) {
                    data = new LinkedHashMap();
                }
            }
            config.enabled = BStatsConfig.getBoolean(data, "enabled", true);
            config.serverUuid = BStatsConfig.getString(data, "serverUuid", UUID.randomUUID().toString());
            config.logFailedRequests = BStatsConfig.getBoolean(data, "logFailedRequests", false);
            config.logSentData = BStatsConfig.getBoolean(data, "logSentData", false);
            config.logResponseStatusText = BStatsConfig.getBoolean(data, "logResponseStatusText", false);
        }
        catch (IOException e) {
            LogUtil.error((String)"Failed to load bStats config. Using default values.", (Throwable)e);
            config.enabled = true;
            config.serverUuid = UUID.randomUUID().toString();
            config.logFailedRequests = false;
            config.logSentData = false;
            config.logResponseStatusText = false;
        }
        return config;
    }

    private static boolean getBoolean(Map<String, Object> map, String key, boolean defaultValue) {
        Object value = map.get(key);
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }

    private static String getString(Map<String, Object> map, String key, String defaultValue) {
        Object value = map.get(key);
        return value instanceof String ? (String)value : defaultValue;
    }

    public static class Config {
        public boolean enabled = true;
        public String serverUuid;
        public boolean logFailedRequests = false;
        public boolean logSentData = false;
        public boolean logResponseStatusText = false;
    }
}

