/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.platform.fabric.player;

import ac.grim.grimac.platform.api.entity.GrimEntity;
import ac.grim.grimac.platform.api.player.PlatformInventory;
import ac.grim.grimac.platform.api.player.PlatformPlayer;
import ac.grim.grimac.platform.fabric.GrimACFabricLoaderPlugin;
import ac.grim.grimac.platform.fabric.entity.AbstractFabricGrimEntity;
import ac.grim.grimac.platform.fabric.player.AbstractFabricPlatformInventory;
import ac.grim.grimac.platform.fabric.utils.convert.FabricConversionUtil;
import com.github.retrooper.packetevents.protocol.player.GameMode;
import com.github.retrooper.packetevents.util.Vector3d;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.minecraft.class_1297;
import net.minecraft.class_3222;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class AbstractFabricPlatformPlayer
extends AbstractFabricGrimEntity
implements PlatformPlayer {
    protected class_3222 fabricPlayer;
    protected final AbstractFabricPlatformInventory inventory;

    public AbstractFabricPlatformPlayer(class_3222 player) {
        super((class_1297)player);
        this.fabricPlayer = player;
        this.inventory = GrimACFabricLoaderPlugin.LOADER.getPlatformPlayerFactory().getPlatformInventory(player);
    }

    public void kickPlayer(String textReason) {
        this.fabricPlayer.field_13987.method_14367(GrimACFabricLoaderPlugin.LOADER.getFabricMessageUtils().textLiteral(textReason));
    }

    public boolean isSneaking() {
        return this.fabricPlayer.method_5715();
    }

    public void setSneaking(boolean isSneaking) {
        this.fabricPlayer.method_5660(isSneaking);
    }

    public void sendMessage(String message) {
        this.fabricPlayer.method_7353(GrimACFabricLoaderPlugin.LOADER.getFabricMessageUtils().textLiteral(message), false);
    }

    public void sendMessage(Component message) {
        this.fabricPlayer.method_7353(GrimACFabricLoaderPlugin.LOADER.getFabricConversionUtil().toNativeText(message), false);
    }

    public boolean isOnline() {
        return !this.fabricPlayer.method_14239();
    }

    public String getName() {
        return this.fabricPlayer.method_5477().getString();
    }

    public void updateInventory() {
        this.fabricPlayer.field_7512.method_7623();
    }

    public Vector3d getPosition() {
        return new Vector3d(this.fabricPlayer.method_23317(), this.fabricPlayer.method_23318(), this.fabricPlayer.method_23321());
    }

    public PlatformInventory getInventory() {
        return this.inventory;
    }

    public GrimEntity getVehicle() {
        class_1297 vehicle = this.fabricPlayer.method_5854();
        return vehicle != null ? GrimACFabricLoaderPlugin.LOADER.getPlatformPlayerFactory().getPlatformEntity(vehicle) : null;
    }

    public GameMode getGameMode() {
        return FabricConversionUtil.fromFabricGameMode(this.fabricPlayer.field_13974.method_14257());
    }

    public void setGameMode(GameMode gameMode) {
        this.fabricPlayer.method_7336(FabricConversionUtil.toFabricGameMode(gameMode));
    }

    @Override
    public UUID getUniqueId() {
        return this.fabricPlayer.method_5667();
    }

    public boolean isExternalPlayer() {
        return false;
    }

    public void sendPluginMessage(String channelName, byte[] byteArray) {
        throw new UnsupportedOperationException();
    }

    public void replaceNativePlayer(Object nativePlayerObject) {
        this.inventory.fabricPlayer = (class_3222)nativePlayerObject;
        this.inventory.inventory = ((class_3222)nativePlayerObject).field_7514;
        this.fabricPlayer = (class_3222)nativePlayerObject;
    }

    public @NonNull class_3222 getNative() {
        return this.fabricPlayer;
    }

    public boolean isDead() {
        return this.fabricPlayer.method_29504();
    }
}

