/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.platform.fabric.scheduler;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.api.plugin.GrimPlugin;
import ac.grim.grimac.platform.api.scheduler.AsyncScheduler;
import ac.grim.grimac.platform.api.scheduler.EntityScheduler;
import ac.grim.grimac.platform.api.scheduler.GlobalRegionScheduler;
import ac.grim.grimac.platform.api.scheduler.PlatformScheduler;
import ac.grim.grimac.platform.api.scheduler.RegionScheduler;
import ac.grim.grimac.platform.fabric.scheduler.FabricAsyncScheduler;
import ac.grim.grimac.platform.fabric.scheduler.FabricEntityScheduler;
import ac.grim.grimac.platform.fabric.scheduler.FabricGlobalRegionScheduler;
import ac.grim.grimac.platform.fabric.scheduler.FabricRegionScheduler;
import ac.grim.grimac.utils.anticheat.LogUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.NonNull;

public class FabricPlatformScheduler
implements PlatformScheduler {
    private final FabricAsyncScheduler asyncScheduler;
    private final FabricGlobalRegionScheduler globalRegionScheduler;
    private final FabricEntityScheduler entityScheduler;
    private final FabricRegionScheduler regionScheduler;
    public static final ThreadLocal<Boolean> EXECUTING_TASK = ThreadLocal.withInitial(() -> false);

    public FabricPlatformScheduler() {
        GrimPlugin plugin = GrimAPI.INSTANCE.getGrimPlugin();
        this.asyncScheduler = new FabricAsyncScheduler(plugin);
        this.globalRegionScheduler = new FabricGlobalRegionScheduler(plugin);
        this.entityScheduler = new FabricEntityScheduler(plugin);
        this.regionScheduler = new FabricRegionScheduler(plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void handleSyncTasks(Map<ScheduledTask, Runnable> taskMap, MinecraftServer server, GrimPlugin plugin) {
        Iterator<ScheduledTask> iterator = taskMap.keySet().iterator();
        while (iterator.hasNext()) {
            ScheduledTask task = iterator.next();
            if ((long)server.method_3780() < task.nextRunTick) continue;
            try {
                EXECUTING_TASK.set(true);
                task.task.run();
            }
            catch (Exception e) {
                LogUtil.error((String)"Error executing scheduled task ", (Throwable)e);
            }
            finally {
                EXECUTING_TASK.set(false);
            }
            if (task.isPeriodic) {
                task.nextRunTick = (long)server.method_3780() + task.period;
                continue;
            }
            iterator.remove();
        }
    }

    protected static void cancelPluginTasks(Map<ScheduledTask, Runnable> taskMap, GrimPlugin plugin) {
        Iterator<Map.Entry<ScheduledTask, Runnable>> iterator = taskMap.entrySet().iterator();
        ArrayList<Runnable> cancellationTasks = new ArrayList<Runnable>();
        while (iterator.hasNext()) {
            Map.Entry<ScheduledTask, Runnable> entry = iterator.next();
            if (!entry.getKey().plugin.equals((Object)plugin)) continue;
            cancellationTasks.add(entry.getValue());
            iterator.remove();
        }
        for (Runnable cancellationTask : cancellationTasks) {
            cancellationTask.run();
        }
    }

    protected static void cancelAllTasks(Map<?, Runnable> taskMap) {
        ArrayList<Runnable> cancellationTasks = new ArrayList<Runnable>(taskMap.values());
        taskMap.clear();
        for (Runnable cancellationTask : cancellationTasks) {
            cancellationTask.run();
        }
    }

    protected static void scheduleTask(Map<ScheduledTask, Runnable> taskMap, GrimPlugin plugin, Runnable task, long initialDelayTicks, long periodTicks, boolean isPeriodic) {
    }

    public @NonNull AsyncScheduler getAsyncScheduler() {
        return this.asyncScheduler;
    }

    public @NonNull GlobalRegionScheduler getGlobalRegionScheduler() {
        return this.globalRegionScheduler;
    }

    public @NonNull EntityScheduler getEntityScheduler() {
        return this.entityScheduler;
    }

    public @NonNull RegionScheduler getRegionScheduler() {
        return this.regionScheduler;
    }

    public void shutdown() {
        this.asyncScheduler.cancelAll();
        this.globalRegionScheduler.cancelAll();
        this.entityScheduler.cancelAll();
        this.regionScheduler.cancelAll();
    }

    protected static class ScheduledTask {
        final Runnable task;
        final long period;
        final boolean isPeriodic;
        final GrimPlugin plugin;
        long nextRunTick;

        ScheduledTask(Runnable task, long nextRunTick, long period, boolean isPeriodic, GrimPlugin plugin) {
            this.task = task;
            this.nextRunTick = nextRunTick;
            this.period = period;
            this.isPeriodic = isPeriodic;
            this.plugin = plugin;
        }
    }
}

