/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.impl.elytra;

import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.CheckData;
import ac.grim.grimac.checks.type.PostPredictionCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientEntityAction;
import ac.grim.grimac.utils.anticheat.update.PredictionComplete;

@CheckData(name="ElytraA", description="Started gliding while already gliding")
public class ElytraA
extends Check
implements PostPredictionCheck {
    private boolean setback;

    public ElytraA(GrimPlayer player) {
        super(player);
    }

    public void onStartGliding(PacketReceiveEvent event) {
        if (this.player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_8)) {
            return;
        }
        if (this.player.isGliding && this.flagAndAlert()) {
            this.setback = true;
            if (this.shouldModifyPackets()) {
                event.setCancelled(true);
                this.player.onPacketCancel();
                this.player.resyncPose();
            }
        }
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        if (this.player.getClientVersion().isOlderThan(ClientVersion.V_1_15) && event.getPacketType() == PacketType.Play.Client.ENTITY_ACTION && new WrapperPlayClientEntityAction(event).getAction() == WrapperPlayClientEntityAction.Action.START_FLYING_WITH_ELYTRA) {
            this.onStartGliding(event);
        }
    }

    @Override
    public void onPredictionComplete(PredictionComplete predictionComplete) {
        if (this.setback) {
            this.setbackIfAboveSetbackVL();
            this.setback = false;
        }
    }
}

