/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.events.packets;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsE;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsF;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsG;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsH;
import ac.grim.grimac.checks.impl.elytra.ElytraC;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketListenerAbstract;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketListenerPriority;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketSendEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3d;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerJoinGame;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerRespawn;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateHealth;
import ac.grim.grimac.utils.data.KnownInput;
import ac.grim.grimac.utils.data.TrackerData;
import ac.grim.grimac.utils.data.packetentity.PacketEntitySelf;
import ac.grim.grimac.utils.enums.Pose;
import ac.grim.grimac.utils.math.Vector3dm;
import java.util.List;
import java.util.Objects;

public class PacketPlayerRespawn
extends PacketListenerAbstract {
    private static final byte KEEP_ATTRIBUTES = 1;
    private static final byte KEEP_TRACKED_DATA = 2;
    private static final byte KEEP_ALL = 3;

    public PacketPlayerRespawn() {
        super(PacketListenerPriority.HIGH);
    }

    private boolean hasFlag(WrapperPlayServerRespawn respawn, byte flag) {
        if (flag == 1) {
            if (PacketEvents.getAPI().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_15)) {
                return false;
            }
        } else if (flag == 2 && PacketEvents.getAPI().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_15)) {
            return true;
        }
        return (respawn.getKeptData() & flag) != 0;
    }

    @Override
    public void onPacketSend(PacketSendEvent event) {
        GrimPlayer player;
        if (event.getPacketType() == PacketType.Play.Server.UPDATE_HEALTH) {
            WrapperPlayServerUpdateHealth health = new WrapperPlayServerUpdateHealth(event);
            player = GrimAPI.INSTANCE.getPlayerDataManager().getPlayer(event.getUser());
            if (player == null) {
                return;
            }
            if (player.packetStateData.lastFood == health.getFood() && player.packetStateData.lastHealth == health.getHealth() && player.packetStateData.lastSaturation == health.getFoodSaturation() && PacketEvents.getAPI().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_9)) {
                return;
            }
            player.packetStateData.lastFood = health.getFood();
            player.packetStateData.lastHealth = health.getHealth();
            player.packetStateData.lastSaturation = health.getFoodSaturation();
            player.sendTransaction();
            if (health.getFood() == 20) {
                player.latencyUtils.addRealTimeTask(player.lastTransactionReceived.get(), () -> {
                    player.food = 20;
                });
            } else {
                player.latencyUtils.addRealTimeTask(player.lastTransactionReceived.get() + 1, () -> {
                    player.food = health.getFood();
                });
            }
            if (health.getHealth() <= 0.0f) {
                player.latencyUtils.addRealTimeTask(player.lastTransactionSent.get(), () -> {
                    player.compensatedEntities.self.isDead = true;
                });
            } else {
                player.latencyUtils.addRealTimeTask(player.lastTransactionSent.get() + 1, () -> {
                    player.compensatedEntities.self.isDead = false;
                });
            }
            event.getTasksAfterSend().add(player::sendTransaction);
        }
        if (event.getPacketType() == PacketType.Play.Server.JOIN_GAME) {
            GrimPlayer player2 = GrimAPI.INSTANCE.getPlayerDataManager().getPlayer(event.getUser());
            if (player2 == null) {
                return;
            }
            WrapperPlayServerJoinGame joinGame = new WrapperPlayServerJoinGame(event);
            player2.gamemode = joinGame.getGameMode();
            player2.entityID = joinGame.getEntityId();
            player2.dimensionType = joinGame.getDimensionType();
            player2.worldName = joinGame.getWorldName();
            if (PacketEvents.getAPI().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_17)) {
                return;
            }
            player2.compensatedWorld.setDimension(joinGame.getDimensionType(), event.getUser());
        }
        if (event.getPacketType() == PacketType.Play.Server.RESPAWN) {
            WrapperPlayServerRespawn respawn = new WrapperPlayServerRespawn(event);
            player = GrimAPI.INSTANCE.getPlayerDataManager().getPlayer(event.getUser());
            if (player == null) {
                return;
            }
            List<Runnable> tasks = event.getTasksAfterSend();
            tasks.add(player::sendTransaction);
            player.getSetbackTeleportUtil().hasAcceptedSpawnTeleport = false;
            player.getSetbackTeleportUtil().lastKnownGoodPosition = null;
            if (this.isWorldChange(player, respawn)) {
                player.compensatedEntities.serverPositionsMap.clear();
            }
            player.latencyUtils.addRealTimeTask(player.lastTransactionSent.get() + 1, () -> {
                if (player.getClientVersion().isOlderThan(ClientVersion.V_1_16) || player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_20)) {
                    player.isSneaking = false;
                }
                player.lastOnGround = false;
                player.clientClaimsLastOnGround = false;
                player.onGround = false;
                player.isInBed = false;
                player.packetStateData.setSlowedByUsingItem(false);
                player.packetStateData.packetPlayerOnGround = false;
                player.packetStateData.lastClaimedPosition = new Vector3d();
                player.filterMojangStupidityOnMojangStupidity = new Vector3d();
                boolean keepTrackedData = this.hasFlag(respawn, (byte)2);
                if (!keepTrackedData) {
                    player.powderSnowFrozenTicks = 0;
                    player.compensatedEntities.self.hasGravity = true;
                    player.playerEntityHasGravity = true;
                    player.packetStateData.knownInput = KnownInput.DEFAULT;
                    player.checkManager.getPostPredictionCheck(ElytraC.class).exempt = true;
                    if (player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_19_4)) {
                        player.isSprinting = false;
                    } else {
                        player.lastSprintingForSpeed = false;
                    }
                }
                player.checkManager.getPacketCheck(BadPacketsE.class).handleRespawn();
                player.checkManager.getPacketCheck(BadPacketsG.class).handleRespawn();
                if (player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_15)) {
                    player.checkManager.getPacketCheck(BadPacketsF.class).exemptNext = true;
                }
                if (this.isWorldChange(player, respawn)) {
                    player.compensatedEntities.entityMap.clear();
                    player.compensatedWorld.activePistons.clear();
                    player.compensatedWorld.openShulkerBoxes.clear();
                    player.compensatedWorld.chunks.clear();
                    player.compensatedWorld.isRaining = false;
                    player.checkManager.getBlockPlaceCheck(BadPacketsH.class).onWorldChange();
                }
                player.dimensionType = respawn.getDimensionType();
                player.worldName = respawn.getWorldName().orElse(null);
                player.compensatedEntities.serverPlayerVehicle = null;
                player.compensatedEntities.self = new PacketEntitySelf(player, player.compensatedEntities.self);
                player.compensatedEntities.selfTrackedEntity = new TrackerData(0.0, 0.0, 0.0, 0.0f, 0.0f, EntityTypes.PLAYER, player.lastTransactionSent.get());
                if (player.getClientVersion().isOlderThan(ClientVersion.V_1_14)) {
                    player.isSprinting = false;
                    player.checkManager.getPacketCheck(BadPacketsF.class).lastSprinting = false;
                    player.compensatedEntities.hasSprintingAttributeEnabled = false;
                }
                player.pose = Pose.STANDING;
                player.clientVelocity = new Vector3dm();
                if (!GrimAPI.INSTANCE.getSpectateManager().isSpectating(player.uuid)) {
                    player.gamemode = respawn.getGameMode();
                }
                if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_17)) {
                    player.compensatedWorld.setDimension(respawn.getDimensionType(), event.getUser());
                }
                if (player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_16) && !this.hasFlag(respawn, (byte)1)) {
                    player.compensatedEntities.self.resetAttributes();
                    player.compensatedEntities.hasSprintingAttributeEnabled = false;
                }
            });
        }
    }

    private boolean isWorldChange(GrimPlayer player, WrapperPlayServerRespawn respawn) {
        if (player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_16) && PacketEvents.getAPI().getServerManager().getVersion().isNewerThan(ServerVersion.V_1_16)) {
            return !Objects.equals(respawn.getWorldName().orElse(null), player.worldName);
        }
        ClientVersion version = PacketEvents.getAPI().getServerManager().getVersion().toClientVersion();
        return respawn.getDimensionType().getId(version) != player.dimensionType.getId(version) || !Objects.equals(respawn.getDimensionType().getName(), player.dimensionType.getName());
    }
}

