/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.api;

import ac.grim.grimac.api.GrimAbstractAPI;
import java.util.concurrent.CompletableFuture;

public final class GrimAPIProvider {
    private static GrimAbstractAPI instance;
    private static final CompletableFuture<GrimAbstractAPI> futureInstance;

    private GrimAPIProvider() {
    }

    public static void init(GrimAbstractAPI api) {
        if (instance != null || futureInstance.isDone()) {
            throw new IllegalStateException("GrimAPI is already initialized");
        }
        instance = api;
        futureInstance.complete(api);
    }

    public static GrimAbstractAPI get() {
        if (instance == null) {
            throw new IllegalStateException("GrimAPI is not loaded. Ensure the Grim mod is installed and initialized.");
        }
        return instance;
    }

    public static CompletableFuture<GrimAbstractAPI> getAsync() {
        if (instance != null) {
            return CompletableFuture.completedFuture(instance);
        }
        return futureInstance;
    }

    static {
        futureInstance = new CompletableFuture();
    }
}

