/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.impl.badpackets;

import ac.grim.grimac.checks.CheckData;
import ac.grim.grimac.checks.type.BlockPlaceCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.utils.anticheat.update.BlockBreak;
import ac.grim.grimac.utils.anticheat.update.BlockPlace;
import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientUseItem;

@CheckData(name="BadPacketsH", description="Sent unexpected sequence id", experimental=true)
public class BadPacketsH
extends BlockPlaceCheck {
    private int lastSequence;
    private final boolean isSupportedVersion;

    public BadPacketsH(GrimPlayer player) {
        super(player);
        this.isSupportedVersion = this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_19) && PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_19);
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.USE_ITEM && this.shouldCancel(new WrapperPlayClientUseItem(event).getSequence())) {
            event.setCancelled(true);
            this.player.onPacketCancel();
        }
    }

    @Override
    public void onBlockPlace(BlockPlace place) {
        if (this.shouldCancel(place.sequence) && this.shouldCancel()) {
            place.resync();
        }
    }

    @Override
    public void onBlockBreak(BlockBreak blockBreak) {
        switch (blockBreak.action) {
            case START_DIGGING: 
            case FINISHED_DIGGING: {
                if (!this.shouldCancel(blockBreak.sequence)) break;
                blockBreak.cancel();
                break;
            }
            case CANCELLED_DIGGING: {
                if (blockBreak.sequence == 0 || !this.flagAndAlert("expected=0, id=" + blockBreak.sequence) || !this.shouldModifyPackets()) break;
                blockBreak.cancel();
            }
        }
    }

    public boolean shouldCancel(int sequence) {
        if (this.isSupportedVersion && sequence != this.lastSequence + 1 && this.flagAndAlert("expected=" + (this.lastSequence + 1) + ", id=" + sequence) && this.shouldModifyPackets()) {
            this.lastSequence = sequence;
            return true;
        }
        this.lastSequence = sequence;
        return false;
    }

    public void onWorldChange() {
        this.lastSequence = 0;
    }
}

