/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.impl.packetorder;

import ac.grim.grimac.checks.CheckData;
import ac.grim.grimac.checks.type.BlockPlaceCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.utils.anticheat.update.BlockPlace;
import ac.grim.grimac.utils.anticheat.update.PredictionComplete;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.player.GameMode;
import com.github.retrooper.packetevents.protocol.world.BlockFace;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerBlockPlacement;

@CheckData(name="PacketOrderN", experimental=true)
public class PacketOrderN
extends BlockPlaceCheck {
    private int invalid;
    private boolean usingWithoutPlacing;
    private boolean placing;

    public PacketOrderN(GrimPlayer player) {
        super(player);
    }

    @Override
    public void onBlockPlace(BlockPlace place) {
        this.placing = true;
        if (this.usingWithoutPlacing) {
            if (!this.player.canSkipTicksPreVia()) {
                if (this.flagAndAlert() && this.shouldModifyPackets() && this.shouldCancel()) {
                    place.resync();
                }
            } else {
                ++this.invalid;
            }
        }
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.USE_ITEM || event.getPacketType() == PacketType.Play.Client.PLAYER_BLOCK_PLACEMENT && new WrapperPlayClientPlayerBlockPlacement(event).getFace() == BlockFace.OTHER) {
            if (!this.placing) {
                this.usingWithoutPlacing = true;
            }
            this.placing = false;
        }
        if (this.player.gamemode == GameMode.SPECTATOR || this.isTickPacket(event.getPacketType())) {
            this.placing = false;
            this.usingWithoutPlacing = false;
        }
    }

    @Override
    public void onPredictionComplete(PredictionComplete predictionComplete) {
        if (!this.player.canSkipTicksPreVia()) {
            return;
        }
        if (this.player.isTickingReliablyFor(3)) {
            while (this.invalid >= 1) {
                this.flagAndAlert();
                --this.invalid;
            }
        }
        this.invalid = 0;
    }
}

