/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.platform.api.scheduler;

import ac.grim.grimac.platform.api.scheduler.AsyncScheduler;
import ac.grim.grimac.platform.api.scheduler.EntityScheduler;
import ac.grim.grimac.platform.api.scheduler.GlobalRegionScheduler;
import ac.grim.grimac.platform.api.scheduler.RegionScheduler;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface PlatformScheduler {
    public static long convertTimeToTicks(long time, TimeUnit timeUnit) {
        return timeUnit.toMillis(time) / 50L;
    }

    public static long convertTicksToTime(long ticks, TimeUnit timeUnit) {
        long millis = ticks * 50L;
        return timeUnit.convert(millis, TimeUnit.MILLISECONDS);
    }

    public @NonNull AsyncScheduler getAsyncScheduler();

    public @NonNull GlobalRegionScheduler getGlobalRegionScheduler();

    public @NonNull EntityScheduler getEntityScheduler();

    public @NonNull RegionScheduler getRegionScheduler();
}

