/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.platform.api.sender;

import ac.grim.grimac.platform.api.sender.AbstractSender;
import ac.grim.grimac.platform.api.sender.Sender;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class SenderFactory<T> {
    protected abstract UUID getUniqueId(T var1);

    protected abstract String getName(T var1);

    protected abstract void sendMessage(T var1, String var2);

    protected abstract void sendMessage(T var1, Component var2);

    protected abstract boolean hasPermission(T var1, String var2);

    protected abstract boolean hasPermission(T var1, String var2, boolean var3);

    protected abstract void performCommand(T var1, String var2);

    protected abstract boolean isConsole(T var1);

    protected abstract boolean isPlayer(T var1);

    protected boolean shouldSplitNewlines(T sender) {
        return this.isConsole(sender);
    }

    public final @NonNull Sender wrap(@NonNull T sender) {
        Objects.requireNonNull(sender, "sender");
        return new AbstractSender<T>(this, sender);
    }

    public final @NonNull T unwrap(@NonNull Sender sender) {
        Objects.requireNonNull(sender, "sender");
        return (T)sender.getNativeSender();
    }
}

