/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.impl.packetorder;

import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.CheckData;
import ac.grim.grimac.checks.type.PacketCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketSendEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerBundle;
import ac.grim.grimac.shaded.fastutil.ints.IntArrayList;

@CheckData(name="PacketOrderP", experimental=true)
public class PacketOrderP
extends Check
implements PacketCheck {
    private byte trimTimer;
    private final IntArrayList transactions = new IntArrayList(0);

    public PacketOrderP(GrimPlayer player) {
        super(player);
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.CHUNK_BATCH_ACK) {
            if (!this.transactions.rem(this.player.getLastTransactionReceived())) {
                this.flagAndAlert("invalid response");
            }
        } else if (!PacketOrderP.isAsync(event.getPacketType()) && !PacketOrderP.isTransaction(event.getPacketType()) && this.transactions.rem(this.player.getLastTransactionReceived())) {
            this.flagAndAlert("skipped response, type=" + String.valueOf(event.getPacketType()));
        }
    }

    @Override
    public void onPacketSend(PacketSendEvent event) {
        if (event.getPacketType() == PacketType.Play.Server.CHUNK_BATCH_END) {
            boolean sendingBundlePacket = this.player.packetStateData.sendingBundlePacket;
            if (!sendingBundlePacket) {
                this.player.user.sendPacket(new WrapperPlayServerBundle());
            }
            this.player.sendTransaction();
            int transaction = this.player.getLastTransactionSent();
            this.transactions.add(transaction);
            this.trimTimer = (byte)(this.trimTimer + 1);
            if (this.trimTimer == 0) {
                this.transactions.trim();
            }
            this.player.addRealTimeTaskNext(() -> {
                if (this.transactions.rem(transaction)) {
                    this.flagAndAlert("skipped response, type=TRANSACTION");
                }
            });
            if (!sendingBundlePacket) {
                event.getTasksAfterSend().add(() -> this.player.user.sendPacket(new WrapperPlayServerBundle()));
            }
        }
    }
}

