/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.predictionengine.predictions.rideable;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.predictionengine.predictions.PredictionEngine;
import ac.grim.grimac.predictionengine.predictions.PredictionEngineNormal;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.attribute.Attributes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.potion.PotionTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3d;
import ac.grim.grimac.utils.data.VectorData;
import ac.grim.grimac.utils.data.packetentity.PacketEntity;
import ac.grim.grimac.utils.data.packetentity.PacketEntityCamel;
import ac.grim.grimac.utils.data.packetentity.PacketEntityHorse;
import ac.grim.grimac.utils.math.GrimMath;
import ac.grim.grimac.utils.math.Vector3dm;
import ac.grim.grimac.utils.nmsutil.BlockProperties;
import ac.grim.grimac.utils.nmsutil.JumpPower;
import ac.grim.grimac.utils.nmsutil.ReachUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import lombok.Generated;

public final class PredictionEngineRideableUtils {
    public static Set<VectorData> handleJumps(GrimPlayer player, Set<VectorData> possibleVectors) {
        PacketEntity packetEntity = player.compensatedEntities.self.getRiding();
        if (!(packetEntity instanceof PacketEntityHorse)) {
            return possibleVectors;
        }
        PacketEntityHorse horse = (PacketEntityHorse)packetEntity;
        if (horse instanceof PacketEntityCamel) {
            PacketEntityCamel camel = (PacketEntityCamel)horse;
            PredictionEngineRideableUtils.handleCamelDash(player, possibleVectors, camel);
        } else {
            PredictionEngineRideableUtils.handleHorseJumping(player, possibleVectors, horse);
        }
        if (player.lastOnGround) {
            player.vehicleData.horseJump = 0.0f;
            player.vehicleData.horseJumping = false;
        }
        return possibleVectors;
    }

    private static void handleCamelDash(GrimPlayer player, Set<VectorData> possibleVectors, PacketEntityCamel camel) {
        boolean wantsToJump;
        boolean bl = wantsToJump = player.vehicleData.horseJump > 0.0f && !player.vehicleData.horseJumping && player.lastOnGround;
        if (!wantsToJump) {
            return;
        }
        double jumpFactor = camel.getAttributeValue(Attributes.JUMP_STRENGTH) * (double)JumpPower.getPlayerJumpFactor(player);
        OptionalInt jumpBoost = player.compensatedEntities.getPotionLevelForPlayer(PotionTypes.JUMP_BOOST);
        double jumpYVelocity = jumpBoost.isPresent() ? jumpFactor + (double)((float)(jumpBoost.getAsInt() + 1) * 0.1f) : jumpFactor;
        double multiplier = (double)(22.2222f * player.vehicleData.horseJump) * camel.getAttributeValue(Attributes.MOVEMENT_SPEED) * (double)BlockProperties.getBlockSpeedFactor(player, player.mainSupportingBlockData, new Vector3d(player.lastX, player.lastY, player.lastZ));
        Vector3dm jumpVelocity = ReachUtils.getLook(player, player.yaw, player.pitch).multiply(1.0, 0.0, 1.0).normalize().multiply(multiplier).add(0.0, (double)(1.4285f * player.vehicleData.horseJump) * jumpYVelocity, 0.0);
        for (VectorData vectorData : possibleVectors) {
            vectorData.vector.add(jumpVelocity);
        }
        player.vehicleData.horseJumping = true;
        player.vehicleData.camelDashCooldown = 55;
    }

    private static void handleHorseJumping(GrimPlayer player, Set<VectorData> possibleVectors, PacketEntityHorse horse) {
        boolean wantsToJump;
        boolean bl = wantsToJump = player.vehicleData.horseJump > 0.0f && !player.vehicleData.horseJumping && player.lastOnGround;
        if (!wantsToJump) {
            return;
        }
        float forwardInput = player.vehicleData.vehicleForward;
        if (forwardInput <= 0.0f) {
            forwardInput *= 0.25f;
        }
        double jumpFactor = (float)horse.getAttributeValue(Attributes.JUMP_STRENGTH) * player.vehicleData.horseJump * JumpPower.getPlayerJumpFactor(player);
        OptionalInt jumpBoost = player.compensatedEntities.getPotionLevelForPlayer(PotionTypes.JUMP_BOOST);
        double jumpVelocity = jumpBoost.isPresent() ? jumpFactor + (double)((float)(jumpBoost.getAsInt() + 1) * 0.1f) : jumpFactor;
        player.vehicleData.horseJumping = true;
        float yawRadians = GrimMath.radians(player.yaw);
        float f2 = player.trigHandler.sin(yawRadians);
        float f3 = player.trigHandler.cos(yawRadians);
        for (VectorData vectorData : possibleVectors) {
            vectorData.vector.setY(jumpVelocity);
            if (!(forwardInput > 0.0f)) continue;
            vectorData.vector.add(new Vector3dm((double)(-0.4f * f2 * player.vehicleData.horseJump), 0.0, (double)(0.4f * f3 * player.vehicleData.horseJump)));
        }
        player.vehicleData.horseJump = 0.0f;
    }

    public static List<VectorData> applyInputsToVelocityPossibilities(Vector3dm movementVector, GrimPlayer player, Set<VectorData> possibleVectors, float speed) {
        return PredictionEngineRideableUtils.applyInputsToVelocityPossibilities(new PredictionEngine(), movementVector, player, possibleVectors, speed);
    }

    public static List<VectorData> applyInputsToVelocityPossibilities(PredictionEngine predictionEngine, Vector3dm movementVector, GrimPlayer player, Set<VectorData> possibleVectors, float speed) {
        ArrayList<VectorData> returnVectors = new ArrayList<VectorData>();
        for (VectorData possibleLastTickOutput : possibleVectors) {
            for (int applyStuckSpeed = 1; !(applyStuckSpeed < 0 || applyStuckSpeed == 0 && player.isForceStuckSpeed()); --applyStuckSpeed) {
                VectorData result = new VectorData(possibleLastTickOutput.vector.clone().add(predictionEngine.getMovementResultFromInput(player, movementVector, speed, player.yaw)), possibleLastTickOutput, VectorData.VectorType.InputResult);
                result.input = new Vector3dm(player.vehicleData.vehicleForward, 0.0f, player.vehicleData.vehicleHorizontal);
                Vector3dm vector = result.vector.clone();
                if (applyStuckSpeed != 0) {
                    vector.multiply(player.stuckSpeedMultiplier);
                }
                result = result.returnNewModified(vector, VectorData.VectorType.StuckMultiplier);
                result = result.returnNewModified(new PredictionEngineNormal().handleOnClimbable(result.vector.clone(), player), VectorData.VectorType.Climbable);
                returnVectors.add(result);
                result = new VectorData(possibleLastTickOutput.vector.clone(), possibleLastTickOutput, VectorData.VectorType.InputResult);
                result.input = new Vector3dm(player.vehicleData.vehicleForward, 0.0f, player.vehicleData.vehicleHorizontal);
                vector = result.vector.clone();
                if (applyStuckSpeed != 0) {
                    vector.multiply(player.stuckSpeedMultiplier);
                }
                result = result.returnNewModified(vector, VectorData.VectorType.StuckMultiplier);
                result = result.returnNewModified(new PredictionEngineNormal().handleOnClimbable(result.vector.clone(), player), VectorData.VectorType.Climbable);
                returnVectors.add(result);
            }
        }
        return returnVectors;
    }

    @Generated
    private PredictionEngineRideableUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

