/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.maps.weak;

import ac.grim.grimac.shaded.maps.Fluent;
import ac.grim.grimac.shaded.maps.weak.ConverterMaybe;
import ac.grim.grimac.shaded.maps.weak.ConverterTimeFormats;
import ac.grim.grimac.shaded.maps.weak.OptionalWeak;
import ac.grim.grimac.shaded.maps.weak.Weak;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class Converter {
    private static final String DEFAULT_MAP_KEY = "value";
    private static final Map<Class<?>, Function<Object, ? extends Converter>> typeConverters = Collections.unmodifiableMap(new Fluent.LinkedHashMap<Class<Integer>, Function<Object, Converter>>().append(Integer.class, IntConverter::new).append(Long.class, LongConverter::new).append(Double.class, DoubleConverter::new).append(BigDecimal.class, DecimalConverter::new).append(Weak.class, o -> Converter.convert(((Weak)o).asObject())).append(OptionalWeak.class, o -> new OptionalConverter(((OptionalWeak)o).asObject())).append(Map.class, MapConverter::new).append(Iterable.class, IterableConverter::new).append(Optional.class, OptionalConverter::new).append(Date.class, UtilDateInstantConverter::new).append(Object.class, Converter::new));
    protected final Object o;

    public static Converter convert(Object value) {
        Objects.requireNonNull(value);
        if (value instanceof Object[]) {
            return Converter.convert(Arrays.asList((Object[])value));
        }
        return typeConverters.getOrDefault(value.getClass(), typeConverters.entrySet().stream().filter(entry -> !((Class)entry.getKey()).equals(Date.class) && ((Class)entry.getKey()).isInstance(value)).findFirst().map(Map.Entry::getValue).get()).apply(value);
    }

    private static boolean doesNotThrow(Supplier<?> method) {
        try {
            method.get();
            return true;
        }
        catch (RuntimeException ex) {
            return false;
        }
    }

    Converter(Object o) {
        this.o = o;
    }

    public String intoString() {
        return this.o instanceof String ? (String)this.o : this.o.toString();
    }

    public boolean intoStringWorks() {
        return Converter.doesNotThrow(this::intoString);
    }

    public int intoInteger() {
        return this.intoDecimal().setScale(0, RoundingMode.HALF_UP).intValueExact();
    }

    public boolean intoIntegerWorks() {
        return Converter.doesNotThrow(this::intoInteger);
    }

    public long intoLong() {
        return this.intoDecimal().setScale(0, RoundingMode.HALF_UP).longValueExact();
    }

    public boolean intoLongWorks() {
        return Converter.doesNotThrow(this::intoLong);
    }

    public double intoDouble() {
        return this.intoDecimal().doubleValue();
    }

    public boolean intoDoubleWorks() {
        return Converter.doesNotThrow(this::intoDouble);
    }

    public BigDecimal intoDecimal() {
        return new BigDecimal(this.intoString());
    }

    public boolean intoDecimalWorks() {
        return Converter.doesNotThrow(this::intoDecimal);
    }

    public Map intoMap() {
        return new Fluent.HashMap<String, Object>().append(DEFAULT_MAP_KEY, this.o);
    }

    public boolean intoMapWorks() {
        return Converter.doesNotThrow(this::intoMap);
    }

    public List intoList() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.o);
        return list;
    }

    public boolean intoListWorks() {
        return Converter.doesNotThrow(this::intoList);
    }

    public LocalDateTime intoLocalDateTime() {
        return LocalDateTime.from(ConverterTimeFormats.parseWithDefaults(this.intoString()));
    }

    public boolean intoLocalDateTimeWorks() {
        return Converter.doesNotThrow(this::intoLocalDateTime);
    }

    public ZonedDateTime intoZonedDateTime() {
        return ZonedDateTime.from(ConverterTimeFormats.parseWithDefaults(this.intoString()));
    }

    public boolean intoZonedDateTimeWorks() {
        return Converter.doesNotThrow(this::intoZonedDateTime);
    }

    public ZonedDateTime intoZonedDateTimeOrUse(ZoneId fallback) {
        try {
            return this.intoZonedDateTime();
        }
        catch (RuntimeException ex) {
            return this.intoLocalDateTime().atZone(fallback);
        }
    }

    public ConverterMaybe maybe() {
        return new ConverterMaybe(this.o);
    }

    static class UtilDateInstantConverter
    extends TypeConverter<Date> {
        UtilDateInstantConverter(Object o) {
            super(o);
        }

        @Override
        public BigDecimal intoDecimal() {
            return new BigDecimal(this.intoLong());
        }

        @Override
        public double intoDouble() {
            return this.intoLong();
        }

        @Override
        public long intoLong() {
            return ((Date)this.literal()).getTime();
        }

        @Override
        public String intoString() {
            return String.valueOf(((Date)this.literal()).getTime());
        }
    }

    static class OptionalConverter
    extends TypeConverter<Optional<?>> {
        OptionalConverter(Object o) {
            super(o);
        }

        @Override
        public String intoString() {
            return ((Optional)this.literal()).map(o -> OptionalConverter.convert(o).intoString()).orElseGet(() -> super.intoString());
        }

        @Override
        public int intoInteger() {
            return ((Optional)this.literal()).map(o -> OptionalConverter.convert(o).intoInteger()).orElseGet(() -> super.intoInteger());
        }

        @Override
        public long intoLong() {
            return ((Optional)this.literal()).map(o -> OptionalConverter.convert(o).intoLong()).orElseGet(() -> super.intoLong());
        }

        @Override
        public double intoDouble() {
            return ((Optional)this.literal()).map(o -> OptionalConverter.convert(o).intoDouble()).orElseGet(() -> super.intoDouble());
        }

        @Override
        public BigDecimal intoDecimal() {
            return ((Optional)this.literal()).map(o -> OptionalConverter.convert(o).intoDecimal()).orElseGet(() -> super.intoDecimal());
        }

        @Override
        public Map intoMap() {
            return ((Optional)this.literal()).map(o -> OptionalConverter.convert(o).intoMap()).orElseGet(LinkedHashMap::new);
        }

        @Override
        public List intoList() {
            return ((Optional)this.literal()).map(o -> OptionalConverter.convert(o).intoList()).orElseGet(ArrayList::new);
        }
    }

    static class IterableConverter
    extends TypeConverter<Iterable<?>> {
        IterableConverter(Object o) {
            super(o);
        }

        private Optional<Object> onlyElement() {
            Iterator iterator = ((Iterable)this.literal()).iterator();
            return Optional.ofNullable(iterator.hasNext() ? (Object)iterator.next() : null).filter(o -> !iterator.hasNext());
        }

        @Override
        public String intoString() {
            return this.onlyElement().map(o -> IterableConverter.convert(o).intoString()).orElseGet(() -> super.intoString());
        }

        @Override
        public int intoInteger() {
            return this.onlyElement().map(o -> IterableConverter.convert(o).intoInteger()).orElseGet(() -> super.intoInteger());
        }

        @Override
        public long intoLong() {
            return this.onlyElement().map(o -> IterableConverter.convert(o).intoLong()).orElseGet(() -> super.intoLong());
        }

        @Override
        public double intoDouble() {
            return this.onlyElement().map(o -> IterableConverter.convert(o).intoDouble()).orElseGet(() -> super.intoDouble());
        }

        @Override
        public BigDecimal intoDecimal() {
            return this.onlyElement().map(o -> IterableConverter.convert(o).intoDecimal()).orElseGet(() -> super.intoDecimal());
        }

        @Override
        public Map intoMap() {
            LinkedHashMap map = new LinkedHashMap();
            Iterator iterator = ((Iterable)this.literal()).iterator();
            int i = 0;
            while (iterator.hasNext()) {
                map.put(i, iterator.next());
                ++i;
            }
            return map;
        }

        @Override
        public List intoList() {
            return StreamSupport.stream(((Iterable)this.literal()).spliterator(), false).collect(Collectors.toCollection(ArrayList::new));
        }
    }

    static class MapConverter
    extends TypeConverter<Map<?, ?>> {
        MapConverter(Object o) {
            super(o);
        }

        private Optional<Object> value() {
            return Optional.ofNullable(((Map)this.literal()).get(Converter.DEFAULT_MAP_KEY));
        }

        @Override
        public String intoString() {
            return this.value().map(o -> MapConverter.convert(o).intoString()).orElseGet(() -> super.intoString());
        }

        @Override
        public int intoInteger() {
            return this.value().map(o -> MapConverter.convert(o).intoInteger()).orElseGet(() -> super.intoInteger());
        }

        @Override
        public long intoLong() {
            return this.value().map(o -> MapConverter.convert(o).intoLong()).orElseGet(() -> super.intoLong());
        }

        @Override
        public double intoDouble() {
            return this.value().map(o -> MapConverter.convert(o).intoDouble()).orElseGet(() -> super.intoDouble());
        }

        @Override
        public BigDecimal intoDecimal() {
            return this.value().map(o -> MapConverter.convert(o).intoDecimal()).orElseGet(() -> super.intoDecimal());
        }

        @Override
        public Map intoMap() {
            return new LinkedHashMap((Map)this.literal());
        }

        @Override
        public List intoList() {
            return new ArrayList(((Map)this.literal()).values());
        }
    }

    static class DecimalConverter
    extends TypeConverter<BigDecimal> {
        DecimalConverter(Object o) {
            super(o);
        }

        @Override
        public BigDecimal intoDecimal() {
            return (BigDecimal)this.literal();
        }
    }

    static class DoubleConverter
    extends TypeConverter<Double> {
        DoubleConverter(Object o) {
            super(o);
        }

        @Override
        public double intoDouble() {
            return (Double)this.literal();
        }

        @Override
        public BigDecimal intoDecimal() {
            return new BigDecimal((Double)this.literal());
        }
    }

    static class LongConverter
    extends TypeConverter<Long> {
        LongConverter(Object o) {
            super(o);
        }

        @Override
        public int intoInteger() {
            if ((Long)this.literal() < Integer.MIN_VALUE || (Long)this.literal() > Integer.MAX_VALUE) {
                throw new IllegalArgumentException(this.literal() + " too large/small to be cast to int");
            }
            return ((Long)this.literal()).intValue();
        }

        @Override
        public long intoLong() {
            return (Long)this.literal();
        }

        @Override
        public double intoDouble() {
            return ((Long)this.literal()).longValue();
        }

        @Override
        public BigDecimal intoDecimal() {
            return new BigDecimal((Long)this.literal());
        }
    }

    static class IntConverter
    extends TypeConverter<Integer> {
        IntConverter(Object o) {
            super(o);
        }

        @Override
        public int intoInteger() {
            return (Integer)this.literal();
        }

        @Override
        public long intoLong() {
            return ((Integer)this.literal()).intValue();
        }

        @Override
        public double intoDouble() {
            return ((Integer)this.literal()).intValue();
        }

        @Override
        public BigDecimal intoDecimal() {
            return new BigDecimal((Integer)this.literal());
        }
    }

    static abstract class TypeConverter<T>
    extends Converter {
        TypeConverter(Object o) {
            super(o);
        }

        protected T literal() {
            return (T)this.o;
        }
    }
}

