/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.zaxxer.hikari.util;

import ac.grim.grimac.shaded.slf4j.Logger;
import ac.grim.grimac.shaded.slf4j.LoggerFactory;
import ac.grim.grimac.shaded.zaxxer.hikari.HikariConfig;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PropertyElf {
    private static final char ESCAPE_CHAR = '\\';
    private static final char SEPARATOR_CHAR = ',';
    private static final Pattern DURATION_PATTERN = Pattern.compile("^(?<number>\\d+)(?<unit>ms|s|m|h|d)$");

    private PropertyElf() {
    }

    public static void setTargetFromProperties(Object target, Properties properties) {
        if (target == null || properties == null) {
            return;
        }
        List<Method> methods = Arrays.asList(target.getClass().getMethods());
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String keyName = key.toString();
            if (target instanceof HikariConfig && keyName.startsWith("dataSource.")) {
                ((HikariConfig)target).addDataSourceProperty(keyName.substring("dataSource.".length()), value);
            } else {
                PropertyElf.setProperty(target, keyName, value, methods);
            }
        }));
    }

    public static Set<String> getPropertyNames(Class<?> targetClass) {
        HashSet<String> set = new HashSet<String>();
        for (Method method : targetClass.getMethods()) {
            String name = PropertyElf.propertyNameFromGetterName(method.getName());
            try {
                if (method.getParameterTypes().length != 0 || name == null) continue;
                targetClass.getMethod("set" + PropertyElf.capitalizedPropertyName(name), method.getReturnType());
                set.add(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return set;
    }

    public static Object getProperty(String propName, Object target) {
        try {
            String capitalized = "get" + PropertyElf.capitalizedPropertyName(propName);
            Method method = target.getClass().getMethod(capitalized, new Class[0]);
            return method.invoke(target, new Object[0]);
        }
        catch (Exception e) {
            try {
                String capitalized = "is" + PropertyElf.capitalizedPropertyName(propName);
                Method method = target.getClass().getMethod(capitalized, new Class[0]);
                return method.invoke(target, new Object[0]);
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public static Properties copyProperties(Properties props) {
        Properties copy = new Properties();
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> copy.setProperty(key.toString(), value.toString())));
        return copy;
    }

    private static String propertyNameFromGetterName(String methodName) {
        String name = null;
        if (methodName.startsWith("get") && methodName.length() > 3) {
            name = methodName.substring(3);
        } else if (methodName.startsWith("is") && methodName.length() > 2) {
            name = methodName.substring(2);
        }
        if (name != null) {
            return Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }
        return null;
    }

    private static void setProperty(Object target, String propName, Object propValue, List<Method> methods) {
        Logger logger = LoggerFactory.getLogger(PropertyElf.class);
        String methodName = "set" + propName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propName.substring(1);
        Method writeMethod = methods.stream().filter(m -> m.getName().equals(methodName) && m.getParameterCount() == 1).findFirst().orElse(null);
        if (writeMethod == null) {
            String methodName2 = "set" + propName.toUpperCase(Locale.ENGLISH);
            writeMethod = methods.stream().filter(m -> m.getName().equals(methodName2) && m.getParameterCount() == 1).findFirst().orElse(null);
        }
        if (writeMethod == null) {
            logger.error("Property {} does not exist on target {}", (Object)propName, (Object)target.getClass());
            throw new RuntimeException(String.format("Property %s does not exist on target %s", propName, target.getClass()));
        }
        try {
            Class<?> paramClass = writeMethod.getParameterTypes()[0];
            String value = propValue.toString();
            if (paramClass == Integer.TYPE) {
                writeMethod.invoke(target, Integer.parseInt(propValue.toString()));
            } else if (paramClass == Long.TYPE) {
                writeMethod.invoke(target, PropertyElf.parseDuration(value).map(Duration::toMillis).orElseGet(() -> Long.parseLong(value)));
            } else if (paramClass == Short.TYPE) {
                writeMethod.invoke(target, Short.parseShort(value));
            } else if (paramClass == Boolean.TYPE || paramClass == Boolean.class) {
                writeMethod.invoke(target, Boolean.parseBoolean(value));
            } else if (paramClass.isArray() && Character.TYPE.isAssignableFrom(paramClass.getComponentType())) {
                writeMethod.invoke(target, new Object[]{value.toCharArray()});
            } else if (paramClass.isArray() && Integer.TYPE.isAssignableFrom(paramClass.getComponentType())) {
                writeMethod.invoke(target, new Object[]{PropertyElf.parseIntArray(value)});
            } else if (paramClass.isArray() && String.class.isAssignableFrom(paramClass.getComponentType())) {
                writeMethod.invoke(target, new Object[]{PropertyElf.parseStringArray(value)});
            } else if (paramClass == String.class) {
                writeMethod.invoke(target, value);
            } else {
                try {
                    logger.debug("Try to create a new instance of \"{}\"", propValue);
                    writeMethod.invoke(target, Class.forName(propValue.toString()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (ClassNotFoundException | InstantiationException e) {
                    logger.debug("Class \"{}\" not found or could not instantiate it (Default constructor)", propValue);
                    writeMethod.invoke(target, propValue);
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to set property {} on target {}", propName, target.getClass(), e);
            throw new RuntimeException(e);
        }
    }

    private static String capitalizedPropertyName(String propertyName) {
        return propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
    }

    private static int[] parseIntArray(String value) {
        if (value == null || value.isEmpty()) {
            return new int[0];
        }
        String[] split = value.split(",");
        int[] intArray = new int[split.length];
        for (int i = 0; i < split.length; ++i) {
            intArray[i] = Integer.parseInt(split[i]);
        }
        return intArray;
    }

    private static String[] parseStringArray(String value) {
        if (value == null || value.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> resultList = new ArrayList<String>();
        boolean inEscape = false;
        StringBuilder currentField = new StringBuilder();
        for (char c : value.toCharArray()) {
            if (inEscape) {
                currentField.append(c);
                inEscape = false;
                continue;
            }
            if (c == '\\') {
                inEscape = true;
                continue;
            }
            if (c == ',') {
                resultList.add(currentField.toString());
                currentField.setLength(0);
                continue;
            }
            currentField.append(c);
        }
        if (inEscape) {
            throw new IllegalArgumentException(String.format("Unterminated escape sequence in property value: %s", value));
        }
        resultList.add(currentField.toString());
        return resultList.toArray(new String[0]);
    }

    private static Optional<Duration> parseDuration(String value) {
        Matcher matcher = DURATION_PATTERN.matcher(value);
        if (matcher.matches()) {
            String unit;
            long number = Long.parseLong(matcher.group("number"));
            switch (unit = matcher.group("unit")) {
                case "ms": {
                    return Optional.of(Duration.ofMillis(number));
                }
                case "s": {
                    return Optional.of(Duration.ofSeconds(number));
                }
                case "m": {
                    return Optional.of(Duration.ofMinutes(number));
                }
                case "h": {
                    return Optional.of(Duration.ofHours(number));
                }
                case "d": {
                    return Optional.of(Duration.ofDays(number));
                }
            }
            throw new IllegalStateException(String.format("Could not match unit, got %s (from given value %s)", unit, value));
        }
        return Optional.empty();
    }
}

