/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.platform.fabric.utils.metrics;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.api.plugin.GrimPlugin;
import ac.grim.grimac.platform.fabric.GrimACFabricLoaderPlugin;
import ac.grim.grimac.platform.fabric.utils.metrics.BStatsConfig;
import ac.grim.grimac.platform.fabric.utils.metrics.CustomChart;
import ac.grim.grimac.platform.fabric.utils.metrics.JsonObjectBuilder;
import ac.grim.grimac.platform.fabric.utils.metrics.Metrics;
import ac.grim.grimac.platform.fabric.utils.metrics.MetricsBase;
import java.util.logging.Level;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public class MetricsFabric
implements Metrics {
    private final MetricsBase metricsBase;

    public MetricsFabric(GrimPlugin plugin, int serviceId) {
        BStatsConfig.Config config = BStatsConfig.loadConfig();
        boolean enabled = config.enabled;
        String serverUUID = config.serverUuid;
        boolean logErrors = config.logFailedRequests;
        boolean logSentData = config.logSentData;
        boolean logResponseStatusText = config.logResponseStatusText;
        this.metricsBase = new MetricsBase("fabric", serverUUID, serviceId, enabled, this::appendPlatformData, this::appendServiceData, submitDataTask -> GrimAPI.INSTANCE.getScheduler().getAsyncScheduler().runNow(plugin, submitDataTask), () -> true, (message, error) -> plugin.getLogger().log(Level.WARNING, (String)message, (Throwable)error), message -> plugin.getLogger().log(Level.INFO, (String)message), logErrors, logSentData, logResponseStatusText, false);
    }

    @Override
    public void shutdown() {
        this.metricsBase.shutdown();
    }

    public void addCustomChart(CustomChart chart) {
        this.metricsBase.addCustomChart(chart);
    }

    private void appendPlatformData(JsonObjectBuilder builder) {
        builder.appendField("playerAmount", this.getPlayerAmount());
        builder.appendField("onlineMode", GrimACFabricLoaderPlugin.FABRIC_SERVER.method_3828() ? 0 : 1);
        builder.appendField("bukkitVersion", GrimAPI.INSTANCE.getPlatformServer().getPlatformImplementationString());
        builder.appendField("bukkitName", "Fabric");
        builder.appendField("javaVersion", System.getProperty("java.version"));
        builder.appendField("osName", System.getProperty("os.name"));
        builder.appendField("osArch", System.getProperty("os.arch"));
        builder.appendField("osVersion", System.getProperty("os.version"));
        builder.appendField("coreCount", Runtime.getRuntime().availableProcessors());
    }

    private void appendServiceData(JsonObjectBuilder builder) {
        builder.appendField("pluginVersion", ((ModContainer)FabricLoader.getInstance().getModContainer("grimac").get()).getMetadata().getVersion().getFriendlyString());
    }

    private int getPlayerAmount() {
        if (GrimACFabricLoaderPlugin.FABRIC_SERVER.method_3806()) {
            return GrimACFabricLoaderPlugin.FABRIC_SERVER.method_3788();
        }
        return 0;
    }
}

