/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.platform.fabric.utils.message;

import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class Slf4jBackedJULogger
extends java.util.logging.Logger {
    private final Logger slf4jLogger;
    private static final Marker MARKER = MarkerFactory.getMarker((String)"JUL");

    public Slf4jBackedJULogger(String name) {
        super(name, null);
        this.slf4jLogger = LoggerFactory.getLogger((String)name);
    }

    @Override
    public void log(Level level, String msg) {
        if (level == Level.SEVERE) {
            this.slf4jLogger.error(MARKER, msg);
        } else if (level == Level.WARNING) {
            this.slf4jLogger.warn(MARKER, msg);
        } else if (level == Level.INFO) {
            this.slf4jLogger.info(MARKER, msg);
        } else if (level == Level.CONFIG || level == Level.FINE) {
            this.slf4jLogger.debug(MARKER, msg);
        } else if (level == Level.FINER || level == Level.FINEST) {
            this.slf4jLogger.trace(MARKER, msg);
        } else {
            this.slf4jLogger.info(MARKER, msg);
        }
    }

    @Override
    public void log(Level level, String msg, Throwable thrown) {
        if (level.equals(Level.SEVERE)) {
            this.slf4jLogger.error(MARKER, msg, thrown);
        } else if (level.equals(Level.WARNING)) {
            this.slf4jLogger.warn(MARKER, msg, thrown);
        } else if (level.equals(Level.INFO)) {
            this.slf4jLogger.info(MARKER, msg, thrown);
        } else if (level.equals(Level.CONFIG) || level.equals(Level.FINE)) {
            this.slf4jLogger.debug(MARKER, msg, thrown);
        } else if (level.equals(Level.FINER) || level.equals(Level.FINEST)) {
            this.slf4jLogger.trace(MARKER, msg, thrown);
        } else {
            this.slf4jLogger.info(MARKER, msg, thrown);
        }
    }
}

