/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.platform.fabric.resolver;

import ac.grim.grimac.api.plugin.BasicGrimPlugin;
import ac.grim.grimac.api.plugin.GrimPlugin;
import ac.grim.grimac.events.GrimExtensionManager;
import ac.grim.grimac.platform.fabric.utils.message.JULoggerFactory;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;

public final class FabricResolverRegistrar {
    private final GrimExtensionManager extensionManager;
    private final Map<ModContainer, GrimPlugin> modContainerCache = new ConcurrentHashMap<ModContainer, GrimPlugin>();
    private final Map<Class<?>, GrimPlugin> classCache = new ConcurrentHashMap();
    private final Map<Object, GrimPlugin> entrypointCache = new ConcurrentHashMap<Object, GrimPlugin>();

    public void registerAll() {
        this.extensionManager.setFailureHandler(this::createFailureException);
        this.extensionManager.registerResolver(this::resolveModContainer);
        this.extensionManager.registerResolver(this::resolveStringId);
        this.extensionManager.registerResolver(this::resolveEntrypointInstance);
        this.extensionManager.registerResolver(this::resolveClass);
    }

    private GrimPlugin resolveMod(ModContainer modContainer) {
        return this.modContainerCache.computeIfAbsent(modContainer, container -> {
            ModMetadata metadata = container.getMetadata();
            String folderName = metadata.getId().equals("grimac") ? metadata.getName() : metadata.getId();
            return new BasicGrimPlugin(JULoggerFactory.createLogger(metadata.getName()), new File(FabricLoader.getInstance().getConfigDir().toFile(), folderName), metadata.getVersion().getFriendlyString(), metadata.getDescription(), (Collection)metadata.getAuthors().stream().map(Person::getName).collect(Collectors.toList()));
        });
    }

    private GrimPlugin resolveModContainer(Object context) {
        GrimPlugin grimPlugin;
        if (context instanceof ModContainer) {
            ModContainer mc = (ModContainer)context;
            grimPlugin = this.resolveMod(mc);
        } else {
            grimPlugin = null;
        }
        return grimPlugin;
    }

    private GrimPlugin resolveStringId(Object context) {
        if (context instanceof String) {
            String modId = (String)context;
            return FabricLoader.getInstance().getModContainer(modId.toLowerCase(Locale.ROOT)).map(this::resolveMod).orElse(null);
        }
        return null;
    }

    private GrimPlugin resolveEntrypointInstance(Object context) {
        if (context instanceof ModInitializer || context instanceof PreLaunchEntrypoint || context instanceof ClientModInitializer || context instanceof DedicatedServerModInitializer) {
            return this.entrypointCache.computeIfAbsent(context, this::findEntrypoint);
        }
        return null;
    }

    private GrimPlugin findEntrypoint(Object key) {
        GrimPlugin result = this.findEntrypoint(key, ModInitializer.class, "main");
        if (result != null) {
            return result;
        }
        result = this.findEntrypoint(key, PreLaunchEntrypoint.class, "preLaunch");
        if (result != null) {
            return result;
        }
        result = this.findEntrypoint(key, ClientModInitializer.class, "client");
        if (result != null) {
            return result;
        }
        result = this.findEntrypoint(key, DedicatedServerModInitializer.class, "server");
        if (result != null) {
            return result;
        }
        return null;
    }

    private <T> GrimPlugin findEntrypoint(Object context, Class<T> entrypointClass, String entrypointKey) {
        if (entrypointClass.isInstance(context)) {
            for (EntrypointContainer container : FabricLoader.getInstance().getEntrypointContainers(entrypointKey, entrypointClass)) {
                if (container.getEntrypoint() != context) continue;
                return this.resolveMod(container.getProvider());
            }
        }
        return null;
    }

    private GrimPlugin resolveClass(Object context) {
        if (context instanceof Class) {
            Class clazz = (Class)context;
            return this.classCache.computeIfAbsent(clazz, this::findClassProvider);
        }
        return null;
    }

    private GrimPlugin findClassProvider(Class<?> c) {
        try {
            CodeSource codeSource = c.getProtectionDomain().getCodeSource();
            if (codeSource == null) {
                return null;
            }
            URL sourceUrl = codeSource.getLocation();
            if (sourceUrl == null) {
                return null;
            }
            Path sourcePath = Paths.get(sourceUrl.toURI());
            for (ModContainer modContainer : FabricLoader.getInstance().getAllMods()) {
                for (Path modRootPath : modContainer.getRootPaths()) {
                    String schemeSpecificPart;
                    int separatorIndex;
                    URI modUri = modRootPath.toUri();
                    Path modPhysicalPath = null;
                    if ("file".equals(modUri.getScheme())) {
                        modPhysicalPath = modRootPath;
                    } else if ("jar".equals(modUri.getScheme()) && (separatorIndex = (schemeSpecificPart = modUri.getSchemeSpecificPart()).indexOf("!/")) != -1) {
                        String jarUriString = schemeSpecificPart.substring(0, separatorIndex);
                        modPhysicalPath = Paths.get(new URI(jarUriString));
                    }
                    if (modPhysicalPath == null || !Files.isSameFile(modPhysicalPath, sourcePath)) continue;
                    return this.resolveMod(modContainer);
                }
            }
        }
        catch (IOException | NullPointerException | URISyntaxException e) {
            return null;
        }
        return null;
    }

    private RuntimeException createFailureException(Object failedContext) {
        String message = "Failed to resolve GrimPlugin context from the provided object of type '%s'.\n\nPlease ensure you are passing one of the following:\n  - The main instance of your mod (e.g., 'this' from your ModInitializer class).\n  - The mod ID as a String (e.g., \"my-mod-id\").\n  - Any Class from your mod's JAR file (e.g., MyListener.class).\n  - A pre-existing GrimPlugin instance.\n".formatted(failedContext.getClass().getName());
        return new IllegalArgumentException(message);
    }

    @Generated
    public FabricResolverRegistrar(GrimExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }
}

