/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac;

import ac.grim.grimac.GrimExternalAPI;
import ac.grim.grimac.api.event.EventBus;
import ac.grim.grimac.api.event.OptimizedEventBus;
import ac.grim.grimac.api.plugin.GrimPlugin;
import ac.grim.grimac.manager.AlertManagerImpl;
import ac.grim.grimac.manager.DiscordManager;
import ac.grim.grimac.manager.InitManager;
import ac.grim.grimac.manager.SpectateManager;
import ac.grim.grimac.manager.TickManager;
import ac.grim.grimac.manager.config.BaseConfigManager;
import ac.grim.grimac.manager.init.Initable;
import ac.grim.grimac.manager.violationdatabase.ViolationDatabaseManager;
import ac.grim.grimac.platform.api.Platform;
import ac.grim.grimac.platform.api.PlatformLoader;
import ac.grim.grimac.platform.api.PlatformServer;
import ac.grim.grimac.platform.api.manager.CommandAdapter;
import ac.grim.grimac.platform.api.manager.ItemResetHandler;
import ac.grim.grimac.platform.api.manager.MessagePlaceHolderManager;
import ac.grim.grimac.platform.api.manager.PermissionRegistrationManager;
import ac.grim.grimac.platform.api.manager.PlatformPluginManager;
import ac.grim.grimac.platform.api.player.PlatformPlayerFactory;
import ac.grim.grimac.platform.api.scheduler.PlatformScheduler;
import ac.grim.grimac.platform.api.sender.Sender;
import ac.grim.grimac.platform.api.sender.SenderFactory;
import ac.grim.grimac.shaded.incendo.cloud.CommandManager;
import ac.grim.grimac.shaded.jetbrains.annotations.NotNull;
import ac.grim.grimac.utils.anticheat.PlayerDataManager;
import ac.grim.grimac.utils.reflection.ReflectionUtils;

public final class GrimAPI {
    public static final GrimAPI INSTANCE = new GrimAPI();
    private final Platform platform = GrimAPI.detectPlatform();
    private final BaseConfigManager configManager = new BaseConfigManager();
    private final AlertManagerImpl alertManager = new AlertManagerImpl();
    private final SpectateManager spectateManager = new SpectateManager();
    private final DiscordManager discordManager = new DiscordManager();
    private final PlayerDataManager playerDataManager = new PlayerDataManager();
    private final TickManager tickManager = new TickManager();
    private final EventBus eventBus = new OptimizedEventBus();
    private final GrimExternalAPI externalAPI = new GrimExternalAPI(this);
    private ViolationDatabaseManager violationDatabaseManager;
    private PlatformLoader loader;
    private InitManager initManager;
    private boolean initialized = false;

    private GrimAPI() {
    }

    private static Platform detectPlatform() {
        if (ReflectionUtils.hasClass("io.papermc.paper.threadedregions.RegionizedServer")) {
            return Platform.FOLIA;
        }
        if (ReflectionUtils.hasClass("org.bukkit.Bukkit")) {
            return Platform.BUKKIT;
        }
        if (ReflectionUtils.hasClass("net.fabricmc.loader.api.FabricLoader")) {
            return Platform.FABRIC;
        }
        throw new IllegalStateException("Unknown platform!");
    }

    public void load(PlatformLoader platformLoader, Initable ... platformSpecificInitables) {
        this.loader = platformLoader;
        this.violationDatabaseManager = new ViolationDatabaseManager(this.getGrimPlugin());
        this.initManager = new InitManager(this.loader.getPacketEvents(), this.loader::getCommandManager, platformSpecificInitables);
        this.initManager.load();
        this.initialized = true;
    }

    public void start() {
        this.checkInitialized();
        this.initManager.start();
    }

    public void stop() {
        this.checkInitialized();
        this.initManager.stop();
    }

    public PlatformScheduler getScheduler() {
        return this.loader.getScheduler();
    }

    public PlatformPlayerFactory getPlatformPlayerFactory() {
        return this.loader.getPlatformPlayerFactory();
    }

    public CommandAdapter getCommandAdapter() {
        return this.loader.getCommandAdapter();
    }

    public GrimPlugin getGrimPlugin() {
        return this.loader.getPlugin();
    }

    public SenderFactory<?> getSenderFactory() {
        return this.loader.getSenderFactory();
    }

    public ItemResetHandler getItemResetHandler() {
        return this.loader.getItemResetHandler();
    }

    public PlatformPluginManager getPluginManager() {
        return this.loader.getPluginManager();
    }

    public PlatformServer getPlatformServer() {
        return this.loader.getPlatformServer();
    }

    @NotNull
    public MessagePlaceHolderManager getMessagePlaceHolderManager() {
        return this.loader.getMessagePlaceHolderManager();
    }

    public CommandManager<Sender> getCommandManager() {
        return this.loader.getCommandManager();
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("GrimAPI has not been initialized!");
        }
    }

    public PermissionRegistrationManager getPermissionManager() {
        return this.loader.getPermissionManager();
    }

    public BaseConfigManager getConfigManager() {
        return this.configManager;
    }

    public AlertManagerImpl getAlertManager() {
        return this.alertManager;
    }

    public SpectateManager getSpectateManager() {
        return this.spectateManager;
    }

    public DiscordManager getDiscordManager() {
        return this.discordManager;
    }

    public PlayerDataManager getPlayerDataManager() {
        return this.playerDataManager;
    }

    public TickManager getTickManager() {
        return this.tickManager;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public GrimExternalAPI getExternalAPI() {
        return this.externalAPI;
    }

    public ViolationDatabaseManager getViolationDatabaseManager() {
        return this.violationDatabaseManager;
    }

    public PlatformLoader getLoader() {
        return this.loader;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public InitManager getInitManager() {
        return this.initManager;
    }
}

