/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.impl.elytra;

import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.CheckData;
import ac.grim.grimac.checks.type.PostPredictionCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.utils.anticheat.update.PredictionComplete;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientEntityAction;

@CheckData(name="ElytraE", description="Started gliding while flying", experimental=true)
public class ElytraE
extends Check
implements PostPredictionCheck {
    private boolean setback;

    public ElytraE(GrimPlayer player) {
        super(player);
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        if (this.player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_8)) {
            return;
        }
        if (event.getPacketType() == PacketType.Play.Client.ENTITY_ACTION && new WrapperPlayClientEntityAction(event).getAction() == WrapperPlayClientEntityAction.Action.START_FLYING_WITH_ELYTRA && this.player.isFlying && this.flagAndAlert()) {
            this.setback = true;
            if (this.shouldModifyPackets()) {
                event.setCancelled(true);
                this.player.onPacketCancel();
                this.player.resyncPose();
            }
        }
    }

    @Override
    public void onPredictionComplete(PredictionComplete predictionComplete) {
        if (this.setback) {
            this.setbackIfAboveSetbackVL();
            this.setback = false;
        }
    }
}

