/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.impl.exploit;

import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.CheckData;
import ac.grim.grimac.checks.type.PacketCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.jetbrains.annotations.NotNull;
import ac.grim.grimac.utils.payload.PayloadBookEdit;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.component.ComponentTypes;
import com.github.retrooper.packetevents.protocol.item.ItemStack;
import com.github.retrooper.packetevents.protocol.item.type.ItemType;
import com.github.retrooper.packetevents.protocol.item.type.ItemTypes;
import com.github.retrooper.packetevents.protocol.nbt.NBT;
import com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import com.github.retrooper.packetevents.protocol.nbt.NBTList;
import com.github.retrooper.packetevents.protocol.nbt.NBTString;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.protocol.player.InteractionHand;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientEditBook;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerBlockPlacement;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPluginMessage;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientUseItem;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@CheckData(name="ExploitB", description="Invalid book edit")
public class ExploitB
extends Check
implements PacketCheck {
    private ItemStack oldBook;
    private InteractionHand hand;

    public ExploitB(GrimPlayer player) {
        super(player);
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        if (this.player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_8) ? event.getPacketType() == PacketType.Play.Client.PLAYER_BLOCK_PLACEMENT && new WrapperPlayClientPlayerBlockPlacement(event).getFaceId() == 255 : event.getPacketType() == PacketType.Play.Client.USE_ITEM) {
            this.hand = this.player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_8) ? InteractionHand.MAIN_HAND : new WrapperPlayClientUseItem(event).getHand();
            this.oldBook = this.player.getInventory().getItemInHand(this.hand).copy();
        }
        if (event.getPacketType() == PacketType.Play.Client.EDIT_BOOK) {
            this.checkEditBook(new WrapperPlayClientEditBook(event), event);
            this.oldBook = null;
        }
        if (event.getPacketType() == PacketType.Play.Client.PLUGIN_MESSAGE && this.player.getClientVersion().isOlderThan(ClientVersion.V_1_13)) {
            boolean signing;
            WrapperPlayClientPluginMessage wrapper = new WrapperPlayClientPluginMessage(event);
            switch (wrapper.getChannelName()) {
                case "MC|BSign": {
                    signing = true;
                    break;
                }
                case "MC|BEdit": {
                    signing = false;
                    break;
                }
                default: {
                    return;
                }
            }
            ItemStack newBook = PayloadBookEdit.CODEC.read(wrapper.getData()).itemStack();
            this.checkItemStack(newBook, signing, event);
            this.oldBook = null;
        }
    }

    private void checkEditBook(WrapperPlayClientEditBook wrapper, PacketReceiveEvent event) {
        int expectedSlot;
        if (this.checkEditingBook(event)) {
            return;
        }
        int n = expectedSlot = this.hand == InteractionHand.OFF_HAND ? 40 : this.player.packetStateData.lastSlotSelected;
        if (wrapper.getSlot() != expectedSlot) {
            if (this.flagAndAlert("expectedSlot=" + expectedSlot + ", slot=" + wrapper.getSlot()) && this.shouldModifyPackets()) {
                event.setCancelled(true);
                this.player.onPacketCancel();
            }
            return;
        }
        if (wrapper.getSigning() == null) {
            if (wrapper.getTitle() != null && this.checkTitle(wrapper.getTitle(), event)) {
                return;
            }
            List pages = wrapper.getPages();
            if (!pages.isEmpty() && this.checkEmptyLastPage((String)pages.get(pages.size() - 1), event)) {
                return;
            }
            if (this.checkTooManyPages(pages.size(), event)) {
                return;
            }
            for (String page : pages) {
                if (!this.checkPage(page, event)) continue;
                return;
            }
        } else {
            this.checkItemStack(wrapper.getItemStack(), wrapper.getSigning(), event);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void checkItemStack(ItemStack newBook, boolean signing, PacketReceiveEvent event) {
        ItemType expectedType;
        if (this.checkEditingBook(event)) {
            return;
        }
        ItemType itemType = expectedType = signing && this.player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_8) ? ItemTypes.WRITTEN_BOOK : ItemTypes.WRITABLE_BOOK;
        if (!newBook.is(expectedType)) {
            if (this.flagAndAlert("expectedType=" + expectedType.getName().getKey() + ", type=" + newBook.getType().getName().getKey()) && this.shouldModifyPackets()) {
                event.setCancelled(true);
                this.player.onPacketCancel();
            }
            return;
        }
        if (newBook.getAmount() != this.oldBook.getAmount()) {
            if (this.flagAndAlert("expectedAmount=" + this.oldBook.getAmount() + ", amount=" + newBook.getAmount()) && this.shouldModifyPackets()) {
                event.setCancelled(true);
                this.player.onPacketCancel();
            }
            return;
        }
        if (newBook.getLegacyData() != this.oldBook.getLegacyData()) {
            if (this.flagAndAlert("expectedMeta=" + this.oldBook.getLegacyData() + ", meta=" + newBook.getLegacyData()) && this.shouldModifyPackets()) {
                event.setCancelled(true);
                this.player.onPacketCancel();
            }
            return;
        }
        NBTCompound newBookNBT = newBook.getNBT();
        if (newBookNBT == null) {
            if (this.flagAndAlert("no nbt") && this.shouldModifyPackets()) {
                event.setCancelled(true);
                this.player.onPacketCancel();
            }
            return;
        }
        @NotNull NBTList newPagesNBT = newBookNBT.getStringListTagOrNull("pages");
        if (newPagesNBT == null) {
            if (this.flagAndAlert("no pages") && this.shouldModifyPackets()) {
                event.setCancelled(true);
                this.player.onPacketCancel();
            }
            return;
        }
        if (this.checkTooManyPages(newPagesNBT.size(), event)) {
            return;
        }
        if (signing) {
            String title = newBookNBT.getStringTagValueOrNull("title");
            if (title == null) {
                if (this.flagAndAlert("no title") && this.shouldModifyPackets()) {
                    event.setCancelled(true);
                    this.player.onPacketCancel();
                }
                return;
            }
            if (this.checkTitle(title, event)) {
                return;
            }
            String author = newBookNBT.getStringTagValueOrNull("author");
            if (!this.player.getName().equals(author)) {
                if (this.flagAndAlert("expectedAuthor=" + this.player.getName() + ", author=" + (String)author) && this.shouldModifyPackets()) {
                    event.setCancelled(true);
                    this.player.onPacketCancel();
                }
                return;
            }
        }
        String last = null;
        for (NBTString string : newPagesNBT.getTags()) {
            block31: {
                if (this.player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_8) && signing) {
                    try {
                        JsonReader reader = new JsonReader((Reader)new StringReader(string.getValue()));
                        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
                            throw new JsonSyntaxException("");
                        }
                        reader.beginObject();
                        if (reader.peek() != JsonToken.NAME || !reader.nextName().equals("text") || reader.peek() != JsonToken.STRING) {
                            throw new JsonSyntaxException("");
                        }
                        last = reader.nextString();
                        if (reader.peek() != JsonToken.END_OBJECT) {
                            throw new JsonSyntaxException("");
                        }
                        break block31;
                    }
                    catch (JsonSyntaxException e) {
                        if (this.flagAndAlert("invalid page") && this.shouldModifyPackets()) {
                            event.setCancelled(true);
                            this.player.onPacketCancel();
                        }
                        return;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                last = string.getValue();
            }
            if (!this.checkPage(last, event)) continue;
            return;
        }
        if (last != null && this.checkEmptyLastPage(last, event)) {
            return;
        }
        Set newNBT = newBookNBT.getTags().entrySet();
        HashMap oldNBT = this.oldBook.getNBT() == null ? new HashMap() : new HashMap(this.oldBook.getNBT().getTags());
        oldNBT.remove("pages");
        oldNBT.remove("title");
        oldNBT.remove("author");
        for (Map.Entry entry : newNBT) {
            NBT nbt;
            if (((String)entry.getKey()).equals("pages") || ((String)entry.getKey()).equals("title") || ((String)entry.getKey()).equals("author") || (nbt = (NBT)oldNBT.remove(entry.getKey())) != null && nbt.equals(entry.getValue())) continue;
            if (this.flagAndAlert("modified nbt") && this.shouldModifyPackets()) {
                event.setCancelled(true);
                this.player.onPacketCancel();
            }
            return;
        }
        if (!oldNBT.isEmpty() && this.flagAndAlert("modified nbt") && this.shouldModifyPackets()) {
            event.setCancelled(true);
            this.player.onPacketCancel();
        }
    }

    private boolean checkTitle(@NotNull String title, PacketReceiveEvent event) {
        if (title.length() > (this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_16) ? 15 : 16)) {
            if (this.flagAndAlert("title too long") && this.shouldModifyPackets()) {
                event.setCancelled(true);
                this.player.onPacketCancel();
            }
            return true;
        }
        if (title.isEmpty() || !title.trim().equals(title) || ExploitB.containsInvalidCharacters(title)) {
            if (this.flagAndAlert("invalid title '" + title + "'") && this.shouldModifyPackets()) {
                event.setCancelled(true);
                this.player.onPacketCancel();
            }
            return true;
        }
        return false;
    }

    private boolean checkEditingBook(PacketReceiveEvent event) {
        if (this.oldBook == null || !this.oldBook.is(ItemTypes.WRITABLE_BOOK)) {
            if (this.flagAndAlert("not editing book") && this.shouldModifyPackets()) {
                event.setCancelled(true);
                this.player.onPacketCancel();
            }
            return true;
        }
        return false;
    }

    private boolean checkTooManyPages(int pages, PacketReceiveEvent event) {
        NBTList oldPagesNBT;
        int oldPages;
        int n = this.oldBook.getVersion().isNewerThanOrEquals(ClientVersion.V_1_20_5) ? this.oldBook.getComponent(ComponentTypes.WRITABLE_BOOK_CONTENT).map(content -> content.getPages().size()).orElse(0) : (oldPages = this.oldBook.getNBT() != null && (oldPagesNBT = this.oldBook.getNBT().getStringListTagOrNull("pages")) != null ? oldPagesNBT.size() : 0);
        if (pages > oldPages && pages > (this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_14) ? 100 : 50)) {
            if (this.flagAndAlert("too many pages") && this.shouldModifyPackets()) {
                event.setCancelled(true);
                this.player.onPacketCancel();
            }
            return true;
        }
        return false;
    }

    private boolean checkPage(String page, PacketReceiveEvent event) {
        if (page.length() > 256) {
            if (this.flagAndAlert("page too long") && this.shouldModifyPackets()) {
                event.setCancelled(true);
                this.player.onPacketCancel();
            }
            return true;
        }
        if (ExploitB.containsInvalidCharacters(page)) {
            if (this.flagAndAlert("invalid page characters") && this.shouldModifyPackets()) {
                event.setCancelled(true);
                this.player.onPacketCancel();
            }
            return true;
        }
        return false;
    }

    private boolean checkEmptyLastPage(String page, PacketReceiveEvent event) {
        if (page.isEmpty()) {
            if (this.flagAndAlert("empty last page") && this.shouldModifyPackets()) {
                event.setCancelled(true);
                this.player.onPacketCancel();
            }
            return true;
        }
        return false;
    }

    private static boolean containsInvalidCharacters(@NotNull String string) {
        for (int i = 0; i < string.length(); ++i) {
            char character = string.charAt(i);
            if (character != '\u00a7' && character >= ' ' && character != '\u007f') continue;
            return true;
        }
        return false;
    }
}

