/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.nmsutil;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.data.Pair;
import ac.grim.grimac.utils.math.GrimMath;
import ac.grim.grimac.utils.math.Vector3dm;
import ac.grim.grimac.utils.math.VectorUtils;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.protocol.world.BlockFace;

public class ReachUtils {
    public static Pair<Vector3dm, BlockFace> calculateIntercept(SimpleCollisionBox self, Vector3dm origin, Vector3dm end) {
        Vector3dm minX = ReachUtils.getIntermediateWithXValue(origin, end, self.minX);
        Vector3dm maxX = ReachUtils.getIntermediateWithXValue(origin, end, self.maxX);
        Vector3dm minY = ReachUtils.getIntermediateWithYValue(origin, end, self.minY);
        Vector3dm maxY = ReachUtils.getIntermediateWithYValue(origin, end, self.maxY);
        Vector3dm minZ = ReachUtils.getIntermediateWithZValue(origin, end, self.minZ);
        Vector3dm maxZ = ReachUtils.getIntermediateWithZValue(origin, end, self.maxZ);
        BlockFace bestFace = null;
        if (!ReachUtils.isVecInYZ(self, minX)) {
            minX = null;
        }
        if (!ReachUtils.isVecInYZ(self, maxX)) {
            maxX = null;
        }
        if (!ReachUtils.isVecInXZ(self, minY)) {
            minY = null;
        }
        if (!ReachUtils.isVecInXZ(self, maxY)) {
            maxY = null;
        }
        if (!ReachUtils.isVecInXY(self, minZ)) {
            minZ = null;
        }
        if (!ReachUtils.isVecInXY(self, maxZ)) {
            maxZ = null;
        }
        Vector3dm best = null;
        if (minX != null) {
            best = minX;
            bestFace = BlockFace.WEST;
        }
        if (maxX != null && (best == null || origin.distanceSquared(maxX) < origin.distanceSquared(best))) {
            best = maxX;
            bestFace = BlockFace.EAST;
        }
        if (minY != null && (best == null || origin.distanceSquared(minY) < origin.distanceSquared(best))) {
            best = minY;
            bestFace = BlockFace.DOWN;
        }
        if (maxY != null && (best == null || origin.distanceSquared(maxY) < origin.distanceSquared(best))) {
            best = maxY;
            bestFace = BlockFace.UP;
        }
        if (minZ != null && (best == null || origin.distanceSquared(minZ) < origin.distanceSquared(best))) {
            best = minZ;
            bestFace = BlockFace.NORTH;
        }
        if (maxZ != null && (best == null || origin.distanceSquared(maxZ) < origin.distanceSquared(best))) {
            best = maxZ;
            bestFace = BlockFace.SOUTH;
        }
        return new Pair<Vector3dm, BlockFace>(best, bestFace);
    }

    public static Vector3dm getIntermediateWithXValue(Vector3dm self, Vector3dm other, double x) {
        double deltaX = other.getX() - self.getX();
        double deltaY = other.getY() - self.getY();
        double deltaZ = other.getZ() - self.getZ();
        if (deltaX * deltaX < (double)1.0E-7f) {
            return null;
        }
        double d3 = (x - self.getX()) / deltaX;
        return d3 >= 0.0 && d3 <= 1.0 ? new Vector3dm(self.getX() + deltaX * d3, self.getY() + deltaY * d3, self.getZ() + deltaZ * d3) : null;
    }

    public static Vector3dm getIntermediateWithYValue(Vector3dm self, Vector3dm other, double y) {
        double deltaX = other.getX() - self.getX();
        double deltaY = other.getY() - self.getY();
        double deltaZ = other.getZ() - self.getZ();
        if (deltaY * deltaY < (double)1.0E-7f) {
            return null;
        }
        double d3 = (y - self.getY()) / deltaY;
        return d3 >= 0.0 && d3 <= 1.0 ? new Vector3dm(self.getX() + deltaX * d3, self.getY() + deltaY * d3, self.getZ() + deltaZ * d3) : null;
    }

    public static Vector3dm getIntermediateWithZValue(Vector3dm self, Vector3dm other, double z) {
        double deltaX = other.getX() - self.getX();
        double deltaY = other.getY() - self.getY();
        double deltaZ = other.getZ() - self.getZ();
        if (deltaZ * deltaZ < (double)1.0E-7f) {
            return null;
        }
        double d3 = (z - self.getZ()) / deltaZ;
        return d3 >= 0.0 && d3 <= 1.0 ? new Vector3dm(self.getX() + deltaX * d3, self.getY() + deltaY * d3, self.getZ() + deltaZ * d3) : null;
    }

    private static boolean isVecInYZ(SimpleCollisionBox self, Vector3dm vec) {
        return vec != null && vec.getY() >= self.minY && vec.getY() <= self.maxY && vec.getZ() >= self.minZ && vec.getZ() <= self.maxZ;
    }

    private static boolean isVecInXZ(SimpleCollisionBox self, Vector3dm vec) {
        return vec != null && vec.getX() >= self.minX && vec.getX() <= self.maxX && vec.getZ() >= self.minZ && vec.getZ() <= self.maxZ;
    }

    private static boolean isVecInXY(SimpleCollisionBox self, Vector3dm vec) {
        return vec != null && vec.getX() >= self.minX && vec.getX() <= self.maxX && vec.getY() >= self.minY && vec.getY() <= self.maxY;
    }

    public static Vector3dm getLook(GrimPlayer player, float yaw, float pitch) {
        if (player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_12_2)) {
            float f = player.trigHandler.cos(GrimMath.radians(-yaw) - (float)Math.PI);
            float f1 = player.trigHandler.sin(GrimMath.radians(-yaw) - (float)Math.PI);
            float f2 = -player.trigHandler.cos(GrimMath.radians(-pitch));
            float f3 = player.trigHandler.sin(GrimMath.radians(-pitch));
            return new Vector3dm(f1 * f2, f3, f * f2);
        }
        float f = GrimMath.radians(pitch);
        float f1 = GrimMath.radians(-yaw);
        float f2 = player.trigHandler.cos(f1);
        float f3 = player.trigHandler.sin(f1);
        float f4 = player.trigHandler.cos(f);
        float f5 = player.trigHandler.sin(f);
        return new Vector3dm((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    public static boolean isVecInside(SimpleCollisionBox self, Vector3dm vec) {
        return vec.getX() > self.minX && vec.getX() < self.maxX && vec.getY() > self.minY && vec.getY() < self.maxY && vec.getZ() > self.minZ && vec.getZ() < self.maxZ;
    }

    public static double getMinReachToBox(GrimPlayer player, SimpleCollisionBox targetBox) {
        double[] possibleEyeHeights;
        boolean giveMovementThresholdLenience;
        boolean bl = giveMovementThresholdLenience = !player.packetStateData.didLastMovementIncludePosition || player.canSkipTicks();
        if (player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_8)) {
            targetBox.expand(0.1);
        }
        double lowest = Double.MAX_VALUE;
        if (giveMovementThresholdLenience) {
            targetBox.expand(player.getMovementThreshold());
        }
        for (double eyes : possibleEyeHeights = player.getPossibleEyeHeights()) {
            Vector3dm from = new Vector3dm(player.x, player.y + eyes, player.z);
            Vector3dm closestPoint = VectorUtils.cutBoxToVector(from, targetBox);
            lowest = Math.min(lowest, closestPoint.distance(from));
        }
        return lowest;
    }
}

