/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.zine.client.atlas;

import com.eightsidedsquare.zine.client.atlas.TextureData;
import com.mojang.logging.LogUtils;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7948;
import net.minecraft.class_8066;
import org.slf4j.Logger;

public final class AtlasSourceUtil {
    private static final Logger LOGGER = LogUtils.getLogger();

    private AtlasSourceUtil() {
    }

    public static class_8066 createPaletted(List<class_2960> textures, class_2960 paletteKey, Map<String, class_2960> permutations) {
        return new class_8066(textures, paletteKey, permutations);
    }

    public static TextureData open(class_3300 resourceManager, class_2960 texture) {
        Optional optional = resourceManager.method_14486(class_7948.field_42075.method_45112(texture));
        if (optional.isEmpty()) {
            LOGGER.error("Failed to load texture {}", (Object)texture);
            throw new IllegalArgumentException();
        }
        try {
            TextureData textureData;
            InputStream inputStream = ((class_3298)optional.get()).method_14482();
            try (class_1011 nativeImage = class_1011.method_4309((InputStream)inputStream);){
                textureData = new TextureData(nativeImage.method_61942(), nativeImage.method_4307(), nativeImage.method_4323());
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable suppressedThrowable) {
                        throwable.addSuppressed(suppressedThrowable);
                    }
                }
                throw throwable;
            }
            inputStream.close();
            return textureData;
        }
        catch (Exception e) {
            LOGGER.error("Couldn't load texture {}", (Object)texture, (Object)e);
            throw new IllegalArgumentException();
        }
    }

    public static class_1011 createNativeImage(int width, int height, ImagePos2Color function) {
        class_1011 nativeImage = new class_1011(width, height, false);
        int size = width * height;
        for (int i = 0; i < size; ++i) {
            int x = i % width;
            int y = i / width;
            float u = (float)x / (float)width;
            float v = (float)y / (float)height;
            nativeImage.method_61941(x, y, function.apply(i, x, y, u, v));
        }
        return nativeImage;
    }

    public static class_1011 createAnimatedNativeImage(int frames, int width, int height, AnimatedImagePos2Color function) {
        class_1011 nativeImage = new class_1011(width, height * frames, false);
        int size = width * height;
        for (int i = 0; i < size; ++i) {
            int x = i % width;
            int y = i / width;
            float u = (float)x / (float)width;
            float v = (float)y / (float)height;
            for (int frame = 0; frame < frames; ++frame) {
                nativeImage.method_61941(x, y + frame * height, function.apply(frame, i, x, y, u, v));
            }
        }
        return nativeImage;
    }

    @FunctionalInterface
    public static interface ImagePos2Color {
        public int apply(int var1, int var2, int var3, float var4, float var5);
    }

    @FunctionalInterface
    public static interface AnimatedImagePos2Color {
        public int apply(int var1, int var2, int var3, int var4, float var5, float var6);
    }
}

