/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.zine.client.atlas;

import com.eightsidedsquare.zine.client.atlas.AtlasSourceUtil;
import com.eightsidedsquare.zine.client.atlas.TextureData;
import com.eightsidedsquare.zine.common.util.CodecUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_7368;
import net.minecraft.class_7764;
import net.minecraft.class_7948;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class RemapAtlasSource
implements class_7948 {
    public static final MapCodec<RemapAtlasSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CodecUtil.nonEmptyListCodec(TextureSet.CODEC).fieldOf("texture_sets").forGetter(RemapAtlasSource::getTextureSets), (App)CodecUtil.nonEmptyListCodec(Mapping.CODEC).fieldOf("mappings").forGetter(RemapAtlasSource::getMappings)).apply((Applicative)instance, RemapAtlasSource::new));
    private List<TextureSet> textureSets;
    private List<Mapping> mappings;

    public RemapAtlasSource(List<TextureSet> textureSets, List<Mapping> mappings) {
        this.textureSets = new ArrayList<TextureSet>(textureSets);
        this.mappings = new ArrayList<Mapping>(mappings);
    }

    public MapCodec<? extends class_7948> method_67288() {
        return CODEC;
    }

    public List<TextureSet> getTextureSets() {
        return this.textureSets;
    }

    public void setTextureSets(List<TextureSet> textureSets) {
        this.textureSets = textureSets;
    }

    public void addTextureSet(TextureSet textureSet) {
        this.textureSets.add(textureSet);
    }

    public List<Mapping> getMappings() {
        return this.mappings;
    }

    public void setMappings(List<Mapping> mappings) {
        this.mappings = mappings;
    }

    public void addMapping(Mapping mapping) {
        this.mappings.add(mapping);
    }

    public void method_47673(class_3300 resourceManager, class_7948.class_7949 regions) {
        ArrayList<Sampler> samplers = new ArrayList<Sampler>();
        for (TextureSet textureSet : this.textureSets) {
            samplers.add(textureSet.createSampler(resourceManager));
        }
        for (Mapping mapping : this.mappings) {
            TextureData mappingData = AtlasSourceUtil.open(resourceManager, mapping.texture);
            int[] pixelData = mappingData.data();
            int width = mappingData.width();
            int height = mappingData.height();
            for (int i = 0; i < this.textureSets.size(); ++i) {
                TextureSet textureSet = this.textureSets.get(i);
                Sampler sampler = (Sampler)samplers.get(i);
                class_2960 texture = mapping.getTextureName(textureSet.name);
                regions.method_47670(texture, spriteOpener -> {
                    class_1011 nativeImage = new class_1011(width, height, false);
                    for (int j = 0; j < pixelData.length; ++j) {
                        int x = j % width;
                        int y = j / width;
                        float u = (float)x / (float)width;
                        float v = (float)y / (float)height;
                        nativeImage.method_61941(x, y, sampler.sample(pixelData[j], u, v));
                    }
                    return new class_7764(texture, mappingData.getDimensions(), nativeImage, class_7368.field_38688);
                });
            }
        }
    }

    public static Mapping mapping(class_2960 texture, @Nullable String prefix, @Nullable String suffix) {
        return new Mapping(texture, Optional.ofNullable(prefix), Optional.ofNullable(suffix));
    }

    public static Texture texture(class_2960 texture) {
        return new Texture(texture, Optional.empty());
    }

    public static Texture texture(class_2960 texture, class_2960 offsetTexture, int min, int max) {
        return new Texture(texture, Optional.of(new Offset(offsetTexture, min, max)));
    }

    public static TextureSet textureSet(String name, Map<Integer, Texture> textures) {
        return new TextureSet(name, textures);
    }

    public static class TextureSet {
        public static final Codec<TextureSet> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(TextureSet::getName), (App)Codec.unboundedMap(CodecUtil.INT_STRING, Texture.VALUE_CODEC).fieldOf("textures").forGetter(TextureSet::getTextures)).apply((Applicative)instance, TextureSet::new));
        private String name;
        private Int2ObjectMap<Texture> textures;

        public TextureSet(String name, Map<Integer, Texture> textures) {
            this.name = name;
            this.textures = new Int2ObjectArrayMap(textures);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Int2ObjectMap<Texture> getTextures() {
            return this.textures;
        }

        public void setTextures(Int2ObjectMap<Texture> textures) {
            this.textures = textures;
        }

        public void addTexture(Texture texture, int index) {
            this.textures.put(index, (Object)texture);
        }

        public Sampler createSampler(class_3300 resourceManager) {
            Int2ObjectArrayMap samplers = new Int2ObjectArrayMap();
            this.textures.forEach((arg_0, arg_1) -> TextureSet.lambda$createSampler$1((Int2ObjectMap)samplers, resourceManager, arg_0, arg_1));
            return (arg_0, arg_1, arg_2) -> TextureSet.lambda$createSampler$2((Int2ObjectMap)samplers, arg_0, arg_1, arg_2);
        }

        private static /* synthetic */ int lambda$createSampler$2(Int2ObjectMap samplers, int uvw, float u, float v) {
            Sampler sampler = (Sampler)samplers.get(uvw & 0xFF);
            return sampler == null ? uvw : sampler.sample(uvw, u, v);
        }

        private static /* synthetic */ void lambda$createSampler$1(Int2ObjectMap samplers, class_3300 resourceManager, Integer index, Texture texture) {
            samplers.put(index.intValue(), (Object)texture.createSampler(resourceManager));
        }
    }

    @FunctionalInterface
    public static interface Sampler {
        public int sample(int var1, float var2, float var3);
    }

    public record Mapping(class_2960 texture, Optional<String> prefix, Optional<String> suffix) {
        public static final Codec<Mapping> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("texture").forGetter(Mapping::texture), (App)Codec.STRING.optionalFieldOf("prefix").forGetter(Mapping::prefix), (App)Codec.STRING.optionalFieldOf("suffix").forGetter(Mapping::suffix)).apply((Applicative)instance, Mapping::new));

        public class_2960 getTextureName(String name) {
            if (this.prefix.isPresent()) {
                name = this.prefix.get() + (String)name;
            }
            if (this.suffix.isPresent()) {
                name = (String)name + this.suffix.get();
            }
            return class_2960.method_60655((String)this.texture.method_12836(), (String)name);
        }
    }

    public record Texture(class_2960 texture, Optional<Offset> offset) {
        public static final Codec<Texture> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("texture").forGetter(Texture::texture), (App)Offset.CODEC.optionalFieldOf("offset").forGetter(Texture::offset)).apply((Applicative)instance, Texture::new));
        public static final Codec<Texture> VALUE_CODEC = Codec.either((Codec)class_2960.field_25139, CODEC).xmap(either -> (Texture)either.map(RemapAtlasSource::texture, Function.identity()), texture -> texture.offset.isPresent() ? Either.right((Object)texture) : Either.left((Object)texture.texture));

        public Sampler createSampler(class_3300 resourceManager) {
            TextureData textureData = AtlasSourceUtil.open(resourceManager, this.texture);
            int[] pixelData = textureData.data();
            int width = textureData.width();
            int height = textureData.height();
            Sampler sampler = (uvw, u, v) -> pixelData[(uvw >> 16 & 0xFF) / width + (uvw >> 8 & 0xFF) / height * width];
            return this.offset.map(offset -> offset.offsetSampler(sampler, resourceManager)).orElse(sampler);
        }
    }

    public record Offset(class_2960 texture, int min, int max) {
        public static final Codec<Offset> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("texture").forGetter(Offset::texture), (App)Codec.INT.fieldOf("min").forGetter(Offset::min), (App)Codec.INT.fieldOf("max").forGetter(Offset::max)).apply((Applicative)instance, Offset::new));

        public Sampler offsetSampler(Sampler sampler, class_3300 resourceManager) {
            TextureData textureData = AtlasSourceUtil.open(resourceManager, this.texture);
            int[] pixelData = textureData.data();
            int width = textureData.width();
            int height = textureData.height();
            return (uvw, u, v) -> {
                int sU = uvw >> 16 & 0xFF;
                int sV = uvw >> 8 & 0xFF;
                int offset = pixelData[sU / width + sV / height * width];
                int offsetU = class_3532.method_48781((float)((float)(offset >> 16 & 0xFF) / 255.0f), (int)this.min, (int)this.max);
                int offsetV = class_3532.method_48781((float)((float)(offset >> 8 & 0xFF) / 255.0f), (int)this.min, (int)this.max);
                sU = class_3532.method_15340((int)(sU + offsetU), (int)0, (int)255);
                sV = class_3532.method_15340((int)(sV + offsetV), (int)0, (int)255);
                return sampler.sample(uvw & 0xFF0000FF | sU << 16 | sV << 8, u, v);
            };
        }
    }
}

