/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.zine.client.atlas.gradient;

import com.eightsidedsquare.zine.client.atlas.gradient.FlatGradient;
import com.eightsidedsquare.zine.client.atlas.gradient.Gradient1D;
import com.eightsidedsquare.zine.client.atlas.gradient.Gradient2D;
import com.eightsidedsquare.zine.client.atlas.gradient.Gradient3D;
import com.eightsidedsquare.zine.client.atlas.gradient.GradientPoint;
import com.eightsidedsquare.zine.core.ZineMod;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import net.minecraft.class_9848;

public interface Gradient {
    public static final class_5699.class_10388<class_2960, MapCodec<? extends Gradient>> ID_MAPPER = new class_5699.class_10388();
    public static final Codec<Gradient> CODEC = ID_MAPPER.method_65323(class_2960.field_25139).dispatch(Gradient::getCodec, Function.identity());

    public static void bootstrap() {
        ID_MAPPER.method_65325((Object)ZineMod.id("flat"), FlatGradient.CODEC);
        ID_MAPPER.method_65325((Object)ZineMod.id("1d"), Gradient1D.MAP_CODEC);
        ID_MAPPER.method_65325((Object)ZineMod.id("2d"), Gradient2D.MAP_CODEC);
        ID_MAPPER.method_65325((Object)ZineMod.id("3d"), Gradient3D.MAP_CODEC);
    }

    public MapCodec<? extends Gradient> getCodec();

    public int get(float var1, float var2, float var3);

    default public <T> int get(float t, List<GradientPoint<T>> points, Function<T, Integer> colorGetter) {
        GradientPoint<T> end = points.getLast();
        if (points.size() == 1) {
            return colorGetter.apply(end.v());
        }
        if (t >= 1.0f || t >= end.t()) {
            return colorGetter.apply(end.v());
        }
        GradientPoint<T> start = points.getFirst();
        if (t <= 0.0f || t <= start.t()) {
            return colorGetter.apply(start.v());
        }
        for (GradientPoint<T> point : points) {
            if (t == point.t()) {
                return colorGetter.apply(point.v());
            }
            if (t > point.t()) {
                start = point;
                continue;
            }
            end = point;
            break;
        }
        float delta = (t - start.t()) / (end.t() - start.t());
        return class_9848.method_61319((float)delta, (int)colorGetter.apply(start.v()), (int)colorGetter.apply(end.v()));
    }

    public static interface Builder<T extends Gradient> {
        public T build();
    }
}

