/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.zine.client.atlas.gradient;

import com.eightsidedsquare.zine.client.atlas.gradient.Gradient;
import com.eightsidedsquare.zine.client.atlas.gradient.GradientPoint;
import com.eightsidedsquare.zine.common.util.CodecUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_5699;

public record Gradient1D(List<GradientPoint<Integer>> points) implements Gradient
{
    private static final Codec<GradientPoint<Integer>> POINT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_54067.fieldOf("argb").forGetter(GradientPoint::v), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("t").forGetter(GradientPoint::t)).apply((Applicative)instance, GradientPoint::new));
    public static final MapCodec<Gradient1D> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CodecUtil.nonEmptyListCodec(POINT_CODEC).fieldOf("pts").forGetter(Gradient1D::points)).apply((Applicative)instance, Gradient1D::new));
    public static final Codec<Gradient1D> CODEC = CodecUtil.nonEmptyListCodec(POINT_CODEC).xmap(Gradient1D::new, Gradient1D::points);

    public Gradient1D(List<GradientPoint<Integer>> points) {
        this.points = new ArrayList<GradientPoint<Integer>>(points);
        this.points.sort(GradientPoint::compareTo);
    }

    @Override
    public MapCodec<? extends Gradient> getCodec() {
        return MAP_CODEC;
    }

    @Override
    public int get(float u, float v, float w) {
        return this.get(u, this.points, Function.identity());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements Gradient.Builder<Gradient1D> {
        private final List<GradientPoint<Integer>> points = new ArrayList<GradientPoint<Integer>>();

        public Builder pt(int rgba, float t) {
            this.points.add(new GradientPoint<Integer>(rgba, t));
            return this;
        }

        @Override
        public Gradient1D build() {
            return new Gradient1D(this.points);
        }
    }
}

