/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.zine.client.block.model;

import com.eightsidedsquare.zine.client.util.ConnectedPattern;
import com.eightsidedsquare.zine.client.util.ConnectedShape;
import com.eightsidedsquare.zine.client.util.SpriteIds;
import com.eightsidedsquare.zine.common.util.Offset;
import java.lang.invoke.LambdaMetafactory;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableMesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_10526;
import net.minecraft.class_1058;
import net.minecraft.class_10813;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_7775;
import net.minecraft.class_9826;
import org.jetbrains.annotations.Nullable;

public class ConnectedBlockModel
implements class_1087,
class_1087.class_10892,
class_10813 {
    protected static final class_2960 PARENT_ID = class_2960.method_60656((String)"block/block");
    protected static final Offset[] X_OFFSETS = new Offset[]{Offset.UP_SOUTH, Offset.UP, Offset.UP_NORTH, Offset.NORTH, Offset.DOWN_NORTH, Offset.DOWN, Offset.DOWN_SOUTH, Offset.SOUTH};
    protected static final Offset[] Y_OFFSETS = new Offset[]{Offset.NORTHWEST, Offset.NORTH, Offset.NORTHEAST, Offset.EAST, Offset.SOUTHEAST, Offset.SOUTH, Offset.SOUTHWEST, Offset.WEST};
    protected static final Offset[] Z_OFFSETS = new Offset[]{Offset.UP_WEST, Offset.UP, Offset.UP_EAST, Offset.EAST, Offset.DOWN_EAST, Offset.DOWN, Offset.DOWN_WEST, Offset.WEST};
    protected final EnumMap<ConnectedPattern, class_4730> spriteIds = new EnumMap(ConnectedPattern.class);
    protected final EnumMap<ConnectedPattern, Mesh[]> meshes = new EnumMap(ConnectedPattern.class);
    private final class_2960 baseName;
    protected class_1058 particleSprite;

    public ConnectedBlockModel(class_2960 baseName, class_2960 allTexture, class_2960 cornersTexture, class_2960 horizontalTexture, class_2960 noneTexture, class_2960 verticalTexture) {
        this.baseName = baseName;
        for (ConnectedPattern pattern : ConnectedPattern.values()) {
            if (pattern.allMatch()) {
                this.spriteIds.put(pattern, SpriteIds.block(switch (pattern.getNW()) {
                    default -> throw new MatchException(null, null);
                    case ConnectedShape.ALL -> allTexture;
                    case ConnectedShape.CORNER -> cornersTexture;
                    case ConnectedShape.HORIZONTAL -> horizontalTexture;
                    case ConnectedShape.NONE -> noneTexture;
                    case ConnectedShape.VERTICAL -> verticalTexture;
                }));
                continue;
            }
            this.spriteIds.put(pattern, SpriteIds.block(pattern.addSuffix(baseName)));
        }
    }

    public ConnectedBlockModel(class_2960 baseName) {
        this(baseName, baseName.method_48331("_all"), baseName.method_48331("_corners"), baseName.method_48331("_horizontal"), baseName.method_48331("_none"), baseName.method_48331("_vertical"));
    }

    protected int getFlags(Predicate<class_2680> predicate, class_1922 world, class_2338 pos) {
        class_2338.class_2339 mutable = pos.method_25503();
        int flags = 0;
        for (Offset offset : Offset.values(this.getOffsetDistance())) {
            if (!predicate.test(world.method_8320((class_2338)mutable.method_25504((class_2382)pos, offset.getX(), offset.getY(), offset.getZ())))) continue;
            flags |= 1 << offset.ordinal();
        }
        return flags;
    }

    protected int getOffsetDistance() {
        return 2;
    }

    protected boolean getFlag(int flags, Offset offset) {
        return (flags & 1 << offset.ordinal()) != 0;
    }

    protected ConnectedShape getShape(Offset[] offsets, int flags, int vertical, int horizontal, int corner) {
        if (this.getFlag(flags, offsets[vertical])) {
            if (this.getFlag(flags, offsets[horizontal])) {
                if (this.getFlag(flags, offsets[corner])) {
                    return ConnectedShape.NONE;
                }
                return ConnectedShape.CORNER;
            }
            return ConnectedShape.VERTICAL;
        }
        if (this.getFlag(flags, offsets[horizontal])) {
            return ConnectedShape.HORIZONTAL;
        }
        return ConnectedShape.ALL;
    }

    protected ConnectedPattern getPattern(class_2350.class_2351 axis, int flags) {
        Offset[] offsets = switch (axis) {
            default -> throw new MatchException(null, null);
            case class_2350.class_2351.field_11048 -> X_OFFSETS;
            case class_2350.class_2351.field_11052 -> Y_OFFSETS;
            case class_2350.class_2351.field_11051 -> Z_OFFSETS;
        };
        return ConnectedPattern.from(this.getShape(offsets, flags, 1, 7, 0), this.getShape(offsets, flags, 1, 3, 2), this.getShape(offsets, flags, 5, 3, 4), this.getShape(offsets, flags, 5, 7, 6));
    }

    public void emitQuads(QuadEmitter emitter, class_1920 world, class_2338 pos, class_2680 state, class_5819 random, Predicate<@Nullable class_2350> cullTest) {
        class_2248 block = state.method_26204();
        int flags = this.getFlags(blockState -> blockState.method_27852(block), (class_1922)world, pos);
        for (class_2350.class_2351 axis : class_2350.class_2351.values()) {
            this.meshes.get((Object)this.getPattern(axis, flags))[axis.ordinal()].outputTo(emitter);
        }
    }

    public class_1087 method_68521(class_7775 baker) {
        this.meshes.clear();
        class_9826 spriteGetter = baker.method_65732();
        Renderer renderer = Renderer.get();
        MutableMesh builder = renderer.mutableMesh();
        QuadEmitter emitter = builder.emitter();
        EnumMap<ConnectedPattern, class_1058> sprites = new EnumMap<ConnectedPattern, class_1058>(ConnectedPattern.class);
        for (Map.Entry<ConnectedPattern, class_4730> entry : this.spriteIds.entrySet()) {
            sprites.put(entry.getKey(), spriteGetter.method_65739(entry.getValue(), (class_10813)this));
        }
        for (ConnectedPattern pattern : ConnectedPattern.values()) {
            class_1058 frontSprite = (class_1058)sprites.get((Object)pattern);
            class_1058 backSideSprite = (class_1058)sprites.get((Object)pattern.flipHorizontal());
            class_1058 backBottomSprite = (class_1058)sprites.get((Object)pattern.flipVertical());
            this.emitMeshes(builder, emitter, pattern, frontSprite, backBottomSprite, backSideSprite);
        }
        builder.clear();
        this.particleSprite = (class_1058)sprites.get((Object)ConnectedPattern.AAAA);
        return this;
    }

    protected void emitMeshes(MutableMesh builder, QuadEmitter emitter, ConnectedPattern pattern, class_1058 frontSprite, class_1058 backBottomSprite, class_1058 backSideSprite) {
        for (class_2350.class_2351 axis : class_2350.class_2351.values()) {
            builder.clear();
            this.emitMeshForAxis(axis, frontSprite, axis == class_2350.class_2351.field_11052 ? backBottomSprite : backSideSprite, emitter);
            this.meshes.computeIfAbsent((ConnectedPattern)pattern, (Function<ConnectedPattern, Mesh[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$emitMeshes$1(com.eightsidedsquare.zine.client.util.ConnectedPattern ), (Lcom/eightsidedsquare/zine/client/util/ConnectedPattern;)[Lnet/fabricmc/fabric/api/renderer/v1/mesh/Mesh;)())[axis.ordinal()] = builder.immutableCopy();
        }
    }

    protected void emitMeshForAxis(class_2350.class_2351 axis, class_1058 frontSprite, class_1058 backSprite, QuadEmitter emitter) {
        this.emitMeshForDirection(axis.method_64922(), frontSprite, emitter);
        this.emitMeshForDirection(axis.method_64923(), backSprite, emitter);
    }

    protected void emitMeshForDirection(class_2350 direction, class_1058 sprite, QuadEmitter emitter) {
        emitter.square(direction, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f);
        emitter.spriteBake(sprite, 4);
        emitter.color(-1, -1, -1, -1);
        emitter.emit();
    }

    public void method_62326(class_10526.class_10103 resolver) {
        resolver.markDependency(PARENT_ID);
    }

    public String debugName() {
        return this.baseName.toString();
    }

    public void method_68513(class_5819 random, List<class_10889> parts) {
    }

    public class_1058 method_68511() {
        return this.particleSprite;
    }

    private static /* synthetic */ Mesh[] lambda$emitMeshes$1(ConnectedPattern p) {
        return new Mesh[3];
    }
}

