/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.zine.client.block.model;

import com.eightsidedsquare.zine.client.util.SpriteIds;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableMesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_10526;
import net.minecraft.class_1058;
import net.minecraft.class_10813;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_7775;
import net.minecraft.class_9826;
import org.jetbrains.annotations.Nullable;

public class TessellatingBlockModel
implements class_1087,
class_1087.class_10892,
class_10813 {
    protected static final class_2960 PARENT_ID = class_2960.method_60656((String)"block/block");
    protected final EnumMap<class_2350.class_2351, Mesh[]> meshes = new EnumMap(class_2350.class_2351.class);
    protected final class_4730 spriteId;
    protected final class_4730 particleSpriteId;
    protected final class_2960 name;
    protected final int size;
    protected class_1058 particleSprite;

    public TessellatingBlockModel(class_2960 id, class_2960 particleId, class_2960 name, int size) {
        this.spriteId = SpriteIds.block(id);
        this.particleSpriteId = SpriteIds.block(particleId);
        this.name = name;
        this.size = size;
    }

    public TessellatingBlockModel(class_2960 id, int size) {
        this(id, id, id, size);
    }

    public void emitQuads(QuadEmitter emitter, class_1920 blockView, class_2338 pos, class_2680 state, class_5819 random, Predicate<@Nullable class_2350> cullTest) {
        for (class_2350.class_2351 axis : class_2350.class_2351.values()) {
            int x = Math.floorMod(axis.method_10173(-1 - pos.method_10260(), pos.method_10263(), pos.method_10263()), this.size);
            int y = Math.floorMod(axis.method_10173(pos.method_10264(), pos.method_10260(), pos.method_10264()), this.size);
            this.meshes.get(axis)[x + y * this.size].outputTo(emitter);
        }
    }

    public void method_68513(class_5819 random, List<class_10889> parts) {
    }

    public class_1058 method_68511() {
        return this.particleSprite;
    }

    public class_1087 method_68521(class_7775 baker) {
        this.meshes.clear();
        int area = this.size * this.size;
        class_9826 spriteGetter = baker.method_65732();
        class_1058 sprite = spriteGetter.method_65739(this.spriteId, (class_10813)this);
        this.particleSprite = spriteGetter.method_65739(this.particleSpriteId, (class_10813)this);
        Renderer renderer = Renderer.get();
        MutableMesh builder = renderer.mutableMesh();
        QuadEmitter emitter = builder.emitter();
        for (class_2350.class_2351 axis : class_2350.class_2351.values()) {
            Mesh[] directionMeshes = this.meshes.computeIfAbsent(axis, a -> new Mesh[area]);
            for (int x = 0; x < this.size; ++x) {
                for (int y = 0; y < this.size; ++y) {
                    if (axis.method_10178()) {
                        this.emitFace(emitter, sprite, axis.method_64922(), x, y);
                        this.emitFace(emitter, sprite, axis.method_64923(), x, this.size - y - 1);
                    } else {
                        this.emitFace(emitter, sprite, axis.method_64922(), x, this.size - y - 1);
                        this.emitFace(emitter, sprite, axis.method_64923(), this.size - x - 1, this.size - y - 1);
                    }
                    directionMeshes[x + y * this.size] = builder.immutableCopy();
                    builder.clear();
                }
            }
        }
        return this;
    }

    protected void emitFace(QuadEmitter emitter, class_1058 sprite, class_2350 direction, int x, int y) {
        emitter.square(direction, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f);
        float u1 = (float)x / (float)this.size;
        float u2 = (float)(x + 1) / (float)this.size;
        float v1 = (float)y / (float)this.size;
        float v2 = (float)(y + 1) / (float)this.size;
        emitter.uv(0, u1, v1);
        emitter.uv(1, u1, v2);
        emitter.uv(2, u2, v2);
        emitter.uv(3, u2, v1);
        emitter.spriteBake(sprite, 32);
        emitter.color(-1, -1, -1, -1);
        emitter.emit();
    }

    public void method_62326(class_10526.class_10103 resolver) {
        resolver.markDependency(PARENT_ID);
    }

    public String debugName() {
        return "";
    }
}

