/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.zine.client.util;

import com.eightsidedsquare.zine.client.util.ConnectedShape;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public enum ConnectedPattern {
    AAAA("all", "aaaa"),
    AHHA("ahha"),
    HHHH("horizontal", "hhhh"),
    HAAH("haah"),
    AHCV("ahcv"),
    HAVC("havc"),
    VCCV("vccv"),
    HHCC("hhcc"),
    CNCC("cncc"),
    CCNC("ccnc"),
    NCCN("nccn"),
    NNCC("nncc"),
    AAVV("aavv"),
    AHNV("ahnv"),
    HHNN("hhnn"),
    HAVN("havn"),
    VCHA("vcha"),
    CVAH("cvah"),
    CCHH("cchh"),
    CVVC("cvvc"),
    NCCC("nccc"),
    CCCN("cccn"),
    CCNN("ccnn"),
    CNNC("cnnc"),
    VVVV("vertical", "vvvv"),
    VNNV("vnnv"),
    NNNN("none", "nnnn"),
    NVVN("nvvn"),
    VCNV("vcnv"),
    HHCN("hhcn"),
    VNCV("vncv"),
    HHNC("hhnc"),
    NNCN("nncn"),
    NNNC("nnnc"),
    CNCN("cncn"),
    NCNC("ncnc"),
    VVAA("vvaa"),
    VNHA("vnha"),
    NNHH("nnhh"),
    NVAH("nvah"),
    CNHH("cnhh"),
    NVVC("nvvc"),
    NCHH("nchh"),
    CVVN("cvvn"),
    NCNN("ncnn"),
    CNNN("cnnn"),
    CCCC("corners", "cccc");

    private static final Int2ObjectMap<ConnectedPattern> LOOKUP;
    private final String suffix;
    private final ConnectedShape nw;
    private final ConnectedShape ne;
    private final ConnectedShape se;
    private final ConnectedShape sw;

    private ConnectedPattern(String suffix, ConnectedShape nw, ConnectedShape ne, ConnectedShape se, ConnectedShape sw) {
        this.suffix = "_" + suffix;
        this.nw = nw;
        this.ne = ne;
        this.se = se;
        this.sw = sw;
    }

    private ConnectedPattern(String suffix, String name) {
        this(suffix, ConnectedShape.fromChar(name.charAt(0)), ConnectedShape.fromChar(name.charAt(1)), ConnectedShape.fromChar(name.charAt(2)), ConnectedShape.fromChar(name.charAt(3)));
    }

    private ConnectedPattern(String name) {
        this(name, name);
    }

    private static int getLookupId(ConnectedShape nw, ConnectedShape ne, ConnectedShape se, ConnectedShape sw) {
        return nw.ordinal() + ne.ordinal() * 5 + se.ordinal() * 25 + sw.ordinal() * 125;
    }

    private static Int2ObjectMap<ConnectedPattern> createLookup() {
        Int2ObjectArrayMap lookup = new Int2ObjectArrayMap();
        for (ConnectedPattern pattern : ConnectedPattern.values()) {
            lookup.put(ConnectedPattern.getLookupId(pattern.nw, pattern.ne, pattern.se, pattern.sw), (Object)pattern);
        }
        return lookup;
    }

    public static ConnectedPattern from(ConnectedShape nw, ConnectedShape ne, ConnectedShape se, ConnectedShape sw) {
        return (ConnectedPattern)((Object)LOOKUP.getOrDefault(ConnectedPattern.getLookupId(nw, ne, se, sw), (Object)AAAA));
    }

    public boolean contains(ConnectedShape shape) {
        return this.nw == shape || this.ne == shape || this.se == shape || this.sw == shape;
    }

    public boolean allMatch() {
        return this.nw == this.ne && this.ne == this.se && this.se == this.sw;
    }

    public class_2960 addSuffix(class_2960 id) {
        return id.method_48331(this.suffix);
    }

    public ConnectedShape getNW() {
        return this.nw;
    }

    public ConnectedShape getNE() {
        return this.ne;
    }

    public ConnectedShape getSE() {
        return this.se;
    }

    public ConnectedShape getSW() {
        return this.sw;
    }

    public ConnectedPattern flipHorizontal() {
        return switch (this.ordinal()) {
            case 1 -> HAAH;
            case 3 -> AHHA;
            case 4 -> HAVC;
            case 5 -> AHCV;
            case 6 -> CVVC;
            case 8 -> NCCC;
            case 9 -> CCCN;
            case 10 -> CNNC;
            case 13 -> HAVN;
            case 15 -> AHNV;
            case 16 -> CVAH;
            case 17 -> VCHA;
            case 19 -> VCCV;
            case 20 -> CNCC;
            case 21 -> CCNC;
            case 23 -> NCCN;
            case 25 -> NVVN;
            case 27 -> VNNV;
            case 28 -> CVVN;
            case 29 -> HHNC;
            case 30 -> NVVC;
            case 31 -> HHCN;
            case 32 -> NNNC;
            case 33 -> NNCN;
            case 34 -> NCNC;
            case 35 -> CNCN;
            case 37 -> NVAH;
            case 39 -> VNHA;
            case 40 -> NCHH;
            case 41 -> VNCV;
            case 42 -> CNHH;
            case 43 -> VCNV;
            case 44 -> CNNN;
            case 45 -> NCNN;
            default -> this;
        };
    }

    public ConnectedPattern flipVertical() {
        return switch (this.ordinal()) {
            case 4 -> VCHA;
            case 5 -> CVAH;
            case 7 -> CCHH;
            case 8 -> CCNC;
            case 9 -> CNCC;
            case 11 -> CCNN;
            case 12 -> VVAA;
            case 13 -> VNHA;
            case 14 -> NNHH;
            case 15 -> NVAH;
            case 16 -> AHCV;
            case 17 -> HAVC;
            case 18 -> HHCC;
            case 20 -> CCCN;
            case 21 -> NCCC;
            case 22 -> NNCC;
            case 28 -> VNCV;
            case 29 -> NCHH;
            case 30 -> VCNV;
            case 31 -> CNHH;
            case 32 -> NCNN;
            case 33 -> CNNN;
            case 34 -> NCNC;
            case 35 -> CNCN;
            case 36 -> AAVV;
            case 37 -> AHNV;
            case 38 -> HHNN;
            case 39 -> HAVN;
            case 40 -> HHNC;
            case 41 -> CVVN;
            case 42 -> HHCN;
            case 43 -> NVVC;
            case 44 -> NNCN;
            case 45 -> NNNC;
            default -> this;
        };
    }

    static {
        LOOKUP = ConnectedPattern.createLookup();
    }
}

