/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.zine.common.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2379;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_5699;

public final class CodecUtil {
    public static final Codec<class_2520> NBT_ELEMENT = class_5699.method_53918((DynamicOps)class_2509.field_11560);
    public static final Codec<class_2379> EULER_ANGLE = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("pitch", (Object)Float.valueOf(0.0f)).forGetter(class_2379::comp_3776), (App)Codec.FLOAT.optionalFieldOf("yaw", (Object)Float.valueOf(0.0f)).forGetter(class_2379::comp_3777), (App)Codec.FLOAT.optionalFieldOf("roll", (Object)Float.valueOf(0.0f)).forGetter(class_2379::comp_3778)).apply((Applicative)instance, class_2379::new));
    public static final Codec<Integer> INT_STRING = Codec.STRING.comapFlatMap(string -> {
        int value;
        try {
            value = Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            return DataResult.error(() -> "Failed to parse int from " + string);
        }
        return DataResult.success((Object)value);
    }, String::valueOf);

    private CodecUtil() {
    }

    public static <A> Codec<List<A>> listCodec(Codec<A> codec) {
        return Codec.either(codec, (Codec)codec.listOf()).xmap(either -> (List)either.map(List::of, list -> list), list -> list.size() == 1 ? Either.left(list.getFirst()) : Either.right((Object)list));
    }

    public static <A> Codec<List<A>> nonEmptyListCodec(Codec<A> codec) {
        return CodecUtil.listCodec(codec).validate(list -> list.isEmpty() ? DataResult.error(() -> "Empty list") : DataResult.success((Object)list));
    }

    public static <O, T> Codec<O> codec(RecordCodecBuilder<O, T> field, Function<T, O> function) {
        return RecordCodecBuilder.create(instance -> instance.group((App)field).apply((Applicative)instance, function));
    }

    public static <O, T> MapCodec<O> mapCodec(RecordCodecBuilder<O, T> field, Function<T, O> function) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)field).apply((Applicative)instance, function));
    }
}

