package com.eightsidedsquare.zine.client.atlas.gradient;

import com.eightsidedsquare.zine.client.ZineClient;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import net.minecraft.class_9848;

public interface Gradient {

    class_5699.class_10388<class_2960, MapCodec<? extends Gradient>> ID_MAPPER = new class_5699.class_10388<>();
    Codec<Gradient> CODEC = ID_MAPPER.method_65323(class_2960.field_25139).dispatch(Gradient::getCodec, Function.identity());

    static void bootstrap() {
        ZineClient.REGISTRY.gradient("flat", FlatGradient.CODEC);
        ZineClient.REGISTRY.gradient("1d", Gradient1D.MAP_CODEC);
        ZineClient.REGISTRY.gradient("2d", Gradient2D.MAP_CODEC);
        ZineClient.REGISTRY.gradient("3d", Gradient3D.MAP_CODEC);
    }

    MapCodec<? extends Gradient> getCodec();

    int get(float u, float v, float w);

    default <T> int get(float t, List<GradientPoint<T>> points, Function<T, Integer> colorGetter) {
        GradientPoint<T> end = points.getLast();
        if(points.size() == 1) {
            return colorGetter.apply(end.v());
        }
        if(t >= 1 || t >= end.t()) {
            return colorGetter.apply(end.v());
        }
        GradientPoint<T> start = points.getFirst();
        if(t <= 0 || t <= start.t()) {
            return colorGetter.apply(start.v());
        }
        for(GradientPoint<T> point : points) {
            if(t == point.t()) {
                return colorGetter.apply(point.v());
            }else if(t > point.t()) {
                start = point;
            }else {
                end = point;
                break;
            }
        }
        float delta = (t - start.t()) / (end.t() - start.t());
        return class_9848.method_61319(delta, colorGetter.apply(start.v()), colorGetter.apply(end.v()));
    }

    interface Builder<T extends Gradient> {
        T build();
    }

}
