package com.eightsidedsquare.zine.client.block;

import com.eightsidedsquare.zine.client.util.ConnectedPattern;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.fabricmc.fabric.api.client.model.loading.v1.CustomUnbakedBlockStateModel;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableMesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_7775;
import org.jetbrains.annotations.Nullable;

import java.util.EnumMap;
import java.util.List;
import java.util.function.Predicate;

public class ConnectedBlockStateModel implements class_1087 {

    private final Mesh[] meshes;
    private final class_1058 particleSprite;
    private final EnumMap<class_2350, ConnectedPatternCalculator> calculators = new EnumMap<>(class_2350.class);

    private ConnectedBlockStateModel(Mesh[] meshes, class_1058 particleSprite, boolean fancy) {
        this.meshes = meshes;
        this.particleSprite = particleSprite;
        this.calculators.putAll(fancy ? ConnectedPatternCalculator.FANCY_CUBE : ConnectedPatternCalculator.FAST_CUBE);
    }

    @Override
    public void emitQuads(QuadEmitter emitter, class_1920 world, class_2338 pos, class_2680 state, class_5819 random, Predicate<@Nullable class_2350> cullTest) {
        for (class_2350 direction : class_2350.values()) {
            if(cullTest.test(direction)) {
                continue;
            }
            ConnectedPattern pattern = this.calculators.get(direction).calculate(world, pos, state);
            this.meshes[getIndex(pattern, direction)].outputTo(emitter);
        }
    }

    @Override
    public class_1058 method_68511() {
        return this.particleSprite;
    }

    private static int getIndex(ConnectedPattern pattern, class_2350 direction) {
        return pattern.ordinal() * 6 + direction.ordinal();
    }

    @Override
    public void method_68513(class_5819 random, List<class_10889> parts) {

    }

    public record Unbaked(class_2960 baseTexture, boolean fancy) implements CustomMeshUnbakedBlockStateModel {

        public static final MapCodec<Unbaked> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
                class_2960.field_25139.fieldOf("base_texture").forGetter(Unbaked::baseTexture),
                Codec.BOOL.fieldOf("fancy").forGetter(Unbaked::fancy)
        ).apply(instance, Unbaked::new));

        @Override
        public MapCodec<? extends CustomUnbakedBlockStateModel> codec() {
            return CODEC;
        }

        @Override
        public int getMeshCount() {
            return ConnectedPattern.values().length * 6;
        }

        @Override
        public class_1087 bake(MutableMesh builder, QuadEmitter emitter, Mesh[] meshes, class_7775 baker) {
            class_1058 particleSprite = null;
            for (ConnectedPattern pattern : ConnectedPattern.values()) {
                class_1058 sprite = baker.zine$getSprite(pattern.addSuffix(this.baseTexture));
                if(pattern == ConnectedPattern.AAAA) {
                    particleSprite = sprite;
                }
                emitMeshes(meshes, builder, emitter, pattern, sprite);
            }
            builder.clear();
            return new ConnectedBlockStateModel(meshes, particleSprite, fancy);
        }

        private static void emitMeshes(Mesh[] meshes, MutableMesh builder, QuadEmitter emitter, ConnectedPattern pattern, class_1058 sprite) {
            for(class_2350 direction : class_2350.values()) {
                builder.clear();
                emitter.square(direction, 0, 0, 1, 1, 0);
                emitter.spriteBake(sprite, MutableQuadView.BAKE_LOCK_UV);
                emitter.color(-1, -1, -1, -1);
                emitter.emit();
                meshes[getIndex(pattern, direction)] = builder.immutableCopy();
            }
        }
    }

}
