package com.eightsidedsquare.zine.client.block;

import com.eightsidedsquare.zine.client.util.ConnectedPattern;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1920;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;

public class ConnectedPatternCalculator {

    public static final Map<class_2350, ConnectedPatternCalculator> FAST_CUBE = ImmutableMap.<class_2350, ConnectedPatternCalculator>builder()
            .put(class_2350.field_11043, create(class_2350.field_11043, class_2350.field_11036, class_2350.field_11039))
            .put(class_2350.field_11034, create(class_2350.field_11034, class_2350.field_11036, class_2350.field_11043))
            .put(class_2350.field_11035, create(class_2350.field_11035, class_2350.field_11036, class_2350.field_11034))
            .put(class_2350.field_11039, create(class_2350.field_11039, class_2350.field_11036, class_2350.field_11035))
            .put(class_2350.field_11036, create(class_2350.field_11036, class_2350.field_11043, class_2350.field_11034))
            .put(class_2350.field_11033, create(class_2350.field_11033, class_2350.field_11035, class_2350.field_11034))
            .build();
    public static final Map<class_2350, ConnectedPatternCalculator> FANCY_CUBE = ImmutableMap.<class_2350, ConnectedPatternCalculator>builder()
            .put(class_2350.field_11043, createFancy(FAST_CUBE.get(class_2350.field_11043), class_2350.field_11043, class_2350.field_11036, class_2350.field_11039))
            .put(class_2350.field_11034, createFancy(FAST_CUBE.get(class_2350.field_11034), class_2350.field_11034, class_2350.field_11036, class_2350.field_11043))
            .put(class_2350.field_11035, createFancy(FAST_CUBE.get(class_2350.field_11035), class_2350.field_11035, class_2350.field_11036, class_2350.field_11034))
            .put(class_2350.field_11039, createFancy(FAST_CUBE.get(class_2350.field_11039), class_2350.field_11039, class_2350.field_11036, class_2350.field_11035))
            .put(class_2350.field_11036, createFancy(FAST_CUBE.get(class_2350.field_11036), class_2350.field_11036, class_2350.field_11043, class_2350.field_11034))
            .put(class_2350.field_11033, createFancy(FAST_CUBE.get(class_2350.field_11033), class_2350.field_11033, class_2350.field_11035, class_2350.field_11034))
            .build();

    private final Instruction[] instructions;

    private ConnectedPatternCalculator(Instruction[] instructions) {
        this.instructions = instructions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ConnectedPatternCalculator calculator) {
        return new Builder(calculator);
    }

    public static InstructionBuilder instruction() {
        return new InstructionBuilder();
    }

    public ConnectedPattern calculate(class_1920 world, class_2338 pos, class_2680 state, AppearancePredicate predicate) {
        class_2338.class_2339 mutable = pos.method_25503();
        ConnectedPattern pattern = ConnectedPattern.NNNN;
        for (Instruction instruction : this.instructions) {
            pattern = instruction.apply(pattern, pos, state, mutable, world, predicate);
        }
        return pattern;
    }

    public ConnectedPattern calculate(class_1920 world, class_2338 pos, class_2680 state) {
        return this.calculate(world, pos, state, AppearancePredicate.block(state.method_26204()));
    }

    public static ConnectedPatternCalculator create(class_2350 face, class_2350 up, class_2350 right) {
        class_2350 down = up.method_10153();
        class_2350 left = right.method_10153();
        class_2338.class_2339 offset = new class_2338.class_2339().method_10098(up).method_10098(right);
        Builder builder = builder();
        for (int i = 0; i < 8; i++) {
            switch (i) {
                case 1, 2 -> offset.method_10098(left);
                case 3, 4 -> offset.method_10098(down);
                case 5, 6 -> offset.method_10098(right);
                case 7 -> offset.method_10098(up);
            }
            InstructionBuilder instruction = instruction().face(face).offset(offset).inverted();
            switch (i) {
                case 0 -> instruction.or(ConnectedPattern.NCNN);
                case 1 -> instruction.or(ConnectedPattern.HHNN);
                case 2 -> instruction.or(ConnectedPattern.CNNN);
                case 3 -> instruction.or(ConnectedPattern.VNNV);
                case 4 -> instruction.or(ConnectedPattern.NNNC);
                case 5 -> instruction.or(ConnectedPattern.NNHH);
                case 6 -> instruction.or(ConnectedPattern.NNCN);
                case 7 -> instruction.or(ConnectedPattern.NVVN);
            }
            builder.then(instruction);
        }
        return builder.build();
    }

    public static ConnectedPatternCalculator createFancy(ConnectedPatternCalculator base, class_2350 face, class_2350 up, class_2350 right) {
        class_2350 down = up.method_10153();
        class_2350 left = right.method_10153();
        class_2338.class_2339 offset = new class_2338.class_2339().method_10098(up).method_10098(right).method_10098(face);
        Builder builder = builder(base);
        for (int i = 0; i < 8; i++) {
            switch (i) {
                case 1, 2 -> offset.method_10098(left);
                case 3, 4 -> offset.method_10098(down);
                case 5, 6 -> offset.method_10098(right);
                case 7 -> offset.method_10098(up);
            }
            InstructionBuilder instruction = instruction().offset(offset);
            switch (i) {
                case 0 -> instruction.or(ConnectedPattern.NCNN).face(left, down);
                case 1 -> instruction.or(ConnectedPattern.HHNN).face(down);
                case 2 -> instruction.or(ConnectedPattern.CNNN).face(right, down);
                case 3 -> instruction.or(ConnectedPattern.VNNV).face(right);
                case 4 -> instruction.or(ConnectedPattern.NNNC).face(right, up);
                case 5 -> instruction.or(ConnectedPattern.NNHH).face(up);
                case 6 -> instruction.or(ConnectedPattern.NNCN).face(left, up);
                case 7 -> instruction.or(ConnectedPattern.NVVN).face(left);
            }
            builder.then(instruction);
        }
        return builder.build();
    }

    interface Instruction {
        ConnectedPattern apply(ConnectedPattern pattern, class_2338 origin, class_2680 state, class_2338.class_2339 mutable, class_1920 world, AppearancePredicate predicate);
    }

    @FunctionalInterface
    public interface AppearancePredicate {
        boolean test(class_2338 origin, class_2680 originState, class_2338.class_2339 mutable, class_2680 appearanceState, class_1920 world);

        static AppearancePredicate block(class_2248 block) {
            return (origin, originState, mutable, appearanceState, world) ->
                    appearanceState.method_27852(block);
        }
    }

    public static class Builder {
        private final List<Instruction> instructions = new ArrayList<>();

        private Builder() {
        }

        private Builder(ConnectedPatternCalculator calculator) {
            this.instructions.addAll(Arrays.asList(calculator.instructions));
        }

        public Builder then(InstructionBuilder instructionBuilder) {
            this.instructions.add(instructionBuilder.build());
            return this;
        }

        public ConnectedPatternCalculator build() {
            return new ConnectedPatternCalculator(this.instructions.toArray(new Instruction[0]));
        }
    }

    public static class InstructionBuilder {
        private class_2350[] faces = new class_2350[0];
        private int x;
        private int y;
        private int z;
        private ConnectedPattern pattern = ConnectedPattern.NNNN;
        private boolean or = true;
        private boolean inverted;

        private InstructionBuilder() {
        }

        public InstructionBuilder face(class_2350... faces) {
            this.faces = faces;
            return this;
        }

        public InstructionBuilder offset(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }

        public InstructionBuilder offset(class_2382 offset) {
            return this.offset(offset.method_10263(), offset.method_10264(), offset.method_10260());
        }

        public InstructionBuilder or(ConnectedPattern pattern) {
            this.or = true;
            this.pattern = pattern;
            return this;
        }

        public InstructionBuilder and(ConnectedPattern pattern) {
            this.or = false;
            this.pattern = pattern;
            return this;
        }

        public InstructionBuilder inverted() {
            this.inverted = true;
            return this;
        }

        private Instruction build() {
            final int x = this.x;
            final int y = this.y;
            final int z = this.z;
            final ConnectedPattern connectedPattern = this.pattern;
            final boolean or = this.or;
            final boolean inverted = this.inverted;
            if(this.faces.length == 1) {
                class_2350 face = this.faces[0];
                return (pattern, origin, state, mutable, world, predicate) -> {
                    mutable.method_25504(origin, x, y, z);
                    class_2680 appearanceState = world.method_8320(mutable).getAppearance(world, mutable, face, state, origin);
                    if(predicate.test(origin, state, mutable, appearanceState, world) != inverted) {
                        return or ? pattern.or(connectedPattern) : pattern.and(connectedPattern);
                    }
                    return pattern;
                };
            }
            final class_2350[] faces = this.faces;
            return (pattern, origin, state, mutable, world, predicate) -> {
                mutable.method_25504(origin, x, y, z);
                for (class_2350 face : faces) {
                    class_2680 appearanceState = world.method_8320(mutable).getAppearance(world, mutable, face, state, origin);
                    if(predicate.test(origin, state, mutable, appearanceState, world) != inverted) {
                        return or ? pattern.or(connectedPattern) : pattern.and(connectedPattern);
                    }
                }
                return pattern;
            };
        }

    }
}
