package com.eightsidedsquare.zine.client.block;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.fabricmc.fabric.api.client.model.loading.v1.CustomUnbakedBlockStateModel;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableMesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_7775;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public class TessellatingBlockStateModel implements class_1087 {

    private final Mesh[] meshes;
    private final class_1058 particleSprite;
    private final int size;

    private TessellatingBlockStateModel(Mesh[] meshes, class_1058 particleSprite, int size) {
        this.meshes = meshes;
        this.particleSprite = particleSprite;
        this.size = size;
    }

    @Override
    public void emitQuads(QuadEmitter emitter, class_1920 blockView, class_2338 pos, class_2680 state, class_5819 random, Predicate<@Nullable class_2350> cullTest) {
        for(class_2350.class_2351 axis : class_2350.class_2351.values()) {
            int x = Math.floorMod(axis.method_10173(-1 - pos.method_10260(), pos.method_10263(), pos.method_10263()), this.size);
            int y = Math.floorMod(axis.method_10173(pos.method_10264(), pos.method_10260(), pos.method_10264()), this.size);
            this.meshes[getIndex(x, y, this.size, axis)].outputTo(emitter);
        }
    }

    @Override
    public void method_68513(class_5819 random, List<class_10889> parts) {

    }

    @Override
    public class_1058 method_68511() {
        return this.particleSprite;
    }

    private static int getIndex(int x, int y, int size, class_2350.class_2351 axis) {
        return (x + y * size) * 3 + axis.ordinal();
    }

    public record Unbaked(class_2960 texture, Optional<class_2960> particleTexture, int size) implements CustomMeshUnbakedBlockStateModel {

        public static final MapCodec<Unbaked> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
                class_2960.field_25139.fieldOf("texture").forGetter(Unbaked::texture),
                class_2960.field_25139.optionalFieldOf("particle_texture").forGetter(Unbaked::particleTexture),
                class_5699.field_33442.fieldOf("size").forGetter(Unbaked::size)
        ).apply(instance, Unbaked::new));

        public Unbaked(class_2960 texture, class_2960 particleTexture, int size) {
            this(texture, Optional.of(particleTexture), size);
        }

        public Unbaked(class_2960 texture, int size) {
            this(texture, Optional.empty(), size);
        }

        @Override
        public MapCodec<? extends CustomUnbakedBlockStateModel> codec() {
            return CODEC;
        }

        @Override
        public int getMeshCount() {
            return this.size * this.size * 3;
        }

        @Override
        public class_1087 bake(MutableMesh builder, QuadEmitter emitter, Mesh[] meshes, class_7775 baker) {
            class_1058 sprite = baker.zine$getSprite(this.texture);
            float ratio = this.size / (float) (1 << class_3532.method_15342(this.size));
            for (class_2350.class_2351 axis : class_2350.class_2351.values()) {
                for(int x = 0; x < this.size; x++) {
                    for(int y = 0; y < this.size; y++) {
                        if(axis.method_10178()) {
                            emitFace(emitter, sprite, axis.method_64922(), x, y, this.size, ratio);
                            emitFace(emitter, sprite, axis.method_64923(), x, this.size - y - 1, this.size, ratio);
                        }else {
                            emitFace(emitter, sprite, axis.method_64922(), x, this.size - y - 1, this.size, ratio);
                            emitFace(emitter, sprite, axis.method_64923(), this.size - x - 1, this.size - y - 1, this.size, ratio);
                        }
                        meshes[getIndex(x, y, this.size, axis)] = builder.immutableCopy();
                        builder.clear();
                    }
                }
            }
            class_1058 particleSprite = this.particleTexture.map(baker::zine$getSprite).orElse(sprite);
            return new TessellatingBlockStateModel(meshes, particleSprite, this.size);
        }

        private static void emitFace(QuadEmitter emitter, class_1058 sprite, class_2350 direction, int x, int y, int size, float ratio) {
            emitter.square(direction, 0, 0, 1, 1, 0);
            float u1 = (x / (float) size) * ratio;
            float u2 = ((x + 1) / (float) size) * ratio;
            float v1 = (y / (float) size) * ratio;
            float v2 = ((y + 1) / (float) size) * ratio;
            emitter.uv(0, u1, v1);
            emitter.uv(1, u1, v2);
            emitter.uv(2, u2, v2);
            emitter.uv(3, u2, v1);
            emitter.spriteBake(sprite, MutableQuadView.BAKE_NORMALIZED);
            emitter.color(-1, -1, -1, -1);
            emitter.emit();
        }
    }
}
