package com.eightsidedsquare.zine.client.data;

import net.minecraft.class_1087;
import net.minecraft.class_2248;
import net.minecraft.class_4922;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_790;
import net.minecraft.class_807;

/**
 * Helper class for instantiating different types of {@link net.minecraft.class_4917} as their names tend to be verbose
 */
public final class BlockModelDefinitions {

    /**
     * Creates a {@link class_4925.class_10796} for the given block
     */
    public static class_4925.class_10796 variants(class_2248 block) {
        return class_4925.method_67852(block);
    }

    /**
     * Creates a {@link class_4925} for the given block
     * @param map the block state variant map of weighted variants to apply
     */
    public static class_4925 variants(class_2248 block, class_4926<class_807> map) {
        return variants(block).method_67859(map);
    }

    /**
     * Creates a {@link class_4925} for the given block
     * @param variant the default variant
     */
    public static class_4925 variants(class_2248 block, class_807 variant) {
        return class_4925.method_67853(block, variant);
    }

    /**
     * Creates a {@link class_4922} for the given block
     */
    public static class_4922 multipart(class_2248 block) {
        return class_4922.method_25758(block);
    }

    /**
     * Creates a {@link CustomVariantsBlockModelDefinitionCreator} for the given block
     * @apiNote Unlike {@link class_4925}, this accepts unbaked block state models
     */
    public static CustomVariantsBlockModelDefinitionCreator.Empty customVariants(class_2248 block) {
        return CustomVariantsBlockModelDefinitionCreator.create(block);
    }

    /**
     * Creates a {@link CustomVariantsBlockModelDefinitionCreator} for the given block
     * @param map the block state variant map of unbaked block state models to apply
     * @apiNote Unlike {@link class_4925}, this accepts unbaked block state models
     */
    public static CustomVariantsBlockModelDefinitionCreator customVariants(class_2248 block, class_4926<class_1087.class_10892> map) {
        return CustomVariantsBlockModelDefinitionCreator.create(block, map);
    }

    /**
     * Creates a {@link CustomVariantsBlockModelDefinitionCreator} for the given block
     * @param model the default unbaked block state model
     * @apiNote Unlike {@link class_4925}, this accepts unbaked block state models
     */
    public static CustomVariantsBlockModelDefinitionCreator customVariants(class_2248 block, class_1087.class_10892 model) {
        return CustomVariantsBlockModelDefinitionCreator.create(block, model);
    }

    /**
     * Creates a {@link CustomMultipartBlockModelDefinitionCreator} for the given block
     * @apiNote Unlike {@link class_4922}, this accepts unbaked block state models
     */
    public static CustomMultipartBlockModelDefinitionCreator customMultipart(class_2248 block) {
        return CustomMultipartBlockModelDefinitionCreator.create(block);
    }

    /**
     * Creates a {@link DirectBlockModelDefinitionCreator} for the given block
     * @param definition the block model definition that will be created
     */
    public static DirectBlockModelDefinitionCreator direct(class_2248 block, class_790 definition) {
        return DirectBlockModelDefinitionCreator.create(block, definition);
    }

    /**
     * Creates a {@link DirectBlockModelDefinitionCreator} for the given block
     * @param variants block model variants for the block model definition that will be created
     */
    public static DirectBlockModelDefinitionCreator direct(class_2248 block, class_790.class_10888 variants) {
        return DirectBlockModelDefinitionCreator.create(block, variants);
    }

    /**
     * Creates a {@link DirectBlockModelDefinitionCreator} for the given block
     * @param multipart multipart block models for the block model definition that will be created
     */
    public static DirectBlockModelDefinitionCreator direct(class_2248 block, class_790.class_9982 multipart) {
        return DirectBlockModelDefinitionCreator.create(block, multipart);
    }

    private BlockModelDefinitions() {
    }

}
