package com.eightsidedsquare.zine.client.trim;

import com.eightsidedsquare.zine.common.util.ZineUtil;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10186;
import net.minecraft.class_10192;
import net.minecraft.class_10410;
import net.minecraft.class_10411;
import net.minecraft.class_10439;
import net.minecraft.class_10451;
import net.minecraft.class_10496;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7948;
import net.minecraft.class_8051;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_8066;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

@Environment(EnvType.CLIENT)
public final class ArmorTrimRegistryImpl {
    private ArmorTrimRegistryImpl() {
    }

    private static final class_2960 TRIM_PALETTE_KEY = class_2960.method_60656("trims/color_palettes/trim_palette");
    private static final Map<class_5321<class_8054>, Material> MATERIALS = new Object2ObjectOpenHashMap<>();
    private static final Map<class_5321<class_8056>, Pattern> PATTERNS = new Object2ObjectOpenHashMap<>();
    private static final Set<class_2960> ITEM_MODEL_EXCLUDE = new ObjectOpenHashSet<>();

    private static void registerMaterial(class_5321<class_8054> key, Material material) {
        MATERIALS.put(key, material);
    }

    static void registerMaterial(class_5321<class_8054> key, String name, class_2960 colorPaletteTexture, Map<class_8051, class_2960> equipmentItemModelIds) {
        registerMaterial(key, new Material(name, colorPaletteTexture, equipmentItemModelIds));
    }

    static void registerMaterial(class_5321<class_8054> key) {
        registerMaterial(key, key.method_29177().method_12832(), key.method_29177().method_45138("trims/color_palettes/"), createEquipmentModelIds(key));
    }

    private static void registerPattern(class_5321<class_8056> key, Pattern pattern) {
        PATTERNS.put(key, pattern);
    }

    static void registerPattern(class_5321<class_8056> key, Map<class_10186.class_10190, class_2960> equipmentTextures) {
        registerPattern(key, new Pattern(equipmentTextures));
    }

    static void registerPattern(class_5321<class_8056> key) {
        Map<class_10186.class_10190, class_2960> equipmentTextures = ImmutableMap.<class_10186.class_10190, class_2960>builder()
                .put(class_10186.class_10190.field_54125, key.method_29177().method_45138("trims/entity/humanoid/"))
                .put(class_10186.class_10190.field_54126, key.method_29177().method_45138("trims/entity/humanoid_leggings/"))
                .build();
        registerPattern(key, equipmentTextures);
    }

    static void excludeForItemModelModification(class_2960... ids) {
        ITEM_MODEL_EXCLUDE.addAll(Arrays.asList(ids));
    }

    private static Map<class_8051, class_2960> createEquipmentModelIds(class_5321<class_8054> key) {
        ImmutableMap.Builder<class_8051, class_2960> builder = ImmutableMap.builder();
        String name = key.method_29177().method_12832();
        for(class_8051 type : ZineUtil.HUMANOID_EQUIPMENT_TYPES) {
            builder.put(type, key.method_29177().method_45136("item/" + type.method_15434() + "_" + name + "_trim"));
        }
        return builder.build();
    }

    public static boolean containsMaterial(class_5321<class_8054> key) {
        return MATERIALS.containsKey(key);
    }

    public static void modifyBlocksAtlas(List<class_7948> sources) {
        modifyPalettedSource(sources, ArmorTrimRegistryImpl::applyMaterials);
    }

    public static void modifyArmorTrimsAtlas(List<class_7948> sources) {
        modifyPalettedSource(sources, source -> {
            applyMaterials(source);
            applyPatterns(source);
        });
    }

    private static void modifyPalettedSource(List<class_7948> sources, Consumer<class_8066> consumer) {
        for(class_7948 source : sources) {
            if(source instanceof class_8066 palettedSource && palettedSource.zine$getPaletteKey().equals(TRIM_PALETTE_KEY)) {
                consumer.accept(palettedSource);
            }
        }
    }

    private static void applyMaterials(class_8066 source) {
        MATERIALS.values().forEach(entry -> source.zine$addNamespacedPermutation(entry.name, entry.colorPaletteTexture));
    }

    private static void applyPatterns(class_8066 source) {
        PATTERNS.values().forEach(entry -> entry.equipmentTextures.values().forEach(source::zine$addTexture));
    }

    public static class_10439.class_10441 modifyItemModels(class_2960 id, class_10439.class_10441 unbaked) {
        if(ITEM_MODEL_EXCLUDE.contains(id)) {
            return unbaked;
        }
        class_1792 item = class_7923.field_41178.method_63535(id);
        if(!item.zine$modelEquals(id)) {
            return unbaked;
        }
        class_8051 equipmentType = getEquipmentType(item);
        if(equipmentType == null) {
            return unbaked;
        }else if(unbaked instanceof class_10451.class_10453 selectModel) {
            return applyMaterials(selectModel, equipmentType);
        }
        return unbaked;
    }

    private static class_10439.class_10441 applyMaterials(class_10451.class_10453 selectModel, class_8051 equipmentType) {
        if(selectModel.comp_3402().isEmpty()) {
            return selectModel;
        }
        class_10439.class_10441 fallback = selectModel.comp_3402().get();
        selectModel.zine$addCases(class_10496.field_55422, MATERIALS.entrySet()
                .stream()
                .map(entry -> class_10410.method_65497(
                        entry.getKey(),
                        class_10410.method_65500(
                                fallback,
                                class_10410.method_65481(entry.getValue().equipmentModelIds.get(equipmentType))
                        )
                ))
                .toList()
        );
        return selectModel;
    }


    @Nullable
    private static class_8051 getEquipmentType(class_1792 item) {
        class_10192 equippableComponent = item.method_57347().method_58694(class_9334.field_54196);
        if(equippableComponent == null) {
            return null;
        }
        return switch (equippableComponent.comp_3174()) {
            case field_6169 -> class_8051.field_41934;
            case field_6174 -> class_8051.field_41935;
            case field_6172 -> class_8051.field_41936;
            case field_6166 -> class_8051.field_41937;
            default -> null;
        };
    }

    public static void addUnbakedModels(BiConsumer<class_2960, class_10411> modelCollector) {
        for(Material entry : MATERIALS.values()) {
            for(class_8051 type : ZineUtil.HUMANOID_EQUIPMENT_TYPES) {
                class_4943.field_22938.method_25852(
                        entry.equipmentModelIds.get(type),
                        class_4944.method_25895(entry.colorPaletteTexture.method_45136("trims/items/" + type.method_15434() + "_trim_" + entry.name)),
                        modelCollector
                );
            }
        }
    }

    private record Material(String name, class_2960 colorPaletteTexture, Map<class_8051, class_2960> equipmentModelIds) {
    }

    private record Pattern(Map<class_10186.class_10190, class_2960> equipmentTextures) {
    }

}
