package com.eightsidedsquare.zine.common.entity.task;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import net.minecraft.class_1309;
import net.minecraft.class_4103;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_7893;

public final class CompositeTaskBuilderImpl<E extends class_1309> implements CompositeTaskBuilder<E> {

    private final ImmutableMap.Builder<class_4140<?>, class_4141> requiredMemories = ImmutableMap.builder();
    private final ImmutableSet.Builder<class_4140<?>> forgettingMemories = ImmutableSet.builder();
    private final ImmutableList.Builder<Pair<? extends class_7893<? super E>, Integer>> tasks = ImmutableList.builder();
    private class_4103.class_4104 order = class_4103.class_4104.field_18348;
    private class_4103.class_4216 runMode = class_4103.class_4216.field_18855;
    private int priority = 0;

    @Override
    public class_4103<E> build() {
        return new class_4103<>(this.requiredMemories.build(), this.forgettingMemories.build(), this.order, this.runMode, this.tasks.build());
    }

    @Override
    public CompositeTaskBuilder<E> task(class_7893<? super E> task) {
        return this.task(task, this.priority);
    }

    @Override
    public CompositeTaskBuilder<E> task(class_7893<? super E> task, int priority) {
        this.tasks.add(new Pair<>(task, priority));
        this.priority = priority + 1;
        return this;
    }

    @Override
    public CompositeTaskBuilder<E> memory(class_4140<?> memoryModuleType, class_4141 state) {
        this.requiredMemories.put(memoryModuleType, state);
        return this;
    }

    @Override
    public CompositeTaskBuilder<E> forgetMemory(class_4140<?> memoryModuleType) {
        this.forgettingMemories.add(memoryModuleType);
        return this;
    }

    @Override
    public CompositeTaskBuilder<E> forgetMemories(Collection<class_4140<?>> memoryModuleTypes) {
        this.forgettingMemories.addAll(memoryModuleTypes);
        return this;
    }

    @Override
    public CompositeTaskBuilder<E> order(class_4103.class_4104 order) {
        this.order = order;
        return this;
    }

    @Override
    public CompositeTaskBuilder<E> runMode(class_4103.class_4216 runMode) {
        this.runMode = runMode;
        return this;
    }
}
