package com.eightsidedsquare.zine.data.sound;

import org.jetbrains.annotations.Nullable;

import java.util.EnumMap;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2498;
import net.minecraft.class_3414;

public class BlockSoundEntriesBuilder {

    private final class_2498 blockSoundGroup;
    private final EnumMap<Type, SoundEntryBuilder> entryBuilders;

    private BlockSoundEntriesBuilder(class_2498 blockSoundGroup) {
        this.blockSoundGroup = blockSoundGroup;
        this.entryBuilders = new EnumMap<>(Type.class);
        for(Type type : Type.values()) {
            this.entryBuilders.put(type, SoundEntryBuilder
                    .of(type.get(this.blockSoundGroup))
                    .subtitle(type.getSubtitle()));
        }
    }

    public static BlockSoundEntriesBuilder of(class_2498 blockSoundGroup) {
        return new BlockSoundEntriesBuilder(blockSoundGroup);
    }

    private BlockSoundEntriesBuilder apply(Type type, Consumer<SoundEntryBuilder> consumer) {
        consumer.accept(this.entryBuilders.get(type));
        return this;
    }

    private <T> BlockSoundEntriesBuilder apply(Type type, EntryFunction<T> function, T t) {
        function.apply(this.entryBuilders.get(type), t);
        return this;
    }

    private <T1, T2> BlockSoundEntriesBuilder apply(Type type, BiEntryFunction<T1, T2> function, T1 t1, T2 t2) {
        function.apply(this.entryBuilders.get(type), t1, t2);
        return this;
    }

    private <T1, T2, T3> BlockSoundEntriesBuilder apply(Type type, TriEntryFunction<T1, T2, T3> function, T1 t1, T2 t2, T3 t3) {
        function.apply(this.entryBuilders.get(type), t1, t2, t3);
        return this;
    }

    public BlockSoundEntriesBuilder replace(Type type, boolean replace) {
        return this.apply(type, SoundEntryBuilder::replace, replace);
    }

    public BlockSoundEntriesBuilder subtitle(Type type, @Nullable String subtitle) {
        return this.apply(type, SoundEntryBuilder::subtitle, subtitle);
    }

    public BlockSoundEntriesBuilder subtitle(Type type) {
        return this.apply(type, SoundEntryBuilder::subtitle);
    }

    public BlockSoundEntriesBuilder with(Type type, SoundBuilder sound) {
        return this.apply(type, SoundEntryBuilder::with, sound);
    }

    public BlockSoundEntriesBuilder with(Type type, SoundBuilder sound, Consumer<SoundBuilder> consumer) {
        return this.apply(type, SoundEntryBuilder::with, sound, consumer);
    }

    public BlockSoundEntriesBuilder with(Type type, String name) {
        return this.apply(type, SoundEntryBuilder::with, name);
    }

    public BlockSoundEntriesBuilder with(Type type, String name, Consumer<SoundBuilder> consumer) {
        return this.apply(type, SoundEntryBuilder::with, name, consumer);
    }

    public BlockSoundEntriesBuilder with(Type type, class_3414 source) {
        return this.apply(type, SoundEntryBuilder::with, source);
    }

    public BlockSoundEntriesBuilder with(Type type, class_3414 source, Consumer<SoundBuilder> consumer) {
        return this.apply(type, SoundEntryBuilder::with, source, consumer);
    }

    public BlockSoundEntriesBuilder with(Type type) {
        return this.apply(type, SoundEntryBuilder::with);
    }

    public BlockSoundEntriesBuilder with(Type type, Consumer<SoundBuilder> consumer) {
        return this.apply(type, SoundEntryBuilder::with, consumer);
    }

    public BlockSoundEntriesBuilder with(Type type, Type source) {
        return this.apply(type, SoundEntryBuilder::with, source.get(this.blockSoundGroup));
    }

    public BlockSoundEntriesBuilder with(Type type, Type source, Consumer<SoundBuilder> consumer) {
        return this.apply(type, SoundEntryBuilder::with, source.get(this.blockSoundGroup), consumer);
    }

    public BlockSoundEntriesBuilder withSuffixed(Type type, String name, String suffix) {
        return this.apply(type, SoundEntryBuilder::withSuffixed, name, suffix);
    }

    public BlockSoundEntriesBuilder withSuffixed(Type type, String name, String suffix, Consumer<SoundBuilder> consumer) {
        return this.apply(type, SoundEntryBuilder::withSuffixed, name, suffix, consumer);
    }

    public BlockSoundEntriesBuilder withSuffixed(Type type, class_3414 source, String suffix) {
        return this.apply(type, SoundEntryBuilder::withSuffixed, source, suffix);
    }

    public BlockSoundEntriesBuilder withSuffixed(Type type, class_3414 source, String suffix, Consumer<SoundBuilder> consumer) {
        return this.apply(type, SoundEntryBuilder::withSuffixed, source, suffix, consumer);
    }

    public BlockSoundEntriesBuilder withSuffixed(Type type, String suffix) {
        return this.apply(type, SoundEntryBuilder::withSuffixed, suffix);
    }

    public BlockSoundEntriesBuilder withSuffixed(Type type, String suffix, Consumer<SoundBuilder> consumer) {
        return this.apply(type, SoundEntryBuilder::withSuffixed, suffix, consumer);
    }

    public BlockSoundEntriesBuilder withSuffixed(Type type, Type source, String suffix) {
        return this.apply(type, SoundEntryBuilder::withSuffixed, source.get(this.blockSoundGroup), suffix);
    }

    public BlockSoundEntriesBuilder withSuffixed(Type type, Type source, String suffix, Consumer<SoundBuilder> consumer) {
        return this.apply(type, SoundEntryBuilder::withSuffixed, source.get(this.blockSoundGroup), suffix, consumer);
    }

    public BlockSoundEntriesBuilder withVariants(Type type, String name, int variants) {
        return this.apply(type, SoundEntryBuilder::withVariants, name, variants);
    }

    public BlockSoundEntriesBuilder withVariants(Type type, String name, int variants, Consumer<SoundBuilder> consumer) {
        return this.apply(type, SoundEntryBuilder::withVariants, name, variants, consumer);
    }

    public BlockSoundEntriesBuilder withVariants(Type type, class_3414 source, int variants) {
        return this.apply(type, SoundEntryBuilder::withVariants, source, variants);
    }

    public BlockSoundEntriesBuilder withVariants(Type type, class_3414 source, int variants, Consumer<SoundBuilder> consumer) {
        return this.apply(type, SoundEntryBuilder::withVariants, source, variants, consumer);
    }

    public BlockSoundEntriesBuilder withVariants(Type type, int variants) {
        return this.apply(type, SoundEntryBuilder::withVariants, variants);
    }

    public BlockSoundEntriesBuilder withVariants(Type type, int variants, Consumer<SoundBuilder> consumer) {
        return this.apply(type, SoundEntryBuilder::withVariants, variants, consumer);
    }

    public BlockSoundEntriesBuilder withVariants(Type type, Type source, int variants) {
        return this.apply(type, SoundEntryBuilder::withVariants, source.get(this.blockSoundGroup), variants);
    }

    public BlockSoundEntriesBuilder withVariants(Type type, Type source, int variants, Consumer<SoundBuilder> consumer) {
        return this.apply(type, SoundEntryBuilder::withVariants, source.get(this.blockSoundGroup), variants, consumer);
    }

    public BlockSoundEntriesBuilder withVariants(Type type, class_3414 event) {
        return this.apply(type, SoundEntryBuilder::withEvent, event);
    }

    public BlockSoundEntriesBuilder withVariants(Type type, class_3414 event, Consumer<SoundBuilder> consumer) {
        return this.apply(type, SoundEntryBuilder::withEvent, event, consumer);
    }

    public void offerTo(SoundEntryConsumer consumer) {
        for(SoundEntryBuilder soundEntryBuilder : this.entryBuilders.values()) {
            soundEntryBuilder.offerTo(consumer);
        }
    }

    public enum Type {
        BREAK("block.generic.break", class_2498::method_10595),
        PLACE("block.generic.place", class_2498::method_10598),
        HIT("block.generic.hit", class_2498::method_10596),
        STEP("block.generic.footsteps", class_2498::method_10594),
        FALL(class_2498::method_10593);

        @Nullable
        private final String subtitle;
        private final Function<class_2498, class_3414> soundEventGetter;

        Type(@Nullable String subtitle, Function<class_2498, class_3414> soundEventGetter) {
            this.subtitle = subtitle;
            this.soundEventGetter = soundEventGetter;
        }

        Type(Function<class_2498, class_3414> soundEventGetter) {
            this(null, soundEventGetter);
        }

        @Nullable
        public String getSubtitle() {
            return this.subtitle;
        }

        public class_3414 get(class_2498 blockSoundGroup) {
            return this.soundEventGetter.apply(blockSoundGroup);
        }
    }

    private interface EntryFunction<T> {
        void apply(SoundEntryBuilder soundEntryBuilder, T t);
    }

    private interface BiEntryFunction<T1, T2> {
        void apply(SoundEntryBuilder soundEntryBuilder, T1 t1, T2 t2);
    }

    private interface TriEntryFunction<T1, T2, T3>  {
        void apply(SoundEntryBuilder soundEntryBuilder, T1 t1, T2 t2, T3 t3);
    }

}
