package com.eightsidedsquare.zine.data.sound;

import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import net.minecraft.class_3414;

public class SoundEntryBuilder {

    private final class_3414 soundEvent;
    private final List<SoundBuilder> sounds = new ArrayList<>();
    private boolean replace = false;
    @Nullable
    private String subtitle = null;

    private SoundEntryBuilder(class_3414 soundEvent) {
        this.soundEvent = soundEvent;
    }

    public static SoundEntryBuilder of(class_3414 soundEvent) {
        return new SoundEntryBuilder(soundEvent);
    }

    public SoundEntryBuilder replace(boolean replace) {
        this.replace = replace;
        return this;
    }

    public SoundEntryBuilder subtitle(@Nullable String subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    public SoundEntryBuilder subtitle() {
        return this.subtitle(this.soundEvent.comp_3319().method_12832());
    }

    public SoundEntryBuilder with(SoundBuilder sound) {
        this.sounds.add(sound);
        return this;
    }

    public SoundEntryBuilder with(SoundBuilder sound, Consumer<SoundBuilder> consumer) {
        consumer.accept(sound);
        this.sounds.add(sound);
        return this;
    }

    public SoundEntryBuilder with(String name) {
        return this.with(SoundBuilder.of(name));
    }

    public SoundEntryBuilder with(String name, Consumer<SoundBuilder> consumer) {
        return this.with(SoundBuilder.of(name), consumer);
    }

    public SoundEntryBuilder with(class_3414 source) {
        return this.with(source.comp_3319().toString());
    }

    public SoundEntryBuilder with(class_3414 source, Consumer<SoundBuilder> consumer) {
        return this.with(source.comp_3319().toString(), consumer);
    }

    public SoundEntryBuilder with() {
        return this.with(this.soundEvent);
    }

    public SoundEntryBuilder with(Consumer<SoundBuilder> consumer) {
        return this.with(this.soundEvent, consumer);
    }

    public SoundEntryBuilder withSuffixed(String name, String suffix) {
        return this.with(name + suffix);
    }

    public SoundEntryBuilder withSuffixed(String name, String suffix, Consumer<SoundBuilder> consumer) {
        return this.with(name + suffix, consumer);
    }

    public SoundEntryBuilder withSuffixed(class_3414 source, String suffix) {
        return this.withSuffixed(source.comp_3319().toString(), suffix);
    }

    public SoundEntryBuilder withSuffixed(class_3414 source, String suffix, Consumer<SoundBuilder> consumer) {
        return this.withSuffixed(source.comp_3319().toString(), suffix, consumer);
    }

    public SoundEntryBuilder withSuffixed(String suffix) {
        return this.withSuffixed(this.soundEvent, suffix);
    }

    public SoundEntryBuilder withSuffixed(String suffix, Consumer<SoundBuilder> consumer) {
        return this.withSuffixed(this.soundEvent, suffix, consumer);
    }

    private SoundEntryBuilder withVariants(IntConsumer consumer, int variants) {
        if(variants < 1) {
            return this;
        }
        for(int variant = 1; variant <= variants; variant++) {
            consumer.accept(variant);
        }
        return this;
    }

    public SoundEntryBuilder withVariants(String name, int variants) {
        return this.withVariants(variant -> this.withSuffixed(name, String.valueOf(variant)), variants);
    }

    public SoundEntryBuilder withVariants(String name, int variants, Consumer<SoundBuilder> consumer) {
        return this.withVariants(variant -> this.withSuffixed(name, String.valueOf(variant), consumer), variants);
    }

    public SoundEntryBuilder withVariants(class_3414 source, int variants) {
        return this.withVariants(variant -> this.withSuffixed(source, String.valueOf(variant)), variants);
    }

    public SoundEntryBuilder withVariants(class_3414 source, int variants, Consumer<SoundBuilder> consumer) {
        return this.withVariants(variant -> this.withSuffixed(source, String.valueOf(variant), consumer), variants);
    }

    public SoundEntryBuilder withVariants(int variants) {
        return this.withVariants(variant -> this.withSuffixed(String.valueOf(variant)), variants);
    }

    public SoundEntryBuilder withVariants(int variants, Consumer<SoundBuilder> consumer) {
        return this.withVariants(variant -> this.withSuffixed(String.valueOf(variant), consumer), variants);
    }

    public SoundEntryBuilder withEvent(class_3414 event) {
        return this.with(SoundBuilder.of(event.comp_3319().toString(), SoundBuilder.Type.SOUND_EVENT));
    }

    public SoundEntryBuilder withEvent(class_3414 event, Consumer<SoundBuilder> consumer) {
        return this.with(SoundBuilder.of(event.comp_3319().toString(), SoundBuilder.Type.SOUND_EVENT), consumer);
    }

    @Nullable
    private String getSubtitleName() {
        return this.subtitle == null ? null : "subtitles." + this.subtitle;
    }

    public void offerTo(SoundEntryConsumer soundEntryConsumer) {
        List<SoundBuilder> sounds = this.sounds.stream().toList();
        soundEntryConsumer.accept(this.soundEvent, new SoundEntryRecord(sounds, this.replace, this.getSubtitleName()));
    }
}
