package com.eightsidedsquare.zine.mixin.advancement;

import com.eightsidedsquare.zine.common.advancement.ZineAdvancementDisplay;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_185;
import net.minecraft.class_189;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

@Mixin(class_185.class)
public abstract class AdvancementDisplayMixin implements ZineAdvancementDisplay {

    @Shadow @Final @Mutable
    private class_2561 title;

    @Shadow @Final @Mutable
    private class_2561 description;

    @Shadow @Final @Mutable
    private class_1799 icon;

    @Shadow @Final @Mutable
    private Optional<class_2960> background;

    @Shadow @Final @Mutable
    private class_189 frame;

    @Shadow @Final @Mutable
    private boolean showToast;

    @Shadow @Final @Mutable
    private boolean announceToChat;

    @Shadow @Final @Mutable
    private boolean hidden;

    @Override
    public void zine$setTitle(class_2561 title) {
        this.title = title;
    }

    @Override
    public void zine$setDescription(class_2561 description) {
        this.description = description;
    }

    @Override
    public void zine$setIcon(class_1799 icon) {
        this.icon = icon;
    }

    @Override
    public void zine$setBackground(@Nullable class_2960 background) {
        this.background = Optional.ofNullable(background);
    }

    @Override
    public void zine$setFrame(class_189 frame) {
        this.frame = frame;
    }

    @Override
    public void zine$setShowToast(boolean showToast) {
        this.showToast = showToast;
    }

    @Override
    public void zine$setAnnounceToChat(boolean announceToChat) {
        this.announceToChat = announceToChat;
    }

    @Override
    public void zine$setHidden(boolean hidden) {
        this.hidden = hidden;
    }
}
