package com.eightsidedsquare.zine.mixin.advancement;

import com.eightsidedsquare.zine.common.advancement.ZineAdvancement;
import com.eightsidedsquare.zine.common.util.ZineUtil;
import net.minecraft.advancement.*;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_179;
import net.minecraft.class_184;
import net.minecraft.class_185;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_8782;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Map;
import java.util.Optional;

@Mixin(class_161.class)
public abstract class AdvancementMixin implements ZineAdvancement {

    @Shadow @Final @Mutable
    private Optional<class_2960> parent;

    @Shadow @Final @Mutable
    private Optional<class_185> display;

    @Shadow @Final @Mutable
    private class_170 rewards;

    @Shadow @Final @Mutable
    private Map<String, class_175<?>> criteria;

    @Shadow @Final @Mutable
    private boolean sendsTelemetryEvent;

    @Shadow @Final @Mutable
    private Optional<class_2561> name;

    @Shadow @Final @Mutable
    private class_8782 requirements;

    @Override
    public void zine$setParent(@Nullable class_2960 parent) {
        this.parent = Optional.ofNullable(parent);
    }

    @Override
    public void zine$setDisplay(@Nullable class_185 display) {
        this.display = Optional.ofNullable(display);
    }

    @Override
    public void zine$setRewards(class_170 rewards) {
        this.rewards = rewards;
    }

    @Override
    public void zine$addCriterion(String name, class_175<?> criterion) {
        this.criteria = ZineUtil.putOrUnfreeze(this.criteria, name, criterion);
    }

    @Override
    public void zine$setCriteria(Map<String, class_175<?>> criteria) {
        this.criteria = criteria;
    }

    @Override
    public void zine$setRequirements(class_8782 requirements) {
        this.requirements = requirements;
    }

    @Override
    public void zine$setSendsTelemetryEvent(boolean sendsTelemetryEvent) {
        this.sendsTelemetryEvent = sendsTelemetryEvent;
    }

    @Override
    public void zine$setName(@Nullable class_2561 name) {
        this.name = Optional.ofNullable(name);
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T extends class_184> Optional<T> zine$getCriterion(String name, class_179<T> criterion) {
        class_175<?> advancementCriterion = this.criteria.get(name);
        if(advancementCriterion != null && advancementCriterion.comp_1923().equals(criterion)) {
            return Optional.of((T) advancementCriterion.comp_1924());
        }
        return Optional.empty();
    }
}
