package com.eightsidedsquare.zine.mixin.advancement;

import com.eightsidedsquare.zine.common.advancement.ZineAdvancementRewards;
import com.eightsidedsquare.zine.common.util.ZineUtil;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_170;
import net.minecraft.class_1860;
import net.minecraft.class_2159;
import net.minecraft.class_52;
import net.minecraft.class_5321;

@Mixin(class_170.class)
public abstract class AdvancementRewardsMixin implements ZineAdvancementRewards {

    @Shadow @Final @Mutable
    private int experience;

    @Shadow @Final @Mutable
    private List<class_5321<class_52>> loot;

    @Shadow @Final @Mutable
    private List<class_5321<class_1860<?>>> recipes;

    @Shadow @Final @Mutable
    private Optional<class_2159> function;

    @Override
    public void zine$setExperience(int experience) {
        this.experience = experience;
    }

    @Override
    public void zine$setLoot(List<class_5321<class_52>> loot) {
        this.loot = loot;
    }

    @Override
    public void zine$addLootTable(class_5321<class_52> lootTable) {
        this.loot = ZineUtil.addOrUnfreeze(this.loot, lootTable);
    }

    @Override
    public void zine$addLootTables(List<class_5321<class_52>> lootTables) {
        this.loot = ZineUtil.addAllOrUnfreeze(this.loot, lootTables);
    }

    @Override
    public void zine$setRecipes(List<class_5321<class_1860<?>>> recipes) {
        this.recipes = recipes;
    }

    @Override
    public void zine$addRecipe(class_5321<class_1860<?>> recipe) {
        this.recipes = ZineUtil.addOrUnfreeze(this.recipes, recipe);
    }

    @Override
    public void zine$addRecipes(List<class_5321<class_1860<?>>> recipes) {
        this.recipes = ZineUtil.addAllOrUnfreeze(this.recipes, recipes);
    }

    @Override
    public void zine$setFunction(@Nullable class_2159 function) {
        this.function = Optional.ofNullable(function);
    }
}
