package com.eightsidedsquare.zine.mixin.advancement.criterion;

import com.eightsidedsquare.zine.common.criterion.ZineBeeNestDestroyedCriterionConditions;
import com.eightsidedsquare.zine.common.criterion.ZineBlockCriterionConditions;
import com.eightsidedsquare.zine.common.criterion.ZineItemCriterionConditions;
import com.eightsidedsquare.zine.common.criterion.ZinePlayerCriterionConditions;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Optional;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_2248;
import net.minecraft.class_4708;
import net.minecraft.class_5258;
import net.minecraft.class_6880;

@Mixin(class_4708.class_4709.class)
public abstract class BeeNestDestroyedCriterionConditionsMixin implements
        ZinePlayerCriterionConditions,
        ZineBlockCriterionConditions,
        ZineItemCriterionConditions,
        ZineBeeNestDestroyedCriterionConditions {

    @Shadow @Final @Mutable
    private Optional<class_5258> player;

    @Shadow @Final @Mutable
    private Optional<class_6880<class_2248>> block;

    @Shadow @Final @Mutable
    private Optional<class_2073> item;

    @Shadow @Final @Mutable
    private class_2096.class_2100 beesInside;

    @Override
    public void zine$setPlayer(@Nullable class_5258 player) {
        this.player = Optional.ofNullable(player);
    }

    @Override
    public void zine$setBlock(@Nullable class_6880<class_2248> block) {
        this.block = Optional.ofNullable(block);
    }

    @Override
    public void zine$setItem(@Nullable class_2073 item) {
        this.item = Optional.ofNullable(item);
    }

    @Override
    public void zine$setBeesInside(class_2096.class_2100 beesInside) {
        this.beesInside = beesInside;
    }
}
