package com.eightsidedsquare.zine.mixin.advancement.criterion;

import com.eightsidedsquare.zine.common.criterion.ZineEffectsChangedCriterionConditions;
import com.eightsidedsquare.zine.common.criterion.ZinePlayerCriterionConditions;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Optional;
import net.minecraft.class_2027;
import net.minecraft.class_2102;
import net.minecraft.class_5258;

@Mixin(class_2027.class_2029.class)
public abstract class EffectsChangedCriterionConditionsMixin implements ZinePlayerCriterionConditions,
        ZineEffectsChangedCriterionConditions {

    @Shadow @Final @Mutable
    private Optional<class_5258> player;

    @Shadow @Final @Mutable
    private Optional<class_2102> effects;

    @Shadow @Final @Mutable
    private Optional<class_5258> source;

    @Override
    public void zine$setPlayer(@Nullable class_5258 player) {
        this.player = Optional.ofNullable(player);
    }

    @Override
    public void zine$setEffects(@Nullable class_2102 effects) {
        this.effects = Optional.ofNullable(effects);
    }

    @Override
    public void zine$setSource(@Nullable class_5258 source) {
        this.source = Optional.ofNullable(source);
    }
}
