package com.eightsidedsquare.zine.mixin.advancement.criterion;

import com.eightsidedsquare.zine.common.criterion.ZineDistanceCriterionConditions;
import com.eightsidedsquare.zine.common.criterion.ZineFallAfterExplosionCriterionConditions;
import com.eightsidedsquare.zine.common.criterion.ZinePlayerCriterionConditions;
import com.eightsidedsquare.zine.common.criterion.ZineStartPositionCriterionConditions;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Optional;
import net.minecraft.class_2025;
import net.minecraft.class_2090;
import net.minecraft.class_5258;
import net.minecraft.class_9421;

@Mixin(class_9421.class_9422.class)
public abstract class FallAfterExplosionCriterionConditionsMixin implements ZinePlayerCriterionConditions,
        ZineStartPositionCriterionConditions,
        ZineDistanceCriterionConditions,
        ZineFallAfterExplosionCriterionConditions {

    @Shadow @Final @Mutable
    private Optional<class_5258> player;

    @Shadow @Final @Mutable
    private Optional<class_2090> startPosition;

    @Shadow @Final @Mutable
    private Optional<class_2025> distance;

    @Shadow @Final @Mutable
    private Optional<class_5258> cause;

    @Override
    public void zine$setPlayer(@Nullable class_5258 player) {
        this.player = Optional.ofNullable(player);
    }

    @Override
    public void zine$setStartPosition(@Nullable class_2090 startPosition) {
        this.startPosition = Optional.ofNullable(startPosition);
    }

    @Override
    public void zine$setDistance(@Nullable class_2025 distance) {
        this.distance = Optional.ofNullable(distance);
    }

    @Override
    public void zine$setCause(@Nullable class_5258 cause) {
        this.cause = Optional.ofNullable(cause);
    }
}
